/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractUnIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public class LessOrEqualXC
extends AbstractUnIntSConstraint {
    protected final int cste;

    public LessOrEqualXC(IntDomainVar x0, int c) {
        super(x0);
        this.v0 = x0;
        this.cste = c;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String pretty() {
        return this.v0 + " <= " + this.cste;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("VAL(" + this.v0.toString() + ") <= " + this.cste);
        }
        this.v0.updateSup(this.cste, this.cIdx0);
        this.setEntailed();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        assert (idx == 0);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("VAL(" + this.v0.toString() + ") <= " + this.cste);
        }
        if (this.v0.getVal() > this.cste) {
            this.fail();
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.getSup() <= this.cste) {
            return Boolean.TRUE;
        }
        if (this.v0.getInf() > this.cste) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] <= this.cste;
    }

    @Override
    public boolean isConsistent() {
        return this.v0.getSup() <= this.cste;
    }

    @Override
    public AbstractSConstraint opposite() {
        Solver solver = this.getSolver();
        return (AbstractSConstraint)solver.gt((IntExp)this.v0, this.cste);
    }
}

