/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class InverseChanneling
extends AbstractLargeIntSConstraint {
    protected int n;

    public InverseChanneling(IntDomainVar[] allVars, int n) {
        super(allVars);
        this.cste = allVars[0].getInf();
        this.n = n;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (this.vars[idx].hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public void propagate() throws ContradictionException {
        for (int idx = 0; idx < this.vars.length; ++idx) {
            for (int i = 0; i < this.n; ++i) {
                if (idx < this.n && !this.vars[idx].canBeInstantiatedTo(i + this.cste)) {
                    this.vars[i + this.n].removeVal(idx + this.cste, this.cIndices[i + this.n]);
                    continue;
                }
                if (this.vars[idx].canBeInstantiatedTo(i + this.cste)) continue;
                this.vars[i].removeVal(idx - this.n + this.cste, this.cIndices[i]);
            }
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        int val = this.vars[idx].getInf() - this.cste;
        if (idx < this.n) {
            for (int i = 0; i < val; ++i) {
                this.vars[i + this.n].removeVal(idx + this.cste, this.cIndices[i + this.n]);
            }
        } else {
            for (int i = 0; i < val; ++i) {
                this.vars[i].removeVal(idx - this.n + this.cste, this.cIndices[i]);
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        int val = this.vars[idx].getSup() + 1 - this.cste;
        if (idx < this.n) {
            for (int i = val; i < this.n; ++i) {
                this.vars[i + this.n].removeVal(idx + this.cste, this.cIndices[i + this.n]);
            }
        } else {
            for (int i = val; i < this.n; ++i) {
                this.vars[i].removeVal(idx - this.n + this.cste, this.cIndices[i]);
            }
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        int val = this.vars[idx].getVal() - this.cste;
        if (idx < this.n) {
            this.vars[val + this.n].instantiate(idx + this.cste, this.cIndices[val + this.n]);
            for (int i = 0; i < this.n; ++i) {
                if (i == idx) continue;
                this.vars[i].removeVal(val + this.cste, this.cIndices[i]);
            }
        } else {
            this.vars[val].instantiate(idx - this.n + this.cste, this.cIndices[val]);
            for (int i = this.n; i < 2 * this.n; ++i) {
                if (i == idx) continue;
                this.vars[i].removeVal(val + this.cste, this.cIndices[i]);
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx < this.n) {
            this.vars[x - this.cste + this.n].removeVal(idx + this.cste, this.cIndices[x - this.cste + this.n]);
        } else {
            this.vars[x - this.cste].removeVal(idx - this.n + this.cste, this.cIndices[x - this.cste]);
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int i = 0; i < this.n; ++i) {
            int x = tuple[i];
            if (tuple[x - this.cste + this.n] == i + this.cste) continue;
            return false;
        }
        return true;
    }

    @Override
    public String pretty() {
        IntDomainVar var;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("InverseChanneling({");
        for (i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = this.vars[i];
            sb.append(var.pretty());
        }
        sb.append("}, {");
        for (i = 0; i < this.n; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            var = this.vars[this.n + i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

