/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.Arithm;
import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public class IntLinComb
extends AbstractLargeIntSConstraint {
    public static final int EQ = 0;
    public static final int GEQ = 1;
    public static final int NEQ = 2;
    public static final int LEQ = 3;
    protected final int op;
    protected int[] coeffs;
    protected final int nbPosVars;
    protected final int cste;

    public IntLinComb(IntDomainVar[] lvars, int[] lcoeffs, int nbPositive, int c, int linOperator) {
        super(lvars);
        this.init(lcoeffs);
        this.nbPosVars = nbPositive;
        this.op = linOperator;
        this.cste = c;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        IntLinComb newc = (IntLinComb)super.clone();
        newc.init(this.coeffs);
        return newc;
    }

    public void init(int[] lcoeffs) {
        this.coeffs = new int[lcoeffs.length];
        System.arraycopy(lcoeffs, 0, this.coeffs, 0, lcoeffs.length);
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter(true, 2);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx < this.nbPosVars) {
            this.filter(true, 1);
        } else {
            this.filter(false, 1);
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx < this.nbPosVars) {
            this.filter(false, 1);
        } else {
            this.filter(true, 1);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public Boolean isEntailed() {
        if (this.op == 0) {
            int a = this.computeLowerBound();
            int b = this.computeUpperBound();
            if (b < 0 || a > 0) {
                return Boolean.FALSE;
            }
            if (a == 0 && b == 0) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (this.op == 1) {
            if (this.computeUpperBound() < 0) {
                return Boolean.FALSE;
            }
            if (this.computeLowerBound() >= 0) {
                return Boolean.TRUE;
            }
            return null;
        }
        assert (this.op == 2);
        int a = this.computeLowerBound();
        if (a > 0) {
            return Boolean.TRUE;
        }
        int b = this.computeUpperBound();
        if (b < 0) {
            return Boolean.TRUE;
        }
        if (b == 0 && a == 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int s = this.cste;
        int nbVars = this.getNbVars();
        for (int i = 0; i < nbVars; ++i) {
            s += tuple[i] * this.coeffs[i];
        }
        if (this.op == 0) {
            return s == 0;
        }
        if (this.op == 1) {
            return s >= 0;
        }
        assert (this.op == 2);
        return s != 0;
    }

    protected int computeUpperBound() {
        int i;
        int s = this.cste;
        int nbVars = this.getNbVars();
        for (i = 0; i < this.nbPosVars; ++i) {
            s += this.vars[i].getSup() * this.coeffs[i];
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            s += this.vars[i].getInf() * this.coeffs[i];
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ub for " + this.toString() + ": " + s);
        }
        return s;
    }

    protected int computeLowerBound() {
        int i;
        int s = this.cste;
        int nbVars = this.getNbVars();
        for (i = 0; i < this.nbPosVars; ++i) {
            s += this.vars[i].getInf() * this.coeffs[i];
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            s += this.vars[i].getSup() * this.coeffs[i];
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("lb for " + this.toString() + ": " + s);
        }
        return s;
    }

    protected void filter(boolean startWithLB, int minNbRules) throws ContradictionException {
        boolean lastRuleEffective = true;
        boolean nextRuleIsLB = startWithLB;
        for (int nbr = 0; lastRuleEffective || nbr < minNbRules; ++nbr) {
            if (nextRuleIsLB) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("-- LB propagation for " + this.toString());
                }
                lastRuleEffective = this.filterOnImprovedLowerBound();
            } else {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("-- UB propagation for " + this.toString());
                }
                lastRuleEffective = this.filterOnImprovedUpperBound();
            }
            nextRuleIsLB = !nextRuleIsLB;
        }
    }

    protected boolean filterOnImprovedLowerBound() throws ContradictionException {
        if (this.op == 0) {
            return this.propagateNewLowerBound(this.computeLowerBound());
        }
        if (this.op == 1) {
            return false;
        }
        assert (this.op == 2);
        int mylb = this.computeLowerBound();
        if (mylb == 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("propagate > 0 for " + this.toString());
            }
            return this.propagateNewUpperBound(this.computeUpperBound() - 1);
        }
        return false;
    }

    protected boolean filterOnImprovedUpperBound() throws ContradictionException {
        int myub = this.computeUpperBound();
        if (this.op == 0) {
            return this.propagateNewUpperBound(myub);
        }
        if (this.op == 1) {
            return this.propagateNewUpperBound(myub);
        }
        assert (this.op == 2);
        if (myub == 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("propagate < 0 for " + this.toString());
            }
            return this.propagateNewLowerBound(this.computeLowerBound() + 1);
        }
        return false;
    }

    protected boolean propagateNewLowerBound(int mylb) throws ContradictionException {
        int i;
        boolean anyChange = false;
        int nbVars = this.getNbVars();
        if (mylb > 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("lb = " + mylb + " > 0 => fail");
            }
            this.fail();
        }
        for (i = 0; i < this.nbPosVars; ++i) {
            int newSupi = Arithm.divFloor(-mylb, this.coeffs[i]) + this.vars[i].getInf();
            if (!this.vars[i].updateSup(newSupi, this.cIndices[i])) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("SUP(" + this.vars[i].toString() + ") <= " + -mylb + "/" + this.coeffs[i] + " + " + this.vars[i].getInf() + " = " + newSupi);
            }
            anyChange = true;
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            int newInfi = Arithm.divCeil(mylb, -this.coeffs[i]) + this.vars[i].getSup();
            if (!this.vars[i].updateInf(newInfi, this.cIndices[i])) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("INF(" + this.vars[i].toString() + ") >= " + mylb + "/" + -this.coeffs[i] + " + " + this.vars[i].getSup() + " = " + newInfi);
            }
            anyChange = true;
        }
        return anyChange;
    }

    protected boolean propagateNewUpperBound(int myub) throws ContradictionException {
        int i;
        boolean anyChange = false;
        int nbVars = this.getNbVars();
        if (myub < 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("ub = " + myub + " < 0 => fail");
            }
            this.fail();
        }
        for (i = 0; i < this.nbPosVars; ++i) {
            int newInfi = Arithm.divCeil(-myub, this.coeffs[i]) + this.vars[i].getSup();
            if (!this.vars[i].updateInf(newInfi, this.cIndices[i])) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("INF(" + this.vars[i].toString() + ") >= " + -myub + "/" + this.coeffs[i] + " + " + this.vars[i].getSup() + " = " + newInfi);
            }
            anyChange = true;
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            int newSupi = Arithm.divFloor(myub, -this.coeffs[i]) + this.vars[i].getInf();
            if (!this.vars[i].updateSup(newSupi, this.cIndices[i])) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("SUP(" + this.vars[i].toString() + ") <= " + myub + "/" + -this.coeffs[i] + " + " + this.vars[i].getInf() + " = " + newSupi);
            }
            anyChange = true;
        }
        return anyChange;
    }

    @Override
    public boolean isConsistent() {
        if (this.op == 0) {
            return this.hasConsistentLowerBound() && this.hasConsistentUpperBound();
        }
        if (this.op == 1) {
            return this.hasConsistentUpperBound();
        }
        return true;
    }

    protected boolean hasConsistentLowerBound() {
        int i;
        int lb = this.computeLowerBound();
        int nbVars = this.getNbVars();
        if (lb > 0) {
            return false;
        }
        for (i = 0; i < this.nbPosVars; ++i) {
            int newSupi = Arithm.divFloor(-lb, this.coeffs[i]) + this.vars[i].getInf();
            if (this.vars[i].getSup() >= newSupi) continue;
            return false;
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            int newInfi = Arithm.divCeil(lb, -this.coeffs[i]) + this.vars[i].getSup();
            if (this.vars[i].getInf() <= newInfi) continue;
            return false;
        }
        return true;
    }

    protected boolean hasConsistentUpperBound() {
        int i;
        int ub = this.computeUpperBound();
        int nbVars = this.getNbVars();
        if (ub < 0) {
            return false;
        }
        for (i = 0; i < this.nbPosVars; ++i) {
            int newInfi = Arithm.divCeil(-ub, this.coeffs[i]) + this.vars[i].getSup();
            if (this.vars[i].getInf() <= newInfi) continue;
            return false;
        }
        for (i = this.nbPosVars; i < nbVars; ++i) {
            int newSupi = Arithm.divFloor(ub, -this.coeffs[i]) + this.vars[i].getInf();
            if (this.vars[i].getSup() >= newSupi) continue;
            return false;
        }
        return true;
    }

    @Override
    public AbstractSConstraint opposite() {
        Solver solver = this.getSolver();
        IntExp term = solver.scalar(this.coeffs, this.vars);
        if (this.op == 0) {
            return (AbstractSConstraint)solver.neq(term, -this.cste);
        }
        if (this.op == 2) {
            return (AbstractSConstraint)solver.eq(term, -this.cste);
        }
        if (this.op == 1) {
            return (AbstractSConstraint)solver.lt(term, -this.cste);
        }
        return null;
    }

    @Override
    public String pretty() {
        String linComb = "";
        for (int i = 0; i < this.coeffs.length - 1; ++i) {
            linComb = linComb + this.coeffs[i] + "*" + this.vars[i] + " + ";
        }
        linComb = linComb + this.coeffs[this.coeffs.length - 1] + "*" + this.vars[this.coeffs.length - 1];
        if (this.op == 0) {
            linComb = linComb + " = ";
        } else if (this.op == 1) {
            linComb = linComb + " >= ";
        } else if (this.op == 2) {
            linComb = linComb + " != ";
        }
        linComb = linComb + -this.cste;
        return linComb;
    }
}

