/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.Arithm;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public class GreaterOrEqualXYC
extends AbstractBinIntSConstraint {
    protected final int cste;

    public GreaterOrEqualXYC(IntDomainVar x0, IntDomainVar x1, int c) {
        super(x0, x1);
        this.cste = c;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.awakeOnInf(1);
        this.awakeOnSup(0);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 1) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INF(" + this.v0.toString() + ") >= INF(" + this.v1.toString() + ") + " + this.cste);
            }
            this.v0.updateInf(this.v1.getInf() + this.cste, this.cIdx0);
        } else if (this.v0.getInf() >= this.v1.getSup() + this.cste) {
            this.setEntailed();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("SUP(" + this.v1.toString() + ") <= SUP(" + this.v0.toString() + ") - " + this.cste);
            }
            this.v1.updateSup(this.v0.getSup() - this.cste, this.cIdx1);
        } else if (this.v0.getInf() >= this.v1.getSup() + this.cste) {
            this.setEntailed();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("SUP(" + this.v1.toString() + ") <= SUP(" + this.v0.toString() + ") - " + this.cste);
            }
            this.v1.updateSup(this.v0.getSup() - this.cste, this.cIdx1);
        } else if (idx == 1) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INF(" + this.v0.toString() + ") >= INF(" + this.v1.toString() + ") + " + this.cste);
            }
            this.v0.updateInf(this.v1.getInf() + this.cste, this.cIdx0);
        }
        if (this.v0.getInf() >= this.v1.getSup() + this.cste) {
            this.setEntailed();
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.getSup() < this.v1.getInf() + this.cste) {
            return Boolean.FALSE;
        }
        if (this.v0.getInf() >= this.v1.getSup() + this.cste) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] >= tuple[1] + this.cste;
    }

    @Override
    public boolean isConsistent() {
        return this.v0.getInf() >= this.v1.getInf() + this.cste && this.v1.getSup() <= this.v0.getSup() - this.cste;
    }

    @Override
    public AbstractSConstraint opposite() {
        Solver solver = this.getSolver();
        return (AbstractSConstraint)solver.lt((IntExp)this.v0, solver.plus((IntExp)this.v1, this.cste));
    }

    @Override
    public int getVarIdxInOpposite(int i) {
        if (i == 0) {
            return 1;
        }
        if (i == 1) {
            return 0;
        }
        return -1;
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0.toString());
        sb.append(" >= ");
        sb.append(this.v1.toString());
        sb.append(Arithm.pretty(this.cste));
        return sb.toString();
    }
}

