/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class EuclideanDivisionXYZ
extends AbstractTernIntSConstraint {
    private boolean changeX;
    private boolean changeY;
    private boolean changeZ = false;

    public EuclideanDivisionXYZ(IntDomainVar x, IntDomainVar y, IntDomainVar z) {
        super(x, y, z);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 3;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] / tuple[1] == tuple[2];
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " / " + this.v1.pretty() + " = " + this.v2.pretty();
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v1.isInstantiatedTo(0)) {
            this.fail();
        }
        if (this.v0.isInstantiated() && this.v1.isInstantiated() && this.v2.isInstantiated()) {
            if (this.v2.getVal() != this.v0.getVal() / this.v1.getVal()) {
                this.fail();
            }
        } else {
            do {
                this.filterOnX();
                this.filterOnY();
                this.filterOnZ();
            } while (this.changeX || this.changeY || this.changeZ);
        }
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        this.filter(varIdx);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        this.filter(varIdx);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filter(varIndex);
    }

    private void filter(int ind) throws ContradictionException {
        switch (ind) {
            case 0: {
                do {
                    this.filterOnY();
                    this.filterOnZ();
                } while (this.changeY || this.changeZ);
                break;
            }
            case 1: {
                do {
                    this.filterOnX();
                    this.filterOnZ();
                } while (this.changeX || this.changeZ);
                break;
            }
            case 2: {
                do {
                    this.filterOnX();
                    this.filterOnY();
                } while (this.changeX || this.changeY);
                break;
            }
            default: {
                throw new SolverException("Unknown case for IntDiv");
            }
        }
    }

    private void filterOnX() throws ContradictionException {
        this.changeX = false;
        this.changeX = this.v0.updateInf(this.getLowerBoundX(), this.cIdx0);
        this.changeX = this.changeX || this.v0.updateSup(this.getUpperBoundX(), this.cIdx0);
    }

    private int getLowerBoundX() {
        if (this.v2.isInstantiatedTo(0)) {
            if (this.v1.getInf() >= 0) {
                return -this.v1.getSup() + 1;
            }
            if (this.v1.getSup() <= 0) {
                return this.v1.getInf() + 1;
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return -Math.max(Math.abs(this.v1.getInf()), this.v1.getSup()) + 1;
            }
        } else if (this.v2.getInf() >= 0) {
            if (this.v1.getInf() >= 0) {
                return -this.v1.getSup();
            }
            if (this.v1.getSup() <= 0) {
                return this.v1.getInf() * (this.v2.getSup() + 1) + 1;
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return -Math.max(Math.abs(this.v1.getInf()), this.v1.getSup()) * (this.v2.getSup() + 1) + 1;
            }
        } else if (this.v2.getSup() <= 0) {
            if (this.v1.getInf() >= 0) {
                return this.v1.getSup() * (this.v2.getInf() - 1) + 1;
            }
            if (this.v1.getSup() <= 0) {
                return -this.v1.getInf() * (this.v2.getInf() - 1) + 1;
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return Math.max(Math.abs(this.v1.getInf()), this.v1.getSup()) * (this.v2.getInf() - 1) + 1;
            }
        } else if (this.v2.getInf() < 0 && this.v2.getSup() > 0) {
            if (this.v1.getInf() >= 0) {
                return -this.v1.getSup() * (Math.max(Math.abs(this.v2.getInf()), this.v2.getSup()) + 1) + 1;
            }
            if (this.v1.getSup() <= 0) {
                return this.v1.getInf() * (Math.max(Math.abs(this.v2.getInf()), this.v2.getSup()) + 1) + 1;
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return -Math.max(Math.abs(this.v1.getInf()), this.v1.getSup()) * (Math.max(Math.abs(this.v2.getInf()), this.v2.getSup()) + 1) + 1;
            }
        }
        throw new SolverException("Could not compute lower bound for X");
    }

    private int getUpperBoundX() {
        if (this.v2.isInstantiatedTo(0)) {
            if (this.v1.getInf() >= 0) {
                return this.v1.getSup() - 1;
            }
            if (this.v1.getSup() <= 0) {
                return -this.v1.getInf() - 1;
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return Math.max(Math.abs(this.v1.getInf()), this.v1.getSup()) - 1;
            }
        } else if (this.v2.getInf() >= 0) {
            if (this.v1.getInf() >= 0) {
                return this.v1.getSup() * (this.v2.getSup() + 1) - 1;
            }
            if (this.v1.getSup() <= 0) {
                return -this.v1.getInf() * (this.v2.getSup() + 1) - 1;
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return Math.max(Math.abs(this.v1.getInf()), this.v1.getSup()) * (this.v2.getSup() + 1) - 1;
            }
        } else if (this.v2.getSup() <= 0) {
            if (this.v1.getInf() >= 0) {
                return this.v1.getSup() - 1;
            }
            if (this.v1.getSup() <= 0) {
                return this.v1.getInf() * (this.v2.getInf() - 1) - 1;
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return -Math.max(Math.abs(this.v1.getInf()), this.v1.getSup()) * (this.v2.getInf() - 1) - 1;
            }
        } else if (this.v2.getInf() < 0 && this.v2.getSup() > 0) {
            if (this.v1.getInf() >= 0) {
                return this.v1.getSup() * (Math.max(Math.abs(this.v2.getInf()), this.v2.getSup()) + 1) - 1;
            }
            if (this.v1.getSup() <= 0) {
                return -this.v1.getInf() * (Math.max(Math.abs(this.v2.getInf()), this.v2.getSup()) + 1) - 1;
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return Math.max(Math.abs(this.v1.getInf()), this.v1.getSup()) * (Math.max(Math.abs(this.v2.getInf()), this.v2.getSup()) + 1) - 1;
            }
        }
        return this.v0.getSup();
    }

    private void filterOnY() throws ContradictionException {
        this.changeY = false;
        if (this.v1.getInf() == 0) {
            this.changeY = this.v1.updateInf(1, this.cIdx1);
        } else if (this.v1.getSup() == 0) {
            this.changeY = this.v1.updateSup(-1, this.cIdx1);
        }
        if (!this.v0.isInstantiatedTo(0)) {
            this.changeY = this.changeY || this.v1.updateInf(this.getLowerBoundY(), this.cIdx1);
            this.changeY = this.changeY || this.v1.updateSup(this.getUpperBoundY(), this.cIdx1);
        }
    }

    private int getLowerBoundY() {
        if (this.v2.isInstantiatedTo(0) && this.v1.getInf() >= 0) {
            if (this.v0.getInf() >= 0) {
                return this.v0.getInf() + 1;
            }
            if (this.v0.getSup() <= 0) {
                return -(this.v0.getSup() - 1);
            }
        }
        if (this.v2.getInf() > 0) {
            if (this.v0.getInf() >= 0) {
                return 1;
            }
            if (this.v0.getSup() <= 0) {
                return Math.min(-1, this.v0.getInf() / this.v2.getInf());
            }
            if (this.v0.getInf() < 0 && this.v0.getSup() > 0) {
                return -Math.max(Math.abs(this.v0.getInf()), this.v0.getSup()) / this.v2.getInf();
            }
        } else if (this.v2.getSup() < 0) {
            if (this.v0.getInf() >= 0) {
                return Math.min(-1, this.v0.getSup() / this.v2.getSup());
            }
            if (this.v0.getSup() <= 0) {
                return Math.max(-this.v0.getInf() / this.v2.getSup(), 1);
            }
            if (this.v0.getInf() < 0 && this.v0.getSup() > 0) {
                return Math.max(Math.abs(this.v0.getInf()), this.v0.getSup()) / this.v2.getSup();
            }
        }
        return this.v1.getInf();
    }

    private int getUpperBoundY() {
        if (this.v2.isInstantiatedTo(0) && this.v1.getSup() <= 0) {
            if (this.v0.getInf() >= 0) {
                return -(this.v0.getInf() + 1);
            }
            if (this.v0.getSup() <= 0) {
                return this.v0.getSup() - 1;
            }
        }
        if (this.v2.getInf() > 0) {
            if (this.v0.getInf() >= 0) {
                return this.v0.getSup() / this.v2.getInf();
            }
            if (this.v0.getSup() <= 0) {
                return Math.min(-this.v0.getInf() / this.v2.getInf(), -1);
            }
            if (this.v0.getInf() < 0 && this.v0.getSup() > 0) {
                return Math.max(Math.abs(this.v0.getInf()), this.v0.getSup()) / this.v2.getInf();
            }
        } else if (this.v2.getSup() < 0) {
            if (this.v0.getInf() >= 0) {
                return Math.min(-1, -this.v0.getSup() / (this.v2.getSup() - 1));
            }
            if (this.v0.getSup() <= 0) {
                return this.v0.getInf() / this.v2.getSup();
            }
            if (this.v0.getInf() < 0 && this.v0.getSup() > 0) {
                return -Math.max(Math.abs(this.v0.getInf()), this.v0.getSup()) / this.v2.getSup();
            }
        }
        return this.v1.getSup();
    }

    private void filterOnZ() throws ContradictionException {
        this.changeZ = false;
        if (this.v0.isInstantiatedTo(0)) {
            this.changeZ = this.v2.instantiate(0, this.cIdx2);
        } else {
            this.changeZ = this.v2.updateInf(this.getLowerBoundZ(), this.cIdx2);
            this.changeZ = this.changeZ || this.v2.updateSup(this.getUpperBoundZ(), this.cIdx2);
        }
    }

    private int getLowerBoundZ() {
        if (this.v0.getInf() >= 0) {
            if (this.v1.getInf() > 0) {
                return this.v0.getInf() / this.v1.getSup();
            }
            if (this.v1.getSup() < 0) {
                return this.v0.getSup() / this.v1.getSup();
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return -this.v0.getSup();
            }
        } else if (this.v0.getSup() <= 0) {
            if (this.v1.getInf() > 0) {
                return this.v0.getInf() / this.v1.getInf();
            }
            if (this.v1.getSup() < 0) {
                return this.v0.getSup() / this.v1.getInf();
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return this.v0.getInf();
            }
        } else if (this.v0.getInf() < 0 && this.v0.getSup() > 0) {
            if (this.v1.getInf() > 0) {
                return this.v0.getInf() / this.v1.getInf();
            }
            if (this.v1.getSup() < 0) {
                return this.v0.getSup() / this.v1.getSup();
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return -Math.max(Math.abs(this.v0.getInf()), this.v0.getSup());
            }
        }
        return this.v2.getInf();
    }

    private int getUpperBoundZ() {
        if (this.v0.getInf() >= 0) {
            if (this.v1.getInf() > 0) {
                return this.v0.getSup() / this.v1.getInf();
            }
            if (this.v1.getSup() < 0) {
                return this.v0.getInf() / this.v1.getInf();
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return this.v0.getSup();
            }
        } else if (this.v0.getSup() <= 0) {
            if (this.v1.getInf() > 0) {
                return this.v0.getSup() / this.v1.getSup();
            }
            if (this.v1.getSup() < 0) {
                return this.v0.getInf() / this.v1.getSup();
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return -this.v0.getInf();
            }
        } else if (this.v0.getInf() < 0 && this.v0.getSup() > 0) {
            if (this.v1.getInf() > 0) {
                return this.v0.getSup() / this.v1.getInf();
            }
            if (this.v1.getSup() < 0) {
                return this.v0.getInf() / this.v1.getSup();
            }
            if (this.v1.getInf() < 0 && this.v1.getSup() > 0) {
                return Math.max(Math.abs(this.v0.getInf()), this.v0.getSup());
            }
        }
        return this.v2.getSup();
    }
}

