/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.Arithm;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.logging.Level;

public class EqualXYC
extends AbstractBinIntSConstraint {
    protected final int cste;

    public EqualXYC(IntDomainVar x0, IntDomainVar x1, int c) {
        super(x0, x1);
        this.cste = c;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v1.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void propagate() throws ContradictionException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("INF(" + this.v0.toString() + ") >= INF(" + this.v1.toString() + ") + " + this.cste + " = " + (this.v1.getInf() + this.cste));
        }
        this.v0.updateInf(this.v1.getInf() + this.cste, this.cIdx0);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SUP(" + this.v0.toString() + ") <= SUP(" + this.v1.toString() + ") + " + this.cste + " = " + (this.v1.getSup() + this.cste));
        }
        this.v0.updateSup(this.v1.getSup() + this.cste, this.cIdx0);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("INF(" + this.v1.toString() + ") >= INF(" + this.v0.toString() + ") - " + this.cste + " = " + (this.v0.getInf() - this.cste));
        }
        this.v1.updateInf(this.v0.getInf() - this.cste, this.cIdx1);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SUP(" + this.v1.toString() + ") <= SUP(" + this.v0.toString() + ") - " + this.cste + " = " + (this.v0.getSup() - this.cste));
        }
        this.v1.updateSup(this.v0.getSup() - this.cste, this.cIdx1);
        if (this.v1.hasEnumeratedDomain() && this.v0.hasEnumeratedDomain()) {
            IntDomain dom0 = this.v0.getDomain();
            DisposableIntIterator it = dom0.getIterator();
            while (it.hasNext()) {
                int val0 = it.next();
                if (this.v1.canBeInstantiatedTo(val0 - this.cste)) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.v0.toString() + " = " + this.v1.toString() + ") + " + this.cste + " != " + val0);
                }
                this.v0.removeVal(val0, this.cIdx0);
            }
            it.dispose();
            IntDomain dom1 = this.v1.getDomain();
            it = dom1.getIterator();
            while (it.hasNext()) {
                int val1 = it.next();
                if (this.v0.canBeInstantiatedTo(val1 + this.cste)) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.v1.toString() + " = " + this.v0.toString() + ") - " + this.cste + " != " + val1);
                }
                this.v1.removeVal(val1, this.cIdx1);
            }
            it.dispose();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INF(" + this.v1.toString() + ") >= INF(" + this.v0.toString() + ") - " + this.cste + " = " + (this.v0.getInf() - this.cste));
            }
            this.v1.updateInf(this.v0.getInf() - this.cste, this.cIdx1);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("INF(" + this.v0.toString() + ") >= INF(" + this.v1.toString() + ") + " + this.cste + " = " + (this.v1.getInf() + this.cste));
            }
            this.v0.updateInf(this.v1.getInf() + this.cste, this.cIdx0);
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("SUP(" + this.v1.toString() + ") <= SUP(" + this.v0.toString() + ") - " + this.cste + " = " + (this.v0.getSup() - this.cste));
            }
            this.v1.updateSup(this.v0.getSup() - this.cste, this.cIdx1);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("SUP(" + this.v0.toString() + ") <= SUP(" + this.v1.toString() + ") + " + this.cste + " = " + (this.v1.getSup() + this.cste));
            }
            this.v0.updateSup(this.v1.getSup() + this.cste, this.cIdx0);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.v1.toString() + " = " + this.v0.toString() + ") - " + this.cste + " = " + (this.v0.getVal() - this.cste));
            }
            this.v1.instantiate(this.v0.getVal() - this.cste, this.cIdx1);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.v0.toString() + " = " + this.v1.toString() + ") + " + this.cste + " = " + (this.v1.getVal() + this.cste));
            }
            this.v0.instantiate(this.v1.getVal() + this.cste, this.cIdx0);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.v1.toString() + " = " + this.v0.toString() + ") - " + this.cste + " != " + (x - this.cste));
            }
            this.v1.removeVal(x - this.cste, this.cIdx1);
        } else {
            assert (idx == 1);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.v0.toString() + " = " + this.v1.toString() + ") + " + this.cste + " != " + (x + this.cste));
            }
            this.v0.removeVal(x + this.cste, this.cIdx0);
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.getSup() < this.v1.getInf() + this.cste || this.v0.getInf() > this.v1.getSup() + this.cste) {
            return Boolean.FALSE;
        }
        if (this.v0.isInstantiated() && this.v1.isInstantiated() && this.v0.getVal() == this.v1.getVal()) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] == tuple[1] + this.cste;
    }

    @Override
    public boolean isConsistent() {
        return this.v0.getInf() == this.v1.getInf() + this.cste && this.v0.getSup() == this.v1.getSup() + this.cste;
    }

    @Override
    public AbstractSConstraint opposite() {
        Solver solver = this.getSolver();
        return (AbstractSConstraint)solver.neq((IntExp)this.v0, solver.plus((IntExp)this.v1, this.cste));
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0.toString());
        sb.append(" = ");
        sb.append(this.v1.toString());
        sb.append(Arithm.pretty(this.cste));
        return sb.toString();
    }
}

