/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.Arithm;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IStateBool;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class ElementV
extends AbstractLargeIntSConstraint {
    protected IStateBool valueUpdateNeeded;
    protected IStateBool indexUpdateNeeded;

    public ElementV(IntDomainVar[] vars, int offset) {
        super(vars);
        this.cste = offset;
        this.initElementV();
    }

    private void initElementV() {
        this.valueUpdateNeeded = this.getSolver().getEnvironment().makeBool(true);
        this.indexUpdateNeeded = this.getSolver().getEnvironment().makeBool(true);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object res = super.clone();
        ((ElementV)res).initElementV();
        return res;
    }

    public String toString() {
        return "eltV";
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (this.vars[idx].hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public String pretty() {
        return this.getValueVar().toString() + " = nth(" + this.getIndexVar().toString() + ", " + Arithm.pretty(this.vars, 0, this.vars.length - 3) + ")";
    }

    protected IntDomainVar getIndexVar() {
        return this.vars[this.vars.length - 2];
    }

    protected IntDomainVar getValueVar() {
        return this.vars[this.vars.length - 1];
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[tuple[this.vars.length - 2]] == tuple[this.vars.length - 1];
    }

    protected void updateValueFromIndex() throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        int minval = Integer.MAX_VALUE;
        int maxval = Integer.MIN_VALUE;
        DisposableIntIterator iter = idxVar.getDomain().getIterator();
        while (iter.hasNext()) {
            int feasibleIndex = iter.next();
            minval = Arithm.min(minval, this.vars[feasibleIndex + this.cste].getInf());
            maxval = Arithm.max(maxval, this.vars[feasibleIndex + this.cste].getSup());
        }
        valVar.updateInf(minval, this.cIndices[this.vars.length - 1]);
        valVar.updateSup(maxval, this.cIndices[this.vars.length - 1]);
        if (valVar.hasEnumeratedDomain()) {
            int v = valVar.getInf();
            while (v < valVar.getSup()) {
                boolean possibleV = false;
                DisposableIntIterator it = idxVar.getDomain().getIterator();
                while (it.hasNext() && !possibleV) {
                    int tentativeIdx = it.next();
                    if (!this.vars[tentativeIdx + this.cste].canBeInstantiatedTo(v)) continue;
                    possibleV = true;
                    break;
                }
                if (!possibleV) {
                    valVar.removeVal(v, this.cIndices[this.vars.length - 1]);
                }
                v = valVar.getNextDomainValue(v);
            }
        }
        this.valueUpdateNeeded.set(false);
    }

    protected void updateIndexFromValue() throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        int minFeasibleIndex = Arithm.max(0 - this.cste, idxVar.getInf());
        int maxFeasibleIndex = Arithm.min(idxVar.getSup(), this.vars.length - 3 - this.cste);
        int cause = this.cIndices[this.vars.length - 2];
        if (valVar.hasEnumeratedDomain()) {
            cause = -1;
        }
        while (idxVar.canBeInstantiatedTo(minFeasibleIndex) && !valVar.canBeEqualTo(this.vars[minFeasibleIndex + this.cste])) {
            ++minFeasibleIndex;
        }
        idxVar.updateInf(minFeasibleIndex, cause);
        while (idxVar.canBeInstantiatedTo(maxFeasibleIndex) && !valVar.canBeEqualTo(this.vars[maxFeasibleIndex + this.cste])) {
            --maxFeasibleIndex;
        }
        idxVar.updateSup(maxFeasibleIndex, cause);
        if (idxVar.hasEnumeratedDomain()) {
            for (int i = minFeasibleIndex + 1; i < maxFeasibleIndex - 1; ++i) {
                if (!idxVar.canBeInstantiatedTo(i) || valVar.canBeEqualTo(this.vars[i + this.cste])) continue;
                idxVar.removeVal(i, cause);
            }
        }
        if (idxVar.isInstantiated()) {
            this.equalityBehaviour();
        }
        this.indexUpdateNeeded.set(false);
    }

    protected void equalityBehaviour() throws ContradictionException {
        int val;
        assert (this.getIndexVar().isInstantiated());
        int indexVal = this.getIndexVar().getVal();
        IntDomainVar valVar = this.getValueVar();
        IntDomainVar targetVar = this.vars[indexVal + this.cste];
        valVar.updateInf(targetVar.getInf(), this.cIndices[this.vars.length - 1]);
        valVar.updateSup(targetVar.getSup(), this.cIndices[this.vars.length - 1]);
        targetVar.updateInf(valVar.getInf(), this.cIndices[indexVal + this.cste]);
        targetVar.updateSup(valVar.getSup(), this.cIndices[indexVal + this.cste]);
        if (targetVar.hasEnumeratedDomain()) {
            val = valVar.getInf();
            while (val < valVar.getSup()) {
                if (!targetVar.canBeInstantiatedTo(val)) {
                    valVar.removeVal(val, this.cIndices[this.vars.length - 1]);
                }
                val = valVar.getNextDomainValue(val);
            }
        }
        if (valVar.hasEnumeratedDomain()) {
            val = targetVar.getInf();
            while (val < targetVar.getSup()) {
                if (!valVar.canBeInstantiatedTo(val)) {
                    targetVar.removeVal(val, this.cIndices[indexVal]);
                }
                val = targetVar.getNextDomainValue(val);
            }
        }
    }

    @Override
    public void awake() throws ContradictionException {
        int n = this.vars.length;
        IntDomainVar idxVar = this.getIndexVar();
        idxVar.updateInf(0 - this.cste, this.cIndices[n - 2]);
        idxVar.updateSup(n - 3 - this.cste, this.cIndices[n - 2]);
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.indexUpdateNeeded.get()) {
            this.updateIndexFromValue();
        }
        if (this.getIndexVar().isInstantiated()) {
            this.equalityBehaviour();
        } else if (this.valueUpdateNeeded.get()) {
            this.updateValueFromIndex();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == this.vars.length - 2) {
            if (idxVar.isInstantiated()) {
                this.equalityBehaviour();
            } else {
                this.updateValueFromIndex();
            }
        } else if (idx == this.vars.length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                this.vars[idxVal + this.cste].updateInf(valVar.getInf(), this.cIndices[idxVal + this.cste]);
            } else {
                this.updateIndexFromValue();
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.cste) {
                valVar.updateInf(this.vars[idx].getInf(), this.cIndices[this.vars.length - 1]);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.cste)) {
            if (!valVar.canBeEqualTo(this.vars[idx])) {
                idxVar.removeVal(idx - this.cste, -1);
            } else if (this.vars[idx].getInf() > valVar.getInf()) {
                int minval = Integer.MAX_VALUE;
                DisposableIntIterator it = idxVar.getDomain().getIterator();
                while (it.hasNext()) {
                    int feasibleIndex = it.next() + this.cste;
                    minval = Arithm.min(minval, this.vars[feasibleIndex].getInf());
                }
                valVar.updateInf(minval, -1);
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == this.vars.length - 2) {
            if (idxVar.isInstantiated()) {
                this.equalityBehaviour();
            } else {
                this.updateValueFromIndex();
            }
        } else if (idx == this.vars.length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                this.vars[idxVal + this.cste].updateSup(valVar.getSup(), this.cIndices[idxVal + this.cste]);
            } else {
                this.updateIndexFromValue();
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.cste) {
                valVar.updateSup(this.vars[idx].getSup(), this.cIndices[this.vars.length - 1]);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.cste)) {
            if (!valVar.canBeEqualTo(this.vars[idx])) {
                idxVar.removeVal(idx - this.cste, -1);
            } else if (this.vars[idx].getSup() < valVar.getSup()) {
                int maxval = Integer.MIN_VALUE;
                DisposableIntIterator it = idxVar.getDomain().getIterator();
                while (it.hasNext()) {
                    int feasibleIndex = it.next() + this.cste;
                    maxval = Arithm.max(maxval, this.vars[feasibleIndex].getSup());
                }
                valVar.updateSup(maxval, -1);
            }
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == this.vars.length - 2) {
            this.equalityBehaviour();
        } else if (idx == this.vars.length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                this.vars[idxVal + this.cste].instantiate(valVar.getVal(), this.cIndices[idxVal + this.cste]);
            } else {
                this.updateIndexFromValue();
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.cste) {
                valVar.instantiate(this.vars[idx].getVal(), this.cIndices[this.vars.length - 1]);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.cste)) {
            if (!valVar.canBeEqualTo(this.vars[idx])) {
                idxVar.removeVal(idx - this.cste, -1);
            } else {
                this.updateValueFromIndex();
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == this.vars.length - 2) {
            this.updateValueFromIndex();
        } else if (idx == this.vars.length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                this.vars[idxVal + this.cste].removeVal(x, this.cIndices[idxVal + this.cste]);
            } else {
                this.updateIndexFromValue();
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.cste) {
                valVar.removeVal(x, this.cIndices[this.vars.length - 1]);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.cste) && valVar.hasEnumeratedDomain()) {
            boolean existsSupport = false;
            DisposableIntIterator it = idxVar.getDomain().getIterator();
            while (it.hasNext()) {
                int feasibleIndex = it.next() + this.cste;
                if (!this.vars[feasibleIndex].canBeInstantiatedTo(x)) continue;
                existsSupport = true;
            }
            if (!existsSupport) {
                valVar.removeVal(x, -1);
            }
        }
    }

    @Override
    public Boolean isEntailed() {
        int feasibleIndex;
        DisposableIntIterator it;
        Boolean isEntailed = null;
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (valVar.isInstantiated() && idxVar.getInf() + this.cste >= 0 && idxVar.getSup() + this.cste < this.vars.length - 2) {
            boolean allEqualToValVar = true;
            it = idxVar.getDomain().getIterator();
            while (it.hasNext()) {
                feasibleIndex = it.next() + this.cste;
                if (this.vars[feasibleIndex].isInstantiatedTo(valVar.getVal())) continue;
                allEqualToValVar = false;
            }
            if (allEqualToValVar) {
                isEntailed = Boolean.TRUE;
            }
        }
        if (isEntailed != Boolean.TRUE) {
            boolean existsSupport = false;
            it = idxVar.getDomain().getIterator();
            while (it.hasNext()) {
                feasibleIndex = it.next() + this.cste;
                if (feasibleIndex < 0 || feasibleIndex >= this.vars.length - 2 || !valVar.canBeEqualTo(this.vars[feasibleIndex])) continue;
                existsSupport = true;
            }
            if (!existsSupport) {
                isEntailed = Boolean.FALSE;
            }
        }
        return isEntailed;
    }
}

