/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.Arithm;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;

public class Element2D
extends AbstractTernIntSConstraint {
    protected int[][] lvals;
    protected int dim1;
    protected int dim2;
    protected int cste;

    public Element2D(IntDomainVar v0, IntDomainVar v1, IntDomainVar v2, int[][] lvals) {
        super(v0, v1, v2);
        this.lvals = lvals;
        this.dim1 = lvals.length;
        this.dim2 = lvals[0].length;
        this.cste = 0;
        for (int i = 0; i < this.dim1; ++i) {
            for (int j = 0; j < this.dim2; ++j) {
                if (lvals[i][j] >= 0 || lvals[i][j] >= -this.cste) continue;
                this.cste = -lvals[i][j];
            }
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (idx == 1) {
            if (this.v1.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v2.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    public int[] getFavoriteDomains() {
        return new int[]{0, 2, 3, 1};
    }

    public void updateValueFromIndex() throws ContradictionException {
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        DisposableIntIterator v0It = this.v0.getDomain().getIterator();
        DisposableIntIterator v1It = this.v1.getDomain().getIterator();
        DisposableIntIterator v2It = this.v2.getDomain().getIterator();
        while (v0It.hasNext()) {
            int i = v0It.next();
            while (v1It.hasNext()) {
                int j = v1It.next();
                int val = this.lvals[i][j];
                if (minVal > val) {
                    minVal = val;
                }
                if (maxVal >= val) continue;
                maxVal = val;
            }
            v1It = this.v1.getDomain().getIterator();
        }
        this.v2.updateSup(maxVal, this.cIdx2);
        this.v2.updateInf(minVal, this.cIdx2);
        if (this.v2.hasEnumeratedDomain()) {
            v0It = this.v0.getDomain().getIterator();
            v1It = this.v1.getDomain().getIterator();
            BitSet feasValues = new BitSet(this.v2.getDomainSize());
            while (v0It.hasNext()) {
                int v0val = v0It.next();
                while (v1It.hasNext()) {
                    feasValues.set(this.lvals[v0val][v1It.next()] + this.cste);
                }
                v1It = this.v1.getDomain().getIterator();
            }
            int i = v2It.next();
            while (v2It.hasNext()) {
                if (!feasValues.get(i + this.cste)) {
                    this.v2.removeVal(i, this.cIdx2);
                }
                i = v2It.next();
            }
        }
    }

    public boolean testValueVarV0(int idx) {
        boolean ret = false;
        DisposableIntIterator domIt = this.v1.getDomain().getIterator();
        while (!ret & domIt.hasNext()) {
            ret = this.v2.canBeInstantiatedTo(this.lvals[idx][domIt.next()]);
        }
        return ret;
    }

    public boolean testValueVarV1(int idx) {
        boolean ret = false;
        DisposableIntIterator domIt = this.v0.getDomain().getIterator();
        while (!ret & domIt.hasNext()) {
            ret = this.v2.canBeInstantiatedTo(this.lvals[domIt.next()][idx]);
        }
        return ret;
    }

    public void updateIndexFromValue() throws ContradictionException {
        int i;
        int minFeasibleIndex1 = this.v0.getInf();
        int minFeasibleIndex2 = this.v1.getInf();
        int maxFeasibleIndex1 = this.v0.getSup();
        int maxFeasibleIndex2 = this.v1.getSup();
        int thecause1 = -1;
        int thecause2 = -1;
        if (this.v2.hasEnumeratedDomain()) {
            thecause1 = this.cIdx0;
        }
        if (this.v2.hasEnumeratedDomain()) {
            thecause2 = this.cIdx1;
        }
        if (this.v0.hasEnumeratedDomain()) {
            IntDomain v0Dom = this.v0.getDomain();
            i = v0Dom.getNextValue(minFeasibleIndex1 - 1);
            while (i <= maxFeasibleIndex1) {
                if (!this.testValueVarV0(i)) {
                    this.v0.removeVal(i, thecause1);
                }
                i = v0Dom.getNextValue(i);
            }
        } else {
            int v0val;
            DisposableIntIterator v0It = this.v0.getDomain().getIterator();
            while (v0It.hasNext() && !this.testValueVarV0(v0val = v0It.next())) {
                minFeasibleIndex1 = v0val;
            }
            this.v0.updateInf(minFeasibleIndex1, thecause1);
            while (maxFeasibleIndex1 > 0 && this.v0.canBeInstantiatedTo(maxFeasibleIndex1) && !this.testValueVarV0(maxFeasibleIndex1)) {
                --maxFeasibleIndex1;
            }
            this.v0.updateSup(maxFeasibleIndex1, thecause1);
        }
        if (this.v1.hasEnumeratedDomain()) {
            IntDomain v1Dom = this.v1.getDomain();
            i = v1Dom.getNextValue(minFeasibleIndex2 - 1);
            while (i <= maxFeasibleIndex2) {
                if (!this.testValueVarV1(i)) {
                    this.v1.removeVal(i, thecause2);
                }
                i = v1Dom.getNextValue(i);
            }
        } else {
            int v1val;
            DisposableIntIterator v1It = this.v1.getDomain().getIterator();
            while (v1It.hasNext() && !this.testValueVarV1(v1val = v1It.next())) {
                minFeasibleIndex2 = v1val;
            }
            this.v1.updateInf(minFeasibleIndex2, thecause2);
            while (maxFeasibleIndex2 > 0 && this.v1.canBeInstantiatedTo(maxFeasibleIndex2) && !this.testValueVarV1(maxFeasibleIndex2)) {
                --maxFeasibleIndex2;
            }
            this.v1.updateSup(maxFeasibleIndex2, thecause2);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.v0.updateInf(0, this.cIdx0);
        this.v1.updateInf(0, this.cIdx1);
        this.v0.updateSup(this.dim1 - 1, this.cIdx0);
        this.v1.updateSup(this.dim2 - 1, this.cIdx0);
        this.updateIndexFromValue();
        this.updateValueFromIndex();
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx <= 1) {
            this.updateValueFromIndex();
        } else {
            this.updateIndexFromValue();
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.v2.isInstantiated()) {
            boolean b = true;
            DisposableIntIterator v0It = this.v0.getDomain().getIterator();
            DisposableIntIterator v1It = this.v1.getDomain().getIterator();
            while (b && v0It.hasNext()) {
                int v0val = v0It.next();
                while (b && v1It.hasNext()) {
                    b &= this.lvals[v0val][v1It.next()] == this.v2.getVal();
                }
                v1It = this.v1.getDomain().getIterator();
            }
            if (b) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.lvals[tuple[0]][tuple[1]] == tuple[2];
    }

    @Override
    public String pretty() {
        return this.v2.pretty() + " = nth(" + this.v0.pretty() + ", " + this.v1.pretty() + ", " + Arithm.pretty(this.lvals) + ")";
    }
}

