/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.reducedGraph;

import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.StoredBitSetGraph;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.Solver;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Vector;

public class ReducedGraph {
    protected boolean affiche = false;
    protected Solver solver;
    protected int nbVertices;
    protected StoredBitSetGraph graph;
    protected int time;
    protected int numComp;
    protected int[] composante;
    protected int[] prefix;
    protected LinkedList<Integer> listSuffix;
    protected Vector<StoredBitSet> CFC;
    protected StoredBitSet[] reducedGraph;

    public ReducedGraph(Solver solver, StoredBitSetGraph graph) {
        int i;
        this.solver = solver;
        this.graph = graph;
        this.nbVertices = graph.getGraphSize();
        this.time = 0;
        this.numComp = -1;
        this.composante = new int[this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.composante[i] = -1;
        }
        this.prefix = new int[this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.prefix[i] = 0;
        }
        this.listSuffix = new LinkedList();
        this.CFC = new Vector(this.nbVertices);
        this.reducedGraph = new StoredBitSet[1];
        this.reducedGraph[0] = new StoredBitSet(solver.getEnvironment(), this.nbVertices);
    }

    public void stronglyConnectedComponent() {
        int i;
        this.time = 0;
        this.numComp = -1;
        this.composante = new int[this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.composante[i] = -1;
        }
        this.prefix = new int[this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.prefix[i] = 0;
        }
        this.listSuffix = new LinkedList();
        this.CFC.removeAllElements();
        if (this.affiche) {
            System.out.println("====> Premier DFS:");
        }
        for (int v = 0; v < this.nbVertices; ++v) {
            if (this.prefix[v] != 0) continue;
            if (this.affiche) {
                System.out.println("    On entre par " + v);
            }
            this.listSuffix = this.dfs_suffix(v);
        }
        if (this.affiche) {
            System.out.println("Fin du premier DFS <====");
        }
        this.razStruct();
        Vector invCGA = this.inverse();
        if (this.affiche) {
            System.out.println("====> Second DFS (inverse):");
        }
        while (this.listSuffix.size() != 0) {
            int v = this.listSuffix.removeLast();
            if (this.prefix[v] != 0) continue;
            ++this.numComp;
            if (this.affiche) {
                System.out.println("    On entre par " + v);
            }
            this.dfs_mark(v, invCGA);
        }
        if (this.affiche) {
            System.out.println("Fin du second DFS <====");
        }
        for (int i2 = 0; i2 < this.numComp + 1; ++i2) {
            StoredBitSet contain = new StoredBitSet(this.solver.getEnvironment(), this.nbVertices);
            boolean add = false;
            for (int j = 0; j < this.nbVertices; ++j) {
                if (this.composante[j] != i2) continue;
                if (this.affiche) {
                    System.out.println(j + " est dans la composante " + i2);
                }
                add = true;
                contain.set(j, true);
            }
            if (!add) continue;
            this.CFC.addElement(contain);
        }
        if (this.affiche) {
            System.out.println("nbre de cfc = " + this.CFC.size());
        }
        this.buildCFCgraph();
    }

    public void buildCFCgraph() {
        this.reducedGraph = new StoredBitSet[this.CFC.size()];
        for (int i = 0; i < this.CFC.size(); ++i) {
            int k;
            StoredBitSet contain = this.CFC.elementAt(i);
            this.reducedGraph[i] = new StoredBitSet(this.solver.getEnvironment(), this.CFC.size());
            BitSet successors_i = new BitSet(this.nbVertices);
            int j = contain.nextSetBit(0);
            while (j >= 0) {
                StoredBitSet succ_j = this.graph.getSuccessors(j);
                k = succ_j.nextSetBit(0);
                while (k >= 0) {
                    if (k != j) {
                        successors_i.set(k, true);
                    }
                    k = succ_j.nextSetBit(k + 1);
                }
                j = contain.nextSetBit(j + 1);
            }
            for (j = 0; j < this.CFC.size(); ++j) {
                if (j == i) continue;
                StoredBitSet possible = this.CFC.elementAt(j);
                k = possible.nextSetBit(0);
                while (k >= 0) {
                    if (successors_i.get(k)) {
                        this.reducedGraph[i].set(j, true);
                    }
                    k = possible.nextSetBit(k + 1);
                }
            }
        }
    }

    public void razStruct() {
        this.time = 0;
        this.prefix = new int[this.nbVertices];
        for (int i = 0; i < this.nbVertices; ++i) {
            this.prefix[i] = 0;
        }
    }

    public LinkedList<Integer> dfs_suffix(int v) {
        ++this.time;
        if (this.affiche) {
            System.out.println("       On visite " + v);
        }
        StoredBitSet dom = this.graph.getSuccessors(v);
        int j = dom.nextSetBit(0);
        while (j >= 0) {
            if (this.affiche) {
                System.out.println("              on voudrait visiter " + j);
            }
            if (this.prefix[j] == 0) {
                this.dfs_suffix(j);
            }
            j = dom.nextSetBit(j + 1);
        }
        this.listSuffix.offer(v);
        return this.listSuffix;
    }

    public void dfs_mark(int v, Vector invCGA) {
        ++this.time;
        if (this.affiche) {
            System.out.println("       On visite " + v);
        }
        if (this.composante[v] == -1) {
            this.composante[v] = this.numComp;
        }
        BitSet listPossSucc = (BitSet)invCGA.elementAt(v);
        int j = listPossSucc.nextSetBit(0);
        while (j >= 0) {
            if (this.prefix[j] == 0) {
                this.dfs_mark(j, invCGA);
            }
            j = listPossSucc.nextSetBit(j + 1);
        }
    }

    public Vector inverse() {
        int i;
        Vector<BitSet> invCGA = new Vector<BitSet>(this.nbVertices);
        for (i = 0; i < this.nbVertices; ++i) {
            BitSet contain = new BitSet(this.nbVertices);
            invCGA.addElement(contain);
        }
        for (i = 0; i < this.nbVertices; ++i) {
            StoredBitSet dom = this.graph.getSuccessors(i);
            int j = dom.nextSetBit(0);
            while (j >= 0) {
                ((BitSet)invCGA.elementAt(j)).set(i, true);
                j = dom.nextSetBit(j + 1);
            }
        }
        return invCGA;
    }

    public Vector<StoredBitSet> getCFC() {
        return this.CFC;
    }

    public StoredBitSet[] getCFCgraph() {
        return this.reducedGraph;
    }

    public StoredBitSet getMergedVertices(int numCFC) {
        return this.CFC.elementAt(numCFC);
    }
}

