/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews;

import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.StoredBitSetGraph;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.reducedGraph.ReducedGraph;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.List;

public class VarGraphView {
    protected boolean affiche = false;
    protected Solver solver;
    protected IntDomainVar[] s;
    protected List<StoredBitSetGraph.Maintain> globalParams;
    protected List<StoredBitSetGraph.Maintain> sureParams;
    protected List<StoredBitSetGraph.Maintain> maybeParams;
    protected int nbNodes;
    protected StoredBitSetGraph global;
    protected StoredBitSetGraph sure;
    protected StoredBitSetGraph maybe;
    protected StoredBitSet[] globalGraph;
    protected StoredBitSet[] sureGraph;
    protected StoredBitSet[] maybeGraph;
    protected ReducedGraph reducedGraph;
    protected StoredBitSet potentialRoots;

    public VarGraphView(Solver solver, IntDomainVar[] vars) {
        int i;
        this.solver = solver;
        this.s = vars;
        this.nbNodes = vars.length;
        this.globalGraph = new StoredBitSet[this.nbNodes];
        this.sureGraph = new StoredBitSet[this.nbNodes];
        this.maybeGraph = new StoredBitSet[this.nbNodes];
        for (i = 0; i < this.nbNodes; ++i) {
            this.globalGraph[i] = new StoredBitSet(solver.getEnvironment(), this.nbNodes);
            this.sureGraph[i] = new StoredBitSet(solver.getEnvironment(), this.nbNodes);
            this.maybeGraph[i] = new StoredBitSet(solver.getEnvironment(), this.nbNodes);
        }
        this.initGraphs();
        this.globalParams = new ArrayList<StoredBitSetGraph.Maintain>();
        this.globalParams.add(StoredBitSetGraph.Maintain.TRANSITIVE_CLOSURE);
        this.sureParams = new ArrayList<StoredBitSetGraph.Maintain>();
        this.sureParams.add(StoredBitSetGraph.Maintain.TRANSITIVE_CLOSURE);
        this.sureParams.add(StoredBitSetGraph.Maintain.CONNECTED_COMP);
        this.maybeParams = new ArrayList<StoredBitSetGraph.Maintain>();
        this.maybeParams.add(StoredBitSetGraph.Maintain.TRANSITIVE_CLOSURE);
        this.global = new StoredBitSetGraph(solver, this.globalGraph, this.globalParams, false);
        this.sure = new StoredBitSetGraph(solver, this.sureGraph, this.sureParams, false);
        this.maybe = new StoredBitSetGraph(solver, this.maybeGraph, this.maybeParams, false);
        this.reducedGraph = new ReducedGraph(solver, this.global);
        this.potentialRoots = new StoredBitSet(solver.getEnvironment(), this.nbNodes);
        for (i = 0; i < this.nbNodes; ++i) {
            if (!this.globalGraph[i].get(i)) continue;
            this.potentialRoots.set(i, true);
        }
    }

    private void initGraphs() {
        int j;
        int i;
        for (i = 0; i < this.nbNodes; ++i) {
            if (this.s[i].isInstantiated()) {
                int j2 = this.s[i].getVal();
                this.sureGraph[i].set(j2, true);
                continue;
            }
            DisposableIntIterator it = this.s[i].getDomain().getIterator();
            while (it.hasNext()) {
                j = it.next();
                this.maybeGraph[i].set(j, true);
            }
        }
        for (i = 0; i < this.nbNodes; ++i) {
            DisposableIntIterator it = this.s[i].getDomain().getIterator();
            while (it.hasNext()) {
                j = it.next();
                this.globalGraph[i].set(j, true);
            }
        }
    }

    private void updateSCC() {
        this.reducedGraph.stronglyConnectedComponent();
    }

    public void updateOnRem(int u, int v) {
        this.maybe.remArc(u, v);
        this.global.remArc(u, v);
        this.updateSCC();
        if (u == v) {
            this.potentialRoots.set(u, false);
        }
    }

    public void updateOnInst(int u) {
        int v = this.s[u].getVal();
        this.sure.addArc(u, v);
        this.maybe.remAllSucc(u);
        this.global.remAllExcepted(u, v);
        this.updateSCC();
        if (u != v) {
            this.potentialRoots.set(u, false);
        }
    }

    public void updateOnRemovals(int u, IntIterator deltaDomain) {
        this.maybe.remAllNodes(u, deltaDomain);
        this.global.remAllNodes(u, deltaDomain);
        this.updateSCC();
        while (deltaDomain.hasNext()) {
            int v = deltaDomain.next();
            if (u != v) continue;
            this.potentialRoots.set(u, false);
        }
    }

    public void updateOnInf(int u) {
        this.maybe.remAllLowerIdx(u, this.s[u].getInf());
        this.global.remAllLowerIdx(u, this.s[u].getInf());
        this.updateSCC();
        if (u < this.s[u].getInf()) {
            this.potentialRoots.set(u, false);
        }
    }

    public void updateOnSup(int u) {
        this.maybe.remAllGreaterIdx(u, this.s[u].getSup());
        this.global.remAllGreaterIdx(u, this.s[u].getSup());
        this.updateSCC();
        if (u > this.s[u].getSup()) {
            this.potentialRoots.set(u, false);
        }
    }

    public void updateOnBounds(int u) {
        this.maybe.remAllIdx(u, this.s[u].getInf(), this.s[u].getSup());
        this.global.remAllIdx(u, this.s[u].getInf(), this.s[u].getSup());
        this.updateSCC();
        if (u < this.s[u].getInf() || this.s[u].getSup() < u) {
            this.potentialRoots.set(u, false);
        }
    }

    public boolean isFixedSucc(int u) {
        return this.sure.getSuccessors(u).cardinality() > 0;
    }

    public int getFixedSucc(int u) {
        return this.sure.getSuccessors(u).nextSetBit(0);
    }

    public int getNbNodes() {
        return this.nbNodes;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public StoredBitSetGraph getGlobal() {
        return this.global;
    }

    public StoredBitSetGraph getSure() {
        return this.sure;
    }

    public StoredBitSetGraph getMaybe() {
        return this.maybe;
    }

    public StoredBitSet getPotentialRoots() {
        return this.potentialRoots;
    }

    public ReducedGraph getReducedGraph() {
        return this.reducedGraph;
    }

    public void showSure() {
        for (int i = 0; i < this.nbNodes; ++i) {
            System.out.print("sure[" + i + "] = ");
            int j = this.sure.getGraph()[i].nextSetBit(0);
            while (j >= 0) {
                System.out.print(j + " ");
                j = this.sure.getGraph()[i].nextSetBit(j + 1);
            }
            System.out.println("");
        }
    }

    public void showMaybe() {
        for (int i = 0; i < this.nbNodes; ++i) {
            System.out.print("maybe[" + i + "] = ");
            int j = this.maybe.getGraph()[i].nextSetBit(0);
            while (j >= 0) {
                System.out.print(j + " ");
                j = this.maybe.getGraph()[i].nextSetBit(j + 1);
            }
            System.out.println("");
        }
    }

    public void showGlobal() {
        for (int i = 0; i < this.nbNodes; ++i) {
            System.out.print("v" + i + ":= ");
            int j = this.global.getGraph()[i].nextSetBit(0);
            while (j >= 0) {
                System.out.print(j + " ");
                j = this.global.getGraph()[i].nextSetBit(j + 1);
            }
            System.out.println("");
        }
    }
}

