/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews;

import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.algorithms.ConnectedComponents;
import choco.kernel.common.util.IntIterator;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.Solver;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class StoredBitSetGraph {
    protected Solver solver;
    protected List<Maintain> params;
    protected int nbNodes;
    protected int idx;
    protected int[] dfsTree;
    protected StoredBitSet[] graph;
    protected StoredBitSet[] revGraph;
    protected StoredBitSet[] tcGraph;
    protected StoredBitSet[] revTcGraph;
    protected boolean needUpdate;
    protected StoredBitSet[] trGraph;
    protected StoredBitSet[] revTrGraph;
    protected StoredBitSet srcNodes;
    protected StoredBitSet sinkNodes;
    protected ConnectedComponents cc;
    protected Vector<StoredBitSet> setCC;
    protected StoredBitSet[] vertFromNumCC;
    protected StoredBitSet[] numFromVertCC;
    protected IStateInt nbCC;
    protected boolean affiche;

    public StoredBitSetGraph(Solver solver, StoredBitSet[] graph, List<Maintain> params, boolean affiche) {
        this.solver = solver;
        this.graph = graph;
        this.params = params;
        this.nbNodes = graph.length;
        this.affiche = affiche;
        this.idx = 0;
        this.dfsTree = new int[this.nbNodes];
        for (int k = 0; k < this.nbNodes; ++k) {
            this.dfsTree[k] = -1;
        }
        this.srcNodes = new StoredBitSet(solver.getEnvironment(), this.nbNodes);
        this.sinkNodes = new StoredBitSet(solver.getEnvironment(), this.nbNodes);
        this.revGraph = new StoredBitSet[this.nbNodes];
        if (params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
            this.tcGraph = new StoredBitSet[this.nbNodes];
            this.revTcGraph = new StoredBitSet[this.nbNodes];
        } else {
            this.tcGraph = null;
            this.revTcGraph = null;
        }
        if (params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.trGraph = new StoredBitSet[this.nbNodes];
            this.revTrGraph = new StoredBitSet[this.nbNodes];
        } else {
            this.trGraph = null;
            this.revTrGraph = null;
        }
        this.initAllGraphs();
        this.createRevGraph();
        this.updateSpecialNodes();
        if (params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
            this.computeTCfromScratch();
        }
        if (params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        if (params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.initCCstruct();
            this.computeCCfromScratch();
        }
    }

    private void initCCstruct() {
        this.setCC = new Vector(this.nbNodes);
        this.vertFromNumCC = new StoredBitSet[this.nbNodes];
        this.numFromVertCC = new StoredBitSet[this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            this.setCC.add(new StoredBitSet(this.solver.getEnvironment(), this.nbNodes));
            this.vertFromNumCC[i] = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
            this.numFromVertCC[i] = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
        }
        this.nbCC = this.solver.getEnvironment().makeInt(0);
        this.cc = new ConnectedComponents(this.solver, this.nbNodes, this.graph, this.setCC);
    }

    private void initAllGraphs() {
        for (int i = 0; i < this.nbNodes; ++i) {
            this.revGraph[i] = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
            if (this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
                this.tcGraph[i] = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
                this.revTcGraph[i] = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
            }
            if (!this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) continue;
            this.trGraph[i] = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
            this.revTrGraph[i] = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
        }
    }

    private void createRevGraph() {
        for (int i = 0; i < this.nbNodes; ++i) {
            int j = this.graph[i].nextSetBit(0);
            while (j >= 0) {
                this.revGraph[j].set(i, true);
                j = this.graph[i].nextSetBit(j + 1);
            }
        }
    }

    private void computeTCfromScratch() {
        int j;
        int i;
        this.razTC();
        for (i = 0; i < this.nbNodes; ++i) {
            j = this.graph[i].nextSetBit(0);
            while (j >= 0) {
                if (i != j) {
                    this.tcGraph[i].set(j, true);
                    this.revTcGraph[j].set(i, true);
                }
                j = this.graph[i].nextSetBit(j + 1);
            }
        }
        for (i = 0; i < this.nbNodes; ++i) {
            for (j = 0; j < this.nbNodes; ++j) {
                if (!this.tcGraph[j].get(i) || j == i) continue;
                int k = this.tcGraph[i].nextSetBit(0);
                while (k >= 0) {
                    this.tcGraph[j].set(k, true);
                    this.revTcGraph[k].set(j, true);
                    k = this.tcGraph[i].nextSetBit(k + 1);
                }
            }
        }
    }

    private void addIncreTC(int i, int j) {
        if (i != j && !this.tcGraph[i].get(j)) {
            this.tcGraph[i].or(this.tcGraph[j]);
            this.tcGraph[i].set(j, true);
            int k = this.revTcGraph[i].nextSetBit(0);
            while (k >= 0) {
                if (!this.tcGraph[k].get(j)) {
                    this.tcGraph[k].or(this.tcGraph[j]);
                    this.tcGraph[k].set(j, true);
                }
                k = this.revTcGraph[i].nextSetBit(k + 1);
            }
            this.revTcGraph[j].or(this.revTcGraph[i]);
            this.revTcGraph[j].set(i, true);
            k = this.tcGraph[j].nextSetBit(0);
            while (k >= 0) {
                if (!this.tcGraph[i].get(k)) {
                    this.revTcGraph[k].or(this.revTcGraph[i]);
                    this.revTcGraph[k].set(i, true);
                }
                k = this.tcGraph[j].nextSetBit(k + 1);
            }
        }
    }

    private void remIncreTC(int i, int j) {
        if (i != j) {
            StoredBitSet tempDesc = this.getDesc(i, j, this.graph);
            if (this.needUpdate) {
                this.tcGraph[i] = tempDesc;
                StoredBitSet updateAnc = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
                int k = this.revTcGraph[i].nextSetBit(0);
                while (k >= 0) {
                    if (!updateAnc.get(k)) {
                        tempDesc = this.getDesc(k, j, this.graph);
                        if (!this.needUpdate) {
                            updateAnc.or(this.revTcGraph[k]);
                        } else {
                            this.tcGraph[k] = tempDesc;
                        }
                    }
                    k = this.revTcGraph[i].nextSetBit(k + 1);
                }
                this.revTcGraph[j] = this.getDesc(j, i, this.revGraph);
                StoredBitSet updateDesc = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
                int k2 = this.tcGraph[j].nextSetBit(0);
                while (k2 >= 0) {
                    if (!updateDesc.get(k2)) {
                        tempDesc = this.getDesc(k2, i, this.revGraph);
                        if (!this.needUpdate) {
                            updateDesc.or(this.tcGraph[k2]);
                        } else {
                            this.revTcGraph[k2] = tempDesc;
                        }
                    }
                    k2 = this.tcGraph[j].nextSetBit(k2 + 1);
                }
            }
        }
    }

    private StoredBitSet getDesc(int i, int j, StoredBitSet[] graph) {
        this.needUpdate = true;
        Stack<Integer> stack = new Stack<Integer>();
        StoredBitSet reached = new StoredBitSet(this.solver.getEnvironment(), this.nbNodes);
        stack.push(i);
        while (!stack.isEmpty()) {
            int a = (Integer)stack.pop();
            int b = graph[a].nextSetBit(0);
            while (b >= 0) {
                if (!stack.contains(b) && !reached.get(b)) {
                    reached.set(b, true);
                    if (b == j) {
                        this.needUpdate = false;
                        return reached;
                    }
                    stack.push(b);
                }
                b = graph[a].nextSetBit(b + 1);
            }
        }
        return reached;
    }

    private void razTC() {
        for (int i = 0; i < this.nbNodes; ++i) {
            int j = this.tcGraph[i].nextSetBit(0);
            while (j >= 0) {
                this.tcGraph[i].set(j, false);
                this.revTcGraph[j].set(i, false);
                j = this.tcGraph[i].nextSetBit(j + 1);
            }
        }
    }

    private void computeTRfromScratch() {
        int i;
        this.razTR();
        for (i = 0; i < this.nbNodes; ++i) {
            int j = this.graph[i].nextSetBit(0);
            while (j >= 0) {
                this.trGraph[i].set(j, true);
                this.revTrGraph[j].set(i, true);
                j = this.graph[i].nextSetBit(j + 1);
            }
        }
        for (i = 0; i < this.nbNodes; ++i) {
            int[][] num = new int[this.nbNodes][2];
            for (int j = 0; j < this.nbNodes; ++j) {
                num[j][0] = -1;
                num[j][1] = -1;
            }
            this.idx = 0;
            for (int k = 0; k < this.nbNodes; ++k) {
                this.dfsTree[k] = -1;
            }
            this.dfs(i, i, num);
        }
    }

    private void razTR() {
        for (int i = 0; i < this.nbNodes; ++i) {
            int j = this.trGraph[i].nextSetBit(0);
            while (j >= 0) {
                this.trGraph[i].set(j, false);
                this.revTrGraph[j].set(i, false);
                j = this.trGraph[i].nextSetBit(j + 1);
            }
        }
    }

    private int[][] dfs(int root, int u, int[][] num) {
        num[u][0] = this.idx++;
        int v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            if (num[v][0] == -1) {
                this.dfsTree[v] = u;
                num = this.dfs(root, v, num);
            } else {
                int w;
                if (num[u][1] == -1 && num[u][0] > num[v][0] && (w = this.dfsTree[v]) == root) {
                    this.trGraph[w].set(v, false);
                    this.revTrGraph[v].set(w, false);
                }
                if (num[v][1] != -1 && num[u][0] < num[v][0]) {
                    this.trGraph[u].set(v, false);
                    this.revTrGraph[v].set(u, false);
                }
            }
            v = this.graph[u].nextSetBit(v + 1);
        }
        num[u][1] = this.idx++;
        return num;
    }

    private void computeCCfromScratch() {
        int i;
        this.cc.getConnectedComponents(this.affiche);
        if (this.affiche) {
            this.showCC();
        }
        for (i = 0; i < this.nbNodes; ++i) {
            this.numFromVertCC[i].clear();
        }
        for (i = 0; i < this.setCC.size(); ++i) {
            StoredBitSet contain = this.setCC.elementAt(i);
            this.vertFromNumCC[i].clear();
            int j = contain.nextSetBit(0);
            while (j >= 0) {
                this.vertFromNumCC[i].set(j, true);
                this.numFromVertCC[j].set(i, true);
                j = contain.nextSetBit(j + 1);
            }
        }
        this.nbCC.set(this.cc.getNbCC());
    }

    private void showCC() {
        for (int i = 0; i < this.setCC.size(); ++i) {
            StoredBitSet contain = this.setCC.elementAt(i);
            System.out.print("cc(" + i + ") = " + contain.toString());
            System.out.println("");
        }
        System.out.println("*-*-*-*-*-*-*-*-*-*-*-*-*");
    }

    public void addArc(int u, int v) {
        this.graph[u].set(v, true);
        this.revGraph[v].set(u, true);
        if (this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
            this.addIncreTC(u, v);
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        this.updateSpecialNodes(u, v);
        if (this.params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.computeCCfromScratch();
        }
    }

    public void remArc(int u, int v) {
        this.graph[u].set(v, false);
        this.revGraph[v].set(u, false);
        if (this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
            this.remIncreTC(u, v);
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        this.updateSpecialNodes(u, v);
        if (this.params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.computeCCfromScratch();
        }
    }

    public void remAllSucc(int u) {
        int v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            this.graph[u].set(v, false);
            this.revGraph[v].set(u, false);
            v = this.graph[u].nextSetBit(v + 1);
        }
        v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            if (this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
                this.remIncreTC(u, v);
            }
            v = this.graph[u].nextSetBit(v + 1);
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        this.updateSpecialNodes();
        if (this.params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.computeCCfromScratch();
        }
    }

    public void remAllExcepted(int u, int v) {
        int w = this.graph[u].nextSetBit(0);
        while (w >= 0) {
            if (w != v) {
                this.graph[u].set(w, false);
                this.revGraph[w].set(u, false);
            }
            w = this.graph[u].nextSetBit(w + 1);
        }
        w = this.graph[u].nextSetBit(0);
        while (w >= 0) {
            if (w != v && this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
                this.remIncreTC(u, w);
            }
            w = this.graph[u].nextSetBit(w + 1);
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        this.updateSpecialNodes();
        if (this.params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.computeCCfromScratch();
        }
    }

    public void remAllLowerIdx(int u, int idx) {
        int v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            if (v < idx) {
                this.graph[u].set(v, false);
                this.revGraph[v].set(u, false);
            }
            v = this.graph[u].nextSetBit(v + 1);
        }
        v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            if (v < idx && this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
                this.remIncreTC(u, v);
            }
            v = this.graph[u].nextSetBit(v + 1);
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        this.updateSpecialNodes();
        if (this.params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.computeCCfromScratch();
        }
    }

    public void remAllGreaterIdx(int u, int idx) {
        int v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            if (v > idx) {
                this.graph[u].set(v, false);
                this.revGraph[v].set(u, false);
            }
            v = this.graph[u].nextSetBit(v + 1);
        }
        v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            if (v > idx && this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
                this.remIncreTC(u, v);
            }
            v = this.graph[u].nextSetBit(v + 1);
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        this.updateSpecialNodes();
        if (this.params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.computeCCfromScratch();
        }
    }

    public void remAllIdx(int u, int inf, int sup) {
        int v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            if (v < inf || v > sup) {
                this.graph[u].set(v, false);
                this.revGraph[v].set(u, false);
            }
            v = this.graph[u].nextSetBit(v + 1);
        }
        v = this.graph[u].nextSetBit(0);
        while (v >= 0) {
            if ((v < inf || v > sup) && this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
                this.remIncreTC(u, v);
            }
            v = this.graph[u].nextSetBit(v + 1);
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        this.updateSpecialNodes();
        if (this.params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.computeCCfromScratch();
        }
    }

    public void remAllNodes(int u, IntIterator deltaDomain) {
        int v;
        while (deltaDomain.hasNext()) {
            v = deltaDomain.next();
            this.graph[u].set(v, false);
            this.revGraph[v].set(u, false);
        }
        while (deltaDomain.hasNext()) {
            v = deltaDomain.next();
            if (!this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) continue;
            this.remIncreTC(u, v);
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            this.computeTRfromScratch();
        }
        this.updateSpecialNodes();
        if (this.params.contains((Object)Maintain.CONNECTED_COMP)) {
            this.computeCCfromScratch();
        }
    }

    private void updateSpecialNodes(int u, int v) {
        if (this.graph[u].cardinality() == 0) {
            this.sinkNodes.set(u, true);
        } else {
            this.sinkNodes.set(u, false);
        }
        if (this.revGraph[v].cardinality() == 0) {
            this.srcNodes.set(v, true);
        } else {
            this.srcNodes.set(v, false);
        }
    }

    private void updateSpecialNodes() {
        for (int i = 0; i < this.nbNodes; ++i) {
            if (this.graph[i].cardinality() == 0) {
                this.sinkNodes.set(i, true);
            } else {
                this.sinkNodes.set(i, false);
            }
            if (this.revGraph[i].cardinality() == 0) {
                this.srcNodes.set(i, true);
                continue;
            }
            this.srcNodes.set(i, false);
        }
    }

    public int getGraphSize() {
        return this.nbNodes;
    }

    public StoredBitSet getSuccessors(int i) {
        return this.graph[i];
    }

    public StoredBitSet getPredecessors(int i) {
        return this.revGraph[i];
    }

    public StoredBitSet getDescendants(int i) {
        return this.tcGraph[i];
    }

    public StoredBitSet getAncestors(int i) {
        return this.revTcGraph[i];
    }

    public StoredBitSet[] getGraph() {
        return this.graph;
    }

    public void setGraph(StoredBitSet[] newGraph) {
        this.razGraph();
        for (int i = 0; i < this.nbNodes; ++i) {
            int j = newGraph[i].nextSetBit(0);
            while (j >= 0) {
                this.graph[i].set(j, true);
                j = newGraph[i].nextSetBit(j + 1);
            }
        }
    }

    public void razGraph() {
        for (int i = 0; i < this.nbNodes; ++i) {
            int j = this.graph[i].nextSetBit(0);
            while (j >= 0) {
                this.graph[i].set(j, false);
                j = this.graph[i].nextSetBit(j + 1);
            }
        }
    }

    public StoredBitSet[] getRevGraph() {
        return this.revGraph;
    }

    public StoredBitSet[] getTcGraph() {
        return this.tcGraph;
    }

    public StoredBitSet[] getRevTcGraph() {
        return this.revTcGraph;
    }

    public StoredBitSet[] getTrGraph() {
        return this.trGraph;
    }

    public StoredBitSet[] getRevTrGraph() {
        return this.revTrGraph;
    }

    public StoredBitSet getSrcNodes() {
        return this.srcNodes;
    }

    public StoredBitSet getSinkNodes() {
        return this.sinkNodes;
    }

    public Vector<StoredBitSet> getSetCC() {
        return this.setCC;
    }

    public StoredBitSet[] getVertFromNumCC() {
        return this.vertFromNumCC;
    }

    public StoredBitSet[] getNumFromVertCC() {
        return this.numFromVertCC;
    }

    public IStateInt getNbCC() {
        return this.nbCC;
    }

    public String showDesc(int i, String type) {
        String s = "D_" + type + "[" + i + "] = ";
        int j = this.tcGraph[i].nextSetBit(0);
        while (j >= 0) {
            s = s + j + " ";
            j = this.tcGraph[i].nextSetBit(j + 1);
        }
        return s;
    }

    public void showAllDesc(String type) {
        for (int i = 0; i < this.nbNodes; ++i) {
            System.out.print(type + "" + i + ":=");
            int j = this.tcGraph[i].nextSetBit(0);
            while (j >= 0) {
                System.out.print(" " + j);
                j = this.tcGraph[i].nextSetBit(j + 1);
            }
            System.out.println("");
        }
    }

    public void showGraph(String type) {
        for (int i = 0; i < this.nbNodes; ++i) {
            System.out.print(type + "" + i + ":=");
            int j = this.graph[i].nextSetBit(0);
            while (j >= 0) {
                System.out.print(" " + j);
                j = this.graph[i].nextSetBit(j + 1);
            }
            System.out.println("");
        }
    }

    public void affiche() {
        int j;
        int i;
        System.out.println("************ Graph **************");
        for (i = 0; i < this.nbNodes; ++i) {
            System.out.print("graph[" + i + "] = ");
            j = this.graph[i].nextSetBit(0);
            while (j >= 0) {
                System.out.print(j + " ");
                j = this.graph[i].nextSetBit(j + 1);
            }
            System.out.println("");
        }
        System.out.println("*********************************");
        if (this.params.contains((Object)Maintain.TRANSITIVE_CLOSURE)) {
            System.out.println("************ TC Graph **************");
            for (i = 0; i < this.nbNodes; ++i) {
                System.out.print("TCgraph[" + i + "] = ");
                j = this.tcGraph[i].nextSetBit(0);
                while (j >= 0) {
                    System.out.print(j + " ");
                    j = this.tcGraph[i].nextSetBit(j + 1);
                }
                System.out.println("");
            }
            System.out.println("*********************************");
        }
        if (this.params.contains((Object)Maintain.TRANSITIVE_REDUCTION)) {
            System.out.println("************ TR Graph **************");
            for (i = 0; i < this.nbNodes; ++i) {
                System.out.print("TRgraph[" + i + "] = ");
                j = this.trGraph[i].nextSetBit(0);
                while (j >= 0) {
                    System.out.print(j + " ");
                    j = this.trGraph[i].nextSetBit(j + 1);
                }
                System.out.println("");
            }
            System.out.println("*********************************");
        }
    }

    public static enum Maintain {
        TRANSITIVE_CLOSURE,
        TRANSITIVE_REDUCTION,
        CONNECTED_COMP,
        NONE;

    }
}

