/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.StoredBitSetGraph;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.Solver;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class PrecsGraphView {
    protected boolean affiche = false;
    protected Solver solver;
    protected List<StoredBitSetGraph.Maintain> precsParams;
    protected int nbNodes;
    protected StoredBitSetGraph precs;
    protected StoredBitSet[] precsGraph;

    public PrecsGraphView(Solver solver, Node[] nodes) {
        this.solver = solver;
        this.nbNodes = nodes.length;
        this.precsParams = new ArrayList<StoredBitSetGraph.Maintain>();
        this.precsParams.add(StoredBitSetGraph.Maintain.TRANSITIVE_CLOSURE);
        this.precsParams.add(StoredBitSetGraph.Maintain.TRANSITIVE_REDUCTION);
        this.precsParams.add(StoredBitSetGraph.Maintain.CONNECTED_COMP);
        this.precsGraph = new StoredBitSet[this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            this.precsGraph[i] = nodes[i].getMandatorySuccessors();
        }
        this.precs = new StoredBitSetGraph(solver, this.precsGraph, this.precsParams, false);
    }

    public boolean addPrec(int u, int v) {
        if (this.affiche) {
            CPSolver.flushLogs();
            System.out.println("============= Add Incr\ufffdmental : (" + u + "," + v + ") ================");
            this.precs.showGraph("precs");
            System.out.println("---------------");
            this.precs.showAllDesc("tcPrecs");
            System.out.println("**********************");
        }
        boolean res = false;
        if (u != v) {
            if (!this.precs.getDescendants(u).get(v)) {
                if (this.affiche) {
                    System.out.println("\t\t(" + u + "," + v + ") est ajoute dans Gp!");
                }
                this.precs.addArc(u, v);
                this.precsGraph = this.precs.getTrGraph();
                res = true;
            } else {
                if (this.affiche) {
                    System.out.println("\t\t(" + u + "," + v + ") a deja ete ajoute dans Gp");
                }
                res = false;
            }
        }
        if (this.affiche) {
            this.precs.showGraph("precs");
            System.out.println("---------------");
            this.precs.showAllDesc("tcPrecs");
            System.out.println("============= END Add Incr\ufffdmental ================");
        }
        return res;
    }

    public StoredBitSetGraph getPrecs() {
        return this.precs;
    }

    public StoredBitSet getSuccessors(int i) {
        return this.precs.getSuccessors(i);
    }

    public StoredBitSet getPredecessors(int i) {
        return this.precs.getPredecessors(i);
    }

    public BitSet getDescendants(int i) {
        return this.hardCopy(this.precs.getDescendants(i));
    }

    public BitSet getAncestors(int i) {
        return this.hardCopy(this.precs.getAncestors(i));
    }

    public StoredBitSet getSinkNodes() {
        return this.precs.getSinkNodes();
    }

    public StoredBitSet getSrcNodes() {
        return this.precs.getSrcNodes();
    }

    public StoredBitSet[] getVertFromNumCC() {
        return this.precs.getVertFromNumCC();
    }

    public StoredBitSet[] getNumFromVertCC() {
        return this.precs.getNumFromVertCC();
    }

    public String showDesc(int i) {
        return this.precs.showDesc(i, "descPrecs");
    }

    public void showPrecGraph() {
        this.precs.showGraph("precs");
    }

    public void showAllDesc() {
        this.precs.showAllDesc("descPrecs");
    }

    private BitSet hardCopy(StoredBitSet b) {
        BitSet bs = new BitSet(this.nbNodes);
        int i = b.nextSetBit(0);
        while (i >= 0) {
            bs.set(i, true);
            i = b.nextSetBit(i + 1);
        }
        return bs;
    }
}

