/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.algorithms;

import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.StoredBitSetGraph;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.trailing.StoredBitSet;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Vector;

public class RestrictedSCC {
    protected boolean affiche = false;
    protected boolean debug = false;
    protected StoredBitSetGraph graph;
    protected int sap;
    protected int time;
    protected int[] composante;
    protected int[] prefix;
    protected BitSet reachedFirst;
    protected BitSet reachedSecond;
    protected LinkedList<Integer> listSuffix;
    protected Vector<BitSet> CFC;
    protected int numComp;
    protected int nbVertices;
    protected boolean firstLeaf;
    protected boolean canBeSAP;
    protected int[] revPrefix;
    protected int nbToReach;
    protected IStateBitSet contain;
    protected int[] minReached;
    protected BitSet reached;

    public RestrictedSCC(int sap, StoredBitSetGraph graph, IStateBitSet contain) {
        int i;
        this.sap = sap;
        this.graph = graph;
        this.contain = contain;
        this.nbVertices = graph.getGraphSize();
        this.time = 0;
        this.composante = new int[this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.composante[i] = -1;
        }
        this.prefix = new int[this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.prefix[i] = 0;
        }
        this.reachedFirst = new BitSet(this.nbVertices);
        this.reachedSecond = new BitSet(this.nbVertices);
        this.listSuffix = new LinkedList();
        this.CFC = new Vector();
        this.numComp = -1;
        this.minReached = new int[this.nbVertices];
        for (i = 0; i < this.minReached.length; ++i) {
            this.minReached[i] = 0x7FFFFFFE;
        }
        this.minReached[sap] = -2;
        this.reached = new BitSet(contain.cardinality());
        this.firstLeaf = false;
        this.canBeSAP = false;
        this.revPrefix = new int[contain.cardinality()];
        for (i = 0; i < this.revPrefix.length; ++i) {
            this.revPrefix[i] = -1;
        }
        this.nbToReach = 0;
        i = contain.nextSetBit(0);
        while (i >= 0) {
            if (i != sap) {
                ++this.nbToReach;
            }
            i = contain.nextSetBit(i + 1);
        }
    }

    public Vector getRestrictedSCC() {
        if (this.debug) {
            System.out.print("on verifie que " + this.sap + " peut etre un paf...");
        }
        if (this.affiche || this.debug) {
            System.out.println("====> Premier DFS:");
        }
        for (int v = 0; v < this.contain.cardinality(); ++v) {
            if (!this.contain.get(v) || this.prefix[v] != 0 || v == this.sap) continue;
            if (this.debug) {
                System.out.println(" On entre par " + v);
            }
            this.listSuffix = this.restrictDFS_suffix(v, v);
        }
        if (this.affiche || this.debug) {
            System.out.println("Fin du premier DFS <====");
        }
        if (this.canBeSAP) {
            int i;
            if (this.debug) {
                System.out.println(" oui!!!");
            }
            this.razStruct();
            Vector invCGA = this.inverse();
            if (this.affiche) {
                System.out.println("==== Calcul des cfc : le graphe invCGA ====");
                for (i = 0; i < invCGA.size(); ++i) {
                    BitSet s = (BitSet)invCGA.elementAt(i);
                    System.out.print("cga[" + i + "] = ");
                    int j = s.nextSetBit(0);
                    while (j >= 0) {
                        System.out.print(j + " ");
                        j = s.nextSetBit(j + 1);
                    }
                    System.out.println("");
                }
            }
            if (this.affiche || this.debug) {
                System.out.println("====> Second DFS (invers\ufffd):");
            }
            while (this.listSuffix.size() != 0) {
                int v = this.listSuffix.removeLast();
                if (!this.contain.get(v) || this.prefix[v] != 0 || v == this.sap) continue;
                ++this.numComp;
                if (this.affiche) {
                    System.out.println("    On entre par " + v);
                }
                this.restrictDFS_mark(v, invCGA);
            }
            if (this.affiche || this.debug) {
                System.out.println("Fin du second DFS <====");
            }
            for (i = 0; i < this.numComp + 1; ++i) {
                BitSet cont = new BitSet(this.nbVertices);
                boolean add = false;
                for (int j = 0; j < this.contain.cardinality(); ++j) {
                    if (!this.contain.get(j) || this.composante[j] != i) continue;
                    if (this.affiche) {
                        System.out.println(j + " est dans la composante " + i);
                    }
                    add = true;
                    cont.set(j, true);
                }
                if (!add) continue;
                this.CFC.addElement(cont);
            }
            if (this.affiche) {
                System.out.println("nbre de cfc = " + this.CFC.size());
            }
            return this.CFC;
        }
        if (this.debug) {
            System.out.println(" non!!!");
        }
        this.CFC.removeAllElements();
        this.CFC.addElement(null);
        return this.CFC;
    }

    public LinkedList<Integer> restrictDFS_suffix(int v, int origin) {
        this.reached.set(v, true);
        this.prefix[v] = ++this.time;
        if (this.debug) {
            System.out.println("\t On visite " + v + " au temps " + this.time + " (i.e., prefix[" + v + "] = " + this.prefix[v] + ")");
        }
        this.minReached[v] = this.prefix[v];
        this.revPrefix[this.prefix[v]] = v;
        StoredBitSet dom = this.graph.getSuccessors(v);
        int j = dom.nextSetBit(0);
        while (j >= 0) {
            if (this.contain.get(j) && j != this.sap && j != v) {
                if (this.prefix[j] > 0 && this.minReached[j] < this.minReached[v]) {
                    this.minReached[v] = this.minReached[j];
                    if (this.debug) {
                        System.out.println("\t\t le plus petit sommet, d\ufffdja parcouru, atteignable depuis " + v + " ==> " + this.revPrefix[this.minReached[v]]);
                    }
                }
                if (this.prefix[j] == 0) {
                    if (this.debug) {
                        System.out.println("\t\t prefix[" + j + "] = " + this.prefix[j] + " => appel sur " + j);
                    }
                    this.restrictDFS_suffix(j, origin);
                }
            }
            j = dom.nextSetBit(j + 1);
        }
        if (!this.firstLeaf) {
            if (this.debug) {
                System.out.println("\t on est sur la premi\ufffdre feuille (" + v + ") on teste...");
            }
            this.firstLeaf = true;
            if (this.reached.cardinality() == this.nbToReach) {
                if (v != this.sap && this.minReached[v] != this.prefix[origin]) {
                    if (this.debug) {
                        System.out.println("\t\t la feuille " + v + " ne peut pas atteindre l'origine " + origin + " => " + this.sap + " peut etre un paf");
                    }
                    this.canBeSAP = true;
                }
                if (!this.canBeSAP) {
                    if (this.debug) {
                        System.out.println("\t\t le sommet " + this.sap + " ne peut pas \ufffdtre un paf");
                    }
                    return this.listSuffix;
                }
            } else {
                if (this.debug) {
                    System.out.println("\t\t tous les sommets de contain vivants n'ont pas \ufffdt\ufffd atteint => " + this.sap + " peut etre un paf");
                }
                this.canBeSAP = true;
            }
        }
        this.listSuffix.offer(v);
        return this.listSuffix;
    }

    public BitSet restrictDFS_mark(int v, Vector invCGA) {
        ++this.time;
        if (this.affiche) {
            System.out.println("       On visite " + v);
        }
        if (this.composante[v] == -1) {
            this.composante[v] = this.numComp;
        }
        BitSet listPossSucc = (BitSet)invCGA.elementAt(v);
        int j = listPossSucc.nextSetBit(0);
        while (j >= 0) {
            if (this.contain.get(j) && this.prefix[j] == 0 && j != this.sap) {
                this.restrictDFS_mark(j, invCGA);
            }
            j = listPossSucc.nextSetBit(j + 1);
        }
        this.reachedSecond.set(v, true);
        return this.reachedSecond;
    }

    public void razStruct() {
        int i;
        this.time = 0;
        this.prefix = new int[this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.prefix[i] = 0;
        }
        for (i = 0; i < this.minReached.length; ++i) {
            this.minReached[i] = 0x7FFFFFFE;
        }
        this.minReached[this.sap] = -2;
        this.reached = new BitSet(this.contain.cardinality());
        this.nbToReach = 0;
        i = this.contain.nextSetBit(0);
        while (i >= 0) {
            if (i != this.sap) {
                ++this.nbToReach;
            }
            i = this.contain.nextSetBit(i + 1);
        }
    }

    public Vector inverse() {
        int i;
        Vector<BitSet> invCGA = new Vector<BitSet>(this.nbVertices);
        for (i = 0; i < this.nbVertices; ++i) {
            BitSet contain = new BitSet(this.nbVertices);
            invCGA.addElement(contain);
        }
        for (i = 0; i < this.nbVertices; ++i) {
            StoredBitSet dom = this.graph.getSuccessors(i);
            int j = dom.nextSetBit(0);
            while (j >= 0) {
                ((BitSet)invCGA.elementAt(j)).set(i, true);
                j = dom.nextSetBit(j + 1);
            }
        }
        return invCGA;
    }
}

