/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.algorithms;

import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.Solver;
import java.util.BitSet;
import java.util.Vector;

public class ConnectedComponents {
    protected boolean affiche;
    protected Solver solver;
    protected StoredBitSet[] graph;
    protected int nbNodes;
    protected BitSet[] undirected;
    protected Vector<StoredBitSet> cc;
    protected int nbCC;
    protected int[] color;
    protected BitSet reached;

    public ConnectedComponents(Solver solver, int nbNodes, StoredBitSet[] graph, Vector<StoredBitSet> cc) {
        this.solver = solver;
        this.nbNodes = nbNodes;
        this.graph = graph;
        this.cc = cc;
        this.color = new int[nbNodes];
        this.undirected = new BitSet[nbNodes];
    }

    private void update() {
        this.nbCC = 0;
        this.color = new int[this.nbNodes];
        this.reached = new BitSet(this.nbNodes);
        this.getUndirectedGraph();
        if (this.affiche) {
            this.showGraph();
        }
        for (int i = 0; i < this.nbNodes; ++i) {
            this.cc.elementAt(i).clear();
        }
    }

    private void showGraph() {
        Object contain;
        int i;
        for (i = 0; i < this.nbNodes; ++i) {
            contain = this.graph[i];
            System.out.print("sure[" + i + "] = " + ((StoredBitSet)contain).toString());
            System.out.println("");
        }
        for (i = 0; i < this.nbNodes; ++i) {
            contain = this.undirected[i];
            System.out.print("undirected[" + i + "] = " + ((BitSet)contain).toString());
            System.out.println("");
        }
        System.out.println("**************************");
    }

    private void getUndirectedGraph() {
        for (int i = 0; i < this.nbNodes; ++i) {
            this.undirected[i] = new BitSet(this.nbNodes);
        }
        for (int v = 0; v < this.nbNodes; ++v) {
            int j = this.graph[v].nextSetBit(0);
            while (j >= 0) {
                if (v != j) {
                    this.undirected[v].set(j, true);
                    this.undirected[j].set(v, true);
                }
                j = this.graph[v].nextSetBit(j + 1);
            }
        }
    }

    public void getConnectedComponents(boolean b) {
        this.affiche = b;
        this.update();
        for (int i = 0; i < this.nbNodes; ++i) {
            this.color[i] = 0;
        }
        int u = this.existsUnVisited();
        while (u != -1) {
            this.reached.set(u, true);
            if (this.affiche) {
                System.out.print("cc[" + u + "] = ");
            }
            this.dfsVisit(u);
            if (this.affiche) {
                System.out.println("");
            }
            StoredBitSet toModif = this.cc.remove(u);
            toModif.clear();
            int j = this.reached.nextSetBit(0);
            while (j >= 0) {
                toModif.set(j, true);
                j = this.reached.nextSetBit(j + 1);
            }
            this.cc.insertElementAt(toModif, u);
            this.reached.clear();
            u = this.existsUnVisited();
            ++this.nbCC;
        }
        if (this.affiche) {
            System.out.println("----------------");
        }
    }

    private void convertToStored(Vector<BitSet> vb) {
        for (int i = 0; i < this.nbNodes; ++i) {
            BitSet b = vb.elementAt(i);
            StoredBitSet c = this.cc.elementAt(i);
            c.clear();
            int j = b.nextSetBit(0);
            while (j >= 0) {
                c.set(j, true);
                j = b.nextSetBit(j + 1);
            }
        }
    }

    private void dfsVisit(int u) {
        if (this.affiche) {
            System.out.print(u + " ");
        }
        this.color[u] = 1;
        this.reached.set(u, true);
        BitSet adj = this.undirected[u];
        int v = adj.nextSetBit(0);
        while (v >= 0) {
            if (this.color[v] == 0) {
                this.dfsVisit(v);
            }
            v = adj.nextSetBit(v + 1);
        }
    }

    protected int existsUnVisited() {
        for (int i = 0; i < this.nbNodes; ++i) {
            if (this.color[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public int getNbCC() {
        return this.nbCC;
    }
}

