/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.algorithms;

import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.StoredBitSetGraph;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.trailing.StoredBitSet;
import java.util.BitSet;

public class ArticulationPoints {
    protected BitSet[] undirected;
    protected int size;
    protected int[] color;
    protected int time;
    protected int[] predecessor;
    protected int[] prefix;
    protected int[] postfix;
    protected int[] lowpt;
    protected int root;
    protected BitSet res;
    protected IStateBitSet sapNodes;
    protected int nbVertices;

    public ArticulationPoints(StoredBitSetGraph graph, IStateBitSet sapNodes) {
        int i;
        this.sapNodes = sapNodes;
        this.nbVertices = graph.getGraphSize();
        this.undirected = new BitSet[this.nbVertices];
        for (i = 0; i < this.undirected.length; ++i) {
            this.undirected[i] = new BitSet(this.nbVertices);
        }
        for (int v = 0; v < this.nbVertices; ++v) {
            StoredBitSet dom = graph.getSuccessors(v);
            int j = dom.nextSetBit(0);
            while (j >= 0) {
                if (v != j) {
                    this.undirected[v].set(j, true);
                    this.undirected[j].set(v, true);
                }
                j = dom.nextSetBit(j + 1);
            }
        }
        this.root = -1;
        this.color = new int[this.undirected.length];
        this.predecessor = new int[this.undirected.length];
        this.prefix = new int[this.undirected.length];
        this.postfix = new int[this.undirected.length];
        this.lowpt = new int[this.undirected.length];
        for (i = 0; i < this.undirected.length; ++i) {
            this.color[i] = 0;
            this.predecessor[i] = -1;
            this.prefix[i] = -1;
            this.postfix[i] = -1;
            this.lowpt[i] = this.undirected.length;
        }
        this.time = 0;
        this.res = new BitSet(this.undirected.length);
    }

    public BitSet dfs() {
        for (int k = 0; k < this.undirected.length; ++k) {
            if (this.color[k] != 0) continue;
            this.root = k;
            if (this.sapNodes.get(this.root)) continue;
            this.dfsVisit(this.root);
        }
        int nb = 0;
        for (int k = 0; k < this.undirected.length; ++k) {
            if (this.predecessor[k] != this.root || this.root == -1) continue;
            ++nb;
        }
        if (nb > 1 && !this.sapNodes.get(this.root)) {
            this.res.set(this.root, true);
        }
        return this.res;
    }

    public void dfsVisit(int u) {
        this.color[u] = 1;
        this.prefix[u] = ++this.time;
        if (this.lowpt[u] > this.time) {
            this.lowpt[u] = this.time;
        }
        BitSet adj = this.undirected[u];
        int k = adj.nextSetBit(0);
        while (k >= 0) {
            if (this.color[k] == 0) {
                this.predecessor[k] = u;
                this.dfsVisit(k);
                if (this.lowpt[u] > this.lowpt[k]) {
                    this.lowpt[u] = this.lowpt[k];
                }
                if (this.lowpt[k] >= this.prefix[u] && u != this.root && !this.sapNodes.get(u)) {
                    this.res.set(u, true);
                }
            } else if (k != this.predecessor[u] && this.prefix[k] < this.prefix[u] && this.lowpt[u] > this.prefix[k]) {
                this.lowpt[u] = this.prefix[k];
            }
            k = adj.nextSetBit(k + 1);
        }
        this.color[u] = 2;
        this.postfix[u] = ++this.time;
    }
}

