/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure;

import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.costStrutures.CostStructure;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.degreeStructure.DegreeStructure;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.dominatorTrees.DominatorView;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.PrecsGraphView;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.StoredBitSetGraph;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.VarGraphView;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;

public class StructuresAdvisor {
    protected Solver solver;
    protected TreeParameters tree;
    protected Node[] nodes;
    protected int nbNodes;
    protected DegreeStructure degree;
    protected boolean updateDegree;
    protected VarGraphView inputGraph;
    protected DominatorView doms;
    protected PrecsGraphView precs;
    protected StoredBitSetGraph condPrecs;
    protected StoredBitSetGraph incomp;
    protected CostStructure costStruct;

    public StructuresAdvisor(Solver solver, TreeParameters tree) {
        this.solver = solver;
        this.tree = tree;
        this.nodes = tree.getNodes();
        this.nbNodes = tree.getNbNodes();
        this.inputGraph = this.createVarGraphView();
        this.precs = this.createPrecsGraphView();
        this.doms = this.createDominatorView();
        this.incomp = this.createIncompGraph();
        this.condPrecs = this.createCondPrecsGraph();
        this.degree = this.createDegreeStructure();
        this.costStruct = new CostStructure(this.solver, tree, this.inputGraph);
    }

    private VarGraphView createVarGraphView() {
        IntDomainVar[] s = new IntDomainVar[this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            s[i] = this.nodes[i].getSuccessors();
        }
        return new VarGraphView(this.solver, s);
    }

    private PrecsGraphView createPrecsGraphView() {
        return new PrecsGraphView(this.solver, this.nodes);
    }

    private DegreeStructure createDegreeStructure() {
        DegreeStructure deg = new DegreeStructure(this.solver, this.tree, this.inputGraph);
        this.updateDegree = false;
        return deg;
    }

    private DominatorView createDominatorView() {
        return new DominatorView(this.solver, this.inputGraph, this.precs);
    }

    private StoredBitSetGraph createIncompGraph() {
        ArrayList<StoredBitSetGraph.Maintain> params = new ArrayList<StoredBitSetGraph.Maintain>();
        StoredBitSet[] dataIncs = new StoredBitSet[this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            dataIncs[i] = this.nodes[i].getIncomparableNodes();
        }
        return new StoredBitSetGraph(this.solver, dataIncs, params, false);
    }

    private StoredBitSetGraph createCondPrecsGraph() {
        ArrayList<StoredBitSetGraph.Maintain> params = new ArrayList<StoredBitSetGraph.Maintain>();
        StoredBitSet[] dataConds = new StoredBitSet[this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            dataConds[i] = this.nodes[i].getCondSuccessors();
        }
        return new StoredBitSetGraph(this.solver, dataConds, params, false);
    }

    public void applyStructure() throws ContradictionException {
        this.updateDegree = false;
        if (this.degree.needUpdate()) {
            this.degree.updateDegree();
            this.updateDegree = true;
        }
        this.costStruct.updateCostStruct();
    }

    public CostStructure getCostStruct() {
        return this.costStruct;
    }

    public boolean isUpdateDegree() {
        return this.updateDegree;
    }

    public DegreeStructure getDegree() {
        return this.degree;
    }

    public StoredBitSetGraph getIncomp() {
        return this.incomp;
    }

    public PrecsGraphView getPrecs() {
        return this.precs;
    }

    public DominatorView getDoms() {
        return this.doms;
    }

    public StoredBitSetGraph getCondPrecs() {
        return this.condPrecs;
    }

    public VarGraphView getInputGraph() {
        return this.inputGraph;
    }
}

