/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.timeWindows;

import choco.cp.solver.constraints.global.tree.filtering.RemovalsAdvisor;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.PrecsGraphView;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.ContradictionException;
import java.util.BitSet;
import java.util.LinkedList;

public class OrderedGraphPropag {
    protected boolean debugRem = false;
    protected int nbNodes;
    protected Node[] nodes;
    protected PrecsGraphView precs;
    protected StoredBitSet src;
    protected StoredBitSet sink;
    protected IStateInt[][] travelTime;
    protected IStateInt[][] minTravelTime;
    protected RemovalsAdvisor propagateStruct;

    public OrderedGraphPropag(IStateInt[][] travelTime, IStateInt[][] minTravelTime, PrecsGraphView precs, Node[] nodes, RemovalsAdvisor propagateStruct) {
        this.precs = precs;
        this.travelTime = travelTime;
        this.minTravelTime = minTravelTime;
        this.nodes = nodes;
        this.propagateStruct = propagateStruct;
        this.nbNodes = nodes.length;
        this.sink = precs.getSinkNodes();
        this.src = precs.getSrcNodes();
    }

    public void applyTWfiltering() throws ContradictionException {
        this.updateInf();
        this.updateSup();
        this.updateSupByDesc();
    }

    private void updateInf() {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        BitSet reached = new BitSet(this.nbNodes);
        int i = this.src.nextSetBit(0);
        while (i >= 0) {
            if (!reached.get(i)) {
                queue.offer(i);
            }
            i = this.src.nextSetBit(i + 1);
        }
        while (!queue.isEmpty()) {
            i = (Integer)queue.poll();
            reached.set(i, true);
            int j = this.precs.getSuccessors(i).nextSetBit(0);
            while (j >= 0) {
                if (!reached.get(j)) {
                    queue.offer(j);
                    int newVal = this.nodes[i].getTimeWindow().getInf() + this.minTravelTime[i][j].get();
                    if (this.nodes[j].getTimeWindow().getInf() < newVal) {
                        this.propagateStruct.setMinStart(j, newVal);
                    }
                }
                j = this.precs.getSuccessors(i).nextSetBit(j + 1);
            }
        }
    }

    private void updateSup() throws ContradictionException {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        BitSet reached = new BitSet(this.nbNodes);
        int i = this.sink.nextSetBit(0);
        while (i >= 0) {
            if (!reached.get(i)) {
                queue.offer(i);
            }
            i = this.sink.nextSetBit(i + 1);
        }
        while (!queue.isEmpty()) {
            int j = (Integer)queue.poll();
            reached.set(j, true);
            int i2 = this.precs.getPredecessors(j).nextSetBit(0);
            while (i2 >= 0) {
                if (!reached.get(i2)) {
                    queue.offer(i2);
                    int newVal = this.nodes[j].getTimeWindow().getSup() - this.minTravelTime[i2][j].get();
                    if (this.nodes[i2].getTimeWindow().getSup() > newVal) {
                        this.propagateStruct.setMaxStart(i2, newVal);
                    }
                }
                i2 = this.precs.getPredecessors(j).nextSetBit(i2 + 1);
            }
        }
    }

    private void updateSupByDesc() throws ContradictionException {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        int i = this.sink.nextSetBit(0);
        while (i >= 0) {
            queue.offer(i);
            i = this.sink.nextSetBit(i + 1);
        }
        if (this.debugRem) {
            System.out.println("======= sink ==============");
            this.affichePrec();
            System.out.println("" + ((Object)queue).toString());
            System.out.println("==========================");
        }
        while (!queue.isEmpty()) {
            int j = (Integer)queue.poll();
            if (this.precs.getSuccessors(j).cardinality() > 0) {
                this.propagateBestDescSet(j);
            }
            int i2 = this.precs.getPredecessors(j).nextSetBit(0);
            while (i2 >= 0) {
                if (!queue.contains(i2)) {
                    queue.offer(i2);
                }
                i2 = this.precs.getPredecessors(j).nextSetBit(i2 + 1);
            }
        }
    }

    private void propagateBestDescSet(int i) throws ContradictionException {
        int newSum = 0;
        int maxStartSucc = Integer.MIN_VALUE;
        int j = this.precs.getSuccessors(i).nextSetBit(0);
        while (j >= 0) {
            if (this.nodes[j].getTimeWindow().getSup() > maxStartSucc) {
                maxStartSucc = this.nodes[j].getTimeWindow().getSup();
            }
            int minPred_j = this.minTravelTime[i][j].get();
            int k = this.precs.getSuccessors(i).nextSetBit(0);
            while (k >= 0) {
                if (k != j && minPred_j > this.minTravelTime[k][j].get()) {
                    minPred_j = this.minTravelTime[k][j].get();
                }
                k = this.precs.getSuccessors(i).nextSetBit(k + 1);
            }
            newSum += minPred_j;
            j = this.precs.getSuccessors(i).nextSetBit(j + 1);
        }
        int newMax = maxStartSucc - newSum;
        if (this.nodes[i].getTimeWindow().getSup() > newMax) {
            if (this.debugRem) {
                System.out.println("-------------------------------------------------------------------");
                System.out.println("Update[propagateBestDescSet] : twPropagation.TWConstraint for nodes " + i);
                System.out.println("\t max start " + i + " = " + this.nodes[i].getTimeWindow().getSup() + " devient " + newMax);
                System.out.println("-------------------------------------------------------------------");
            }
            this.propagateStruct.setMaxStart(i, newMax);
        }
    }

    public void afficheMinTravelTime() {
        for (int i = 0; i < this.nbNodes; ++i) {
            System.out.print("prec[" + i + "] = ");
            int j = this.precs.getSuccessors(i).nextSetBit(0);
            while (j >= 0) {
                System.out.print(j + " (" + this.minTravelTime[i][j] + "),");
                j = this.precs.getSuccessors(i).nextSetBit(j + 1);
            }
            System.out.println("");
        }
    }

    private void affichePrec() {
        for (int i = 0; i < this.nbNodes; ++i) {
            System.out.print("prec[" + i + "] = ");
            int j = this.precs.getSuccessors(i).nextSetBit(0);
            while (j >= 0) {
                System.out.print(j + " ");
                j = this.precs.getSuccessors(i).nextSetBit(j + 1);
            }
            System.out.println("");
        }
    }
}

