/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.precedences;

import choco.kernel.memory.trailing.StoredBitSet;
import java.util.BitSet;

public class TopologicSort {
    protected BitSet[] RGS;
    protected int[] numTable;
    protected BitSet sorted;

    public TopologicSort(StoredBitSet[] rgs) {
        int i;
        this.RGS = new BitSet[rgs.length];
        for (i = 0; i < rgs.length; ++i) {
            this.RGS[i] = rgs[i].copyToBitSet();
        }
        this.numTable = new int[this.RGS.length];
        for (i = 0; i < this.numTable.length; ++i) {
            this.numTable[i] = -1;
        }
        this.sorted = new BitSet(this.RGS.length);
    }

    public int[] sort() {
        this.exec_sort(0);
        return this.numTable;
    }

    protected void exec_sort(int lvl) {
        BitSet sources = this.getSources();
        if (sources.cardinality() > 0) {
            int i = sources.nextSetBit(0);
            while (i >= 0) {
                this.numTable[i] = lvl;
                this.sorted.set(i, true);
                this.updateRGS(i);
                i = sources.nextSetBit(i + 1);
            }
            this.exec_sort(++lvl);
        }
    }

    protected void updateRGS(int v) {
        for (int i = 0; i < this.RGS.length; ++i) {
            if (i == v) continue;
            int j = this.RGS[i].nextSetBit(0);
            while (j >= 0) {
                if (j == v) {
                    this.RGS[i].set(j, true);
                }
                j = this.RGS[i].nextSetBit(j + 1);
            }
        }
        this.RGS[v].clear();
    }

    protected BitSet getSources() {
        BitSet res = new BitSet(this.RGS.length);
        for (int i = 0; i < this.RGS.length; ++i) {
            if (this.sorted.get(i)) continue;
            boolean src = true;
            for (BitSet aRGS : this.RGS) {
                if (!aRGS.get(i)) continue;
                src = false;
            }
            if (!src) continue;
            res.set(i, true);
        }
        return res;
    }
}

