/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.globalCardConstraint;

import choco.cp.solver.constraints.global.tree.filtering.RemovalsAdvisor;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.StructuresAdvisor;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;

public abstract class AbstractBipartGraph {
    protected int nbLeftVertices;
    protected int nbRightVertices;
    protected int nbVertices;
    protected int minValue = Integer.MIN_VALUE;
    protected int maxValue = Integer.MAX_VALUE;
    protected int source;
    protected int[] refMatch;
    protected int matchingSize;
    protected int[] left2rightArc;
    protected int[] right2leftArc;
    protected IntQueue queue;
    protected Solver solver;
    protected IntDomainVar nTree;
    protected BitSet[] graph;
    protected boolean isFeasible;
    protected TreeParameters tree;
    protected int[] index;
    protected StructuresAdvisor struct;
    protected int time = 0;
    protected int[] finishDate;
    protected boolean[] seen;
    protected int currentNode = -1;
    protected int currentComponent = -1;
    protected int[] component;
    protected boolean[][] componentOrder;

    protected AbstractBipartGraph(Solver solver, Object[] pack) {
        this.solver = solver;
        this.init(pack);
    }

    protected void init(Object[] pack) {
        int i;
        this.tree = (TreeParameters)pack[0];
        this.nTree = this.tree.getNtree();
        this.struct = (StructuresAdvisor)pack[1];
        this.graph = this.struct.getDegree().getGccVars();
        this.nbLeftVertices = this.struct.getDegree().getNbLeftVertices();
        this.nbRightVertices = this.struct.getDegree().getLow().length;
        this.index = this.struct.getDegree().getIndexVars();
        this.nbVertices = this.nbLeftVertices + this.nbRightVertices + 1;
        this.refMatch = new int[this.nbLeftVertices];
        for (i = 0; i < this.refMatch.length; ++i) {
            this.refMatch[i] = -1;
        }
        this.matchingSize = 0;
        this.queue = new IntQueue(this.nbVertices - 1);
        this.left2rightArc = new int[this.nbLeftVertices];
        this.right2leftArc = new int[this.nbRightVertices];
        this.source = this.nbVertices - 1;
        this.finishDate = new int[this.nbVertices];
        this.seen = new boolean[this.nbVertices];
        this.component = new int[this.nbVertices];
        for (i = 0; i < this.component.length; ++i) {
            this.component[i] = -1;
        }
        this.componentOrder = new boolean[this.nbVertices][this.nbVertices];
        for (i = 0; i < this.nbVertices; ++i) {
            this.componentOrder[i][i] = true;
        }
        this.isFeasible = true;
    }

    public int[] mayMatch(int i) {
        int[] ret = new int[this.graph[i].cardinality()];
        int offset = 0;
        int j = this.graph[i].nextSetBit(0);
        while (j >= 0) {
            ret[offset++] = j - this.minValue;
            j = this.graph[i].nextSetBit(j + 1);
        }
        return ret;
    }

    public int[] mayInverseMatch(int j) {
        int[] ret = new int[this.nbLeftVertices];
        int nb = 0;
        for (int i = 0; i < this.nbLeftVertices; ++i) {
            if (!this.graph[i].get(j + this.minValue)) continue;
            ret[nb++] = i;
        }
        int[] ret2 = new int[nb];
        System.arraycopy(ret, 0, ret2, 0, nb);
        return ret2;
    }

    public int match(int i) {
        return this.refMatch[i];
    }

    public boolean mayGrowFlowToSink(int i) {
        return this.match(i) == -1;
    }

    public boolean mayGrowFlowBetween(int j, int i) {
        return this.match(i) != j;
    }

    public boolean mayDiminishFlowBetween(int j, int i) {
        return this.match(i) == j;
    }

    public abstract void increaseMatchingSize(int var1);

    public abstract void decreaseMatchingSize(int var1);

    public abstract void deleteMatch(int var1, int var2);

    public abstract void putRefMatch(int var1, int var2);

    public abstract void setMatch(int var1, int var2);

    public abstract boolean mayDiminishFlowFromSource(int var1);

    public abstract boolean mayGrowFlowFromSource(int var1);

    public abstract boolean mustGrowFlowFromSource(int var1);

    public int findAlternatingPath() {
        int j;
        int eopath = -1;
        int n = this.nbLeftVertices;
        this.queue.init();
        for (j = 0; j < this.nbRightVertices; ++j) {
            if (!this.mustGrowFlowFromSource(j)) continue;
            this.queue.push(j + n);
        }
        if (this.queue.getSize() == 0) {
            for (j = 0; j < this.nbRightVertices; ++j) {
                if (!this.mayGrowFlowFromSource(j)) continue;
                this.queue.push(j + n);
            }
        }
        while (this.queue.getSize() > 0) {
            int x = this.queue.pop();
            if (x >= n) {
                int[] yy;
                boolean shouldBreak = false;
                for (int y : yy = this.mayInverseMatch(x -= n)) {
                    if (!this.mayGrowFlowBetween(x, y) || this.queue.onceInQueue(y)) continue;
                    this.left2rightArc[y] = x;
                    if (this.mayGrowFlowToSink(y)) {
                        eopath = y;
                        shouldBreak = true;
                        break;
                    }
                    this.queue.push(y);
                }
                if (!shouldBreak) continue;
                break;
            }
            int y = this.match(x);
            if (this.queue.onceInQueue(y + n)) continue;
            this.right2leftArc[y] = x;
            this.queue.push(y + n);
        }
        return eopath;
    }

    public void augment(int x) {
        int y = this.left2rightArc[x];
        while (!this.mayGrowFlowFromSource(y)) {
            this.putRefMatch(x, y);
            x = this.right2leftArc[y];
            assert (this.match(x) == y);
            y = this.left2rightArc[x];
            assert (y >= 0);
        }
        this.putRefMatch(x, y);
        this.increaseMatchingSize(y);
    }

    public void augmentFlow() {
        int eopath = this.findAlternatingPath();
        int n1 = this.nbLeftVertices;
        if (this.matchingSize < n1) {
            while (eopath >= 0) {
                this.augment(eopath);
                eopath = this.findAlternatingPath();
            }
            if (this.matchingSize < n1) {
                this.isFeasible = false;
            }
        }
    }

    public void initSCCGraph() {
        int i;
        for (i = 0; i < this.currentComponent; ++i) {
            for (int j = 0; j < this.currentComponent; ++j) {
                if (i == j) continue;
                this.componentOrder[i][j] = false;
            }
        }
        for (i = 0; i < this.nbVertices; ++i) {
            this.component[i] = -1;
        }
        this.currentComponent = -1;
    }

    public void addComponentVertex() {
        ++this.currentComponent;
    }

    public void addComponentEdge(int compi, int compj) {
        if (!this.componentOrder[compi][compj]) {
            this.componentOrder[compi][compj] = true;
            for (int compj2 = 0; compj2 < compj; ++compj2) {
                if (!this.componentOrder[compj][compj2]) continue;
                this.componentOrder[compi][compj2] = true;
            }
        }
    }

    public void firstPassDFS() {
        int i;
        for (i = 0; i < this.nbVertices; ++i) {
            this.finishDate[i] = 0;
            this.seen[i] = false;
        }
        this.time = 0;
        for (i = 0; i < this.nbVertices; ++i) {
            this.firstDFSearch(i);
        }
    }

    public void firstDFSearch(int i) {
        if (!this.seen[i]) {
            ++this.time;
            this.seen[i] = true;
            if (i < this.nbLeftVertices) {
                this.firstDFSearch(this.match(i) + this.nbLeftVertices);
            } else if (i < this.source) {
                int[] jj;
                for (int j : jj = this.mayInverseMatch(i - this.nbLeftVertices)) {
                    if (this.match(j) == i - this.nbLeftVertices) continue;
                    this.firstDFSearch(j);
                }
                if (this.mayDiminishFlowFromSource(i - this.nbLeftVertices)) {
                    this.firstDFSearch(this.source);
                }
            } else {
                for (int j = 0; j < this.nbRightVertices; ++j) {
                    if (!this.mayGrowFlowFromSource(j)) continue;
                    this.firstDFSearch(j + this.nbLeftVertices);
                }
            }
            this.finishDate[i] = ++this.time;
        }
    }

    public void secondPassDFS() {
        this.initSCCGraph();
        while (true) {
            int maxf = 0;
            int rootOfComp = -1;
            for (int i = 0; i < this.nbVertices; ++i) {
                if (this.component[i] != -1 || this.finishDate[i] <= maxf) continue;
                maxf = this.finishDate[i];
                rootOfComp = i;
            }
            if (maxf <= 0) break;
            this.addComponentVertex();
            this.secondDFSearch(rootOfComp);
        }
    }

    public void secondDFSearch(int i) {
        int compi = this.component[i];
        int curComp = this.currentComponent;
        if (compi == -1) {
            this.component[i] = curComp;
            this.currentNode = i;
            if (i < this.nbLeftVertices) {
                int[] jj;
                for (int j : jj = this.mayMatch(i)) {
                    if (this.match(i) == j) continue;
                    this.secondDFSearch(j + this.nbLeftVertices);
                }
            } else if (i < this.source) {
                int[] jj;
                for (int j : jj = this.mayInverseMatch(i - this.nbLeftVertices)) {
                    if (this.match(j) != i - this.nbLeftVertices) continue;
                    this.secondDFSearch(j);
                }
                if (this.mayGrowFlowFromSource(i - this.nbLeftVertices)) {
                    this.secondDFSearch(this.source);
                }
            } else {
                for (int j = 0; j < this.nbRightVertices; ++j) {
                    if (!this.mayDiminishFlowFromSource(j)) continue;
                    this.secondDFSearch(j + this.nbLeftVertices);
                }
            }
        } else if (compi < curComp) {
            this.addComponentEdge(curComp, compi);
        }
    }

    public abstract void deleteEdgeAndPublish(int var1, int var2, RemovalsAdvisor var3);

    public void removeUselessEdges(RemovalsAdvisor rem) throws ContradictionException {
        if (this.matchingSize < this.nbLeftVertices) {
            this.augmentFlow();
        }
        this.firstPassDFS();
        this.secondPassDFS();
        for (int i = 0; i < this.nbLeftVertices; ++i) {
            int[] jj;
            for (int j : jj = this.mayMatch(i)) {
                if (this.match(i) == j || this.component[i] == this.component[j + this.nbLeftVertices]) continue;
                this.deleteEdgeAndPublish(i, j, rem);
            }
        }
    }

    public void propagate(RemovalsAdvisor rem) throws ContradictionException {
        this.removeUselessEdges(rem);
    }

    public int getPriority() {
        return 2;
    }

    protected static class IntQueue {
        private int maxSize;
        private int nbElts;
        private int last;
        private int[] contents;
        private boolean[] onceInQueue;

        IntQueue(int n) {
            this.maxSize = n;
            this.contents = new int[n];
            this.onceInQueue = new boolean[n];
            this.init();
        }

        public int getSize() {
            return this.nbElts;
        }

        public void init() {
            this.nbElts = 0;
            for (int i = 0; i < this.maxSize; ++i) {
                this.contents[i] = -1;
                this.onceInQueue[i] = false;
            }
        }

        public void push(int val) {
            this.onceInQueue[val] = true;
            if (this.contents[val] == -1) {
                if (this.nbElts == 0) {
                    this.contents[val] = val;
                } else {
                    this.contents[val] = this.contents[this.last];
                    this.contents[this.last] = val;
                }
                this.last = val;
                ++this.nbElts;
            }
        }

        public int pop() {
            int val = this.contents[this.last];
            --this.nbElts;
            this.contents[this.last] = this.contents[val];
            this.contents[val] = -1;
            return val;
        }

        public boolean onceInQueue(int i) {
            return this.onceInQueue[i];
        }
    }
}

