/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering;

import choco.cp.solver.constraints.global.tree.filtering.AbstractPropagator;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomain;
import java.util.BitSet;

public class Incomparability
extends AbstractPropagator {
    public Incomparability(Object[] params) {
        super(params);
    }

    @Override
    public String getTypePropag() {
        return "Incomp propagation";
    }

    @Override
    public boolean feasibility() {
        StoredBitSet sources = this.precs.getSrcNodes();
        int w = sources.nextSetBit(0);
        while (w >= 0) {
            BitSet D_w = this.precs.getDescendants(w);
            int u = D_w.nextSetBit(0);
            while (u >= 0) {
                StoredBitSet I_u = this.nodes[u].getIncomparableNodes();
                int v = I_u.nextSetBit(0);
                while (v >= 0) {
                    if (D_w.get(v)) {
                        if (this.affiche) {
                            System.out.println("Violation incomp : inc(" + u + "," + v + ") VS desc_" + w + " = " + D_w.toString());
                        }
                        return false;
                    }
                    v = I_u.nextSetBit(v + 1);
                }
                u = D_w.nextSetBit(u + 1);
            }
            w = sources.nextSetBit(w + 1);
        }
        return true;
    }

    @Override
    public void filter() throws ContradictionException {
        this.filterAccordingToNtree();
        for (int u = 0; u < this.nbVertices; ++u) {
            if (this.nodes[u].getSuccessors().isInstantiated()) continue;
            IntDomain dom = this.nodes[u].getSuccessors().getDomain();
            DisposableIntIterator iter = dom.getIterator();
            while (iter.hasNext()) {
                int v = iter.next();
                if (u == v) continue;
                this.filteringAccordingToPrecsAndIncs(u, v);
            }
        }
    }

    private void filterAccordingToNtree() {
        if (this.tree.getNtree().isInstantiatedTo(1)) {
            for (int i = 0; i < this.nbVertices; ++i) {
                if (!this.nodes[i].getSuccessors().canBeInstantiatedTo(i)) continue;
                if (this.nodes[i].getIncomparableNodes().cardinality() != 0) {
                    if (this.affiche) {
                        System.out.println("1- filterAccordingToNtree(): l'arc (" + i + "," + i + ") est impossible");
                    }
                    int[] arc = new int[]{i, i};
                    this.propagateStruct.addRemoval(arc);
                    continue;
                }
                for (int j = 0; j < this.nbVertices; ++j) {
                    if (!this.nodes[j].getIncomparableNodes().get(i)) continue;
                    if (this.affiche) {
                        System.out.println("2- filterAccordingToNtree(): l'arc (" + i + "," + i + ") est impossible");
                    }
                    int[] arc = new int[]{i, i};
                    this.propagateStruct.addRemoval(arc);
                }
            }
        }
    }

    private void filteringAccordingToPrecsAndIncs(int u, int v) {
        int[] arc = new int[]{u, v};
        BitSet A_u = this.precs.getAncestors(u);
        A_u.set(u, true);
        BitSet D_v = this.precs.getDescendants(v);
        D_v.set(v, true);
        BitSet A_v = this.precs.getAncestors(v);
        A_v.set(v, true);
        BitSet Dr_u = this.precs.getDescendants(u);
        Dr_u.set(u, false);
        int v_a = A_v.nextSetBit(0);
        while (v_a >= 0) {
            int u_d = Dr_u.nextSetBit(0);
            while (u_d >= 0) {
                if (v_a < u_d && this.nodes[v_a].getIncomparableNodes().get(u_d)) {
                    if (this.affiche) {
                        System.out.println("1- filteringAccordingToPrecsAndIncs(): l'arc (" + u + "," + v + ") est impossible");
                    }
                    this.propagateStruct.addRemoval(arc);
                    return;
                }
                if (u_d < v_a && this.nodes[u_d].getIncomparableNodes().get(v_a)) {
                    if (this.affiche) {
                        System.out.println("2- filteringAccordingToPrecsAndIncs(): l'arc (" + u + "," + v + ") est impossible");
                    }
                    this.propagateStruct.addRemoval(arc);
                    return;
                }
                u_d = Dr_u.nextSetBit(u_d + 1);
            }
            v_a = A_v.nextSetBit(v_a + 1);
        }
        int u_a = A_u.nextSetBit(0);
        while (u_a >= 0) {
            int v_d = D_v.nextSetBit(0);
            while (v_d >= 0) {
                if (u_a < v_d && this.nodes[u_a].getIncomparableNodes().get(v_d)) {
                    if (this.affiche) {
                        System.out.println("3- filteringAccordingToPrecsAndIncs(): l'arc (" + u + "," + v + ") est impossible");
                    }
                    this.propagateStruct.addRemoval(arc);
                    return;
                }
                if (v_d < u_a && this.nodes[v_d].getIncomparableNodes().get(u_a)) {
                    if (this.affiche) {
                        System.out.println("4- filteringAccordingToPrecsAndIncs(): l'arc (" + u + "," + v + ") est impossible");
                    }
                    this.propagateStruct.addRemoval(arc);
                    return;
                }
                v_d = D_v.nextSetBit(v_d + 1);
            }
            u_a = A_u.nextSetBit(u_a + 1);
        }
    }
}

