/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.costFiltering;

import choco.cp.solver.constraints.global.tree.filtering.AbstractPropagator;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class Cost
extends AbstractPropagator {
    protected IStateInt[][] cost;
    protected IStateInt[][] minCost;
    protected IStateInt forestCost;

    public Cost(Object[] params) {
        super(params);
        this.cost = this.costStruct.getCost();
        this.minCost = this.costStruct.getMinCost();
        this.forestCost = this.costStruct.getForestCost();
    }

    @Override
    public String getTypePropag() {
        return "Cost propagation";
    }

    @Override
    public boolean feasibility() throws ContradictionException {
        this.forestCost = this.costStruct.getForestCost();
        return this.forestCost.get() <= this.tree.getObjective().getSup() && this.forestCost.get() >= this.tree.getObjective().getInf();
    }

    @Override
    public void filter() throws ContradictionException {
        StoredBitSet[] numFromVertGt = this.struct.getInputGraph().getSure().getNumFromVertCC();
        IStateInt[] deltaCosts = this.costStruct.getDeltaCost();
        this.propagateStruct.setMinObjective(this.forestCost.get());
        for (int i = 0; i < this.nbVertices; ++i) {
            IntDomainVar var = this.nodes[i].getSuccessors();
            if (var.isInstantiated()) continue;
            int cc_i = numFromVertGt[i].nextSetBit(0);
            DisposableIntIterator values = var.getDomain().getIterator();
            while (values.hasNext()) {
                int j = values.next();
                if (this.forestCost.get() - deltaCosts[cc_i].get() + this.cost[i][j].get() <= this.tree.getObjective().getSup() && this.forestCost.get() - deltaCosts[cc_i].get() + this.cost[i][j].get() >= this.tree.getObjective().getInf()) continue;
                int[] arc = new int[]{i, j};
                this.propagateStruct.addRemoval(arc);
            }
        }
    }

    public boolean allInstantiated() {
        for (int i = 0; i < this.nbVertices; ++i) {
            if (this.nodes[i].getSuccessors().isInstantiated()) continue;
            return false;
        }
        return true;
    }
}

