/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering;

import choco.cp.solver.constraints.global.tree.TreeSConstraint;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.StructuresAdvisor;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;

public class RemovalsAdvisor {
    protected boolean affiche = false;
    protected boolean afficheRemovals = false;
    protected boolean compatible;
    protected int nbNodes;
    protected Solver solver;
    protected TreeSConstraint treeConst;
    protected TreeParameters treeParams;
    protected Node[] nodes;
    protected StructuresAdvisor struct;
    protected int mintree;
    protected int maxtree;
    protected int minprop;
    protected int maxprop;
    protected int[] minStart;
    protected int[] maxStart;
    protected int minObjective;
    protected int maxObjective;
    protected BitSet[] graphRem;
    protected boolean updateNtree;
    protected boolean updateNprop;
    protected boolean updateObjective;
    protected boolean updateStart;
    protected boolean filter;

    public RemovalsAdvisor(Solver solver, TreeSConstraint treeConst, TreeParameters treeParams, StructuresAdvisor struct) {
        this.solver = solver;
        this.treeConst = treeConst;
        this.struct = struct;
        this.treeParams = treeParams;
        this.nodes = treeParams.getNodes();
        this.nbNodes = treeParams.getNbNodes();
        this.initialise();
    }

    public void initialise() {
        this.mintree = this.treeParams.getNtree().getInf();
        this.maxtree = this.treeParams.getNtree().getSup();
        this.minprop = this.treeParams.getNproper().getInf();
        this.maxprop = this.treeParams.getNproper().getSup();
        this.minObjective = this.treeParams.getObjective().getInf();
        this.maxObjective = this.treeParams.getObjective().getSup();
        this.graphRem = new BitSet[this.nbNodes];
        this.minStart = new int[this.nbNodes];
        this.maxStart = new int[this.nbNodes];
        for (int i = 0; i < this.nbNodes; ++i) {
            this.graphRem[i] = new BitSet(this.nbNodes);
            this.minStart[i] = this.nodes[i].getTimeWindow().getInf();
            this.maxStart[i] = this.nodes[i].getTimeWindow().getSup();
        }
        this.updateNtree = false;
        this.updateNprop = false;
        this.updateStart = false;
        this.updateObjective = false;
        this.filter = false;
    }

    public void startRemovals() throws ContradictionException {
        StoredBitSet[] trueGraph = this.struct.getInputGraph().getSure().getGraph();
        if (this.updateNtree && this.maxtree < this.treeParams.getNtree().getSup()) {
            this.filter = true;
            this.treeParams.getNtree().updateSup(this.maxtree, this.treeConst.cIndices[0]);
        }
        if (this.updateNtree && this.mintree > this.treeParams.getNtree().getInf()) {
            this.filter = true;
            this.treeParams.getNtree().updateInf(this.mintree, this.treeConst.cIndices[0]);
        }
        if (this.updateNprop && this.maxprop < this.treeParams.getNproper().getSup()) {
            this.filter = true;
            this.treeParams.getNproper().updateSup(this.maxprop, this.treeConst.cIndices[1]);
        }
        if (this.updateNprop && this.minprop > this.treeParams.getNproper().getInf()) {
            this.filter = true;
            this.treeParams.getNproper().updateInf(this.minprop, this.treeConst.cIndices[1]);
        }
        if (this.updateObjective && this.maxObjective < this.treeParams.getObjective().getSup()) {
            this.filter = true;
            this.treeParams.getObjective().updateSup(this.maxObjective, this.treeConst.cIndices[2]);
        }
        if (this.updateObjective && this.minObjective > this.treeParams.getObjective().getInf()) {
            this.filter = true;
            this.treeParams.getObjective().updateInf(this.minObjective, this.treeConst.cIndices[2]);
        }
        for (int i = 0; i < this.nbNodes; ++i) {
            IntDomainVar var_i = this.nodes[i].getSuccessors();
            if (this.updateStart) {
                if (this.maxStart[i] < this.nodes[i].getTimeWindow().getSup()) {
                    this.nodes[i].getTimeWindow().updateSup(this.maxStart[i], this.treeConst.cIndices[this.nbNodes + 3 + i]);
                }
                if (this.minStart[i] > this.nodes[i].getTimeWindow().getInf()) {
                    this.nodes[i].getTimeWindow().updateInf(this.minStart[i], this.treeConst.cIndices[this.nbNodes + 3 + i]);
                }
            }
            int j = this.graphRem[i].nextSetBit(0);
            while (j >= 0) {
                if (var_i.canBeInstantiatedTo(j)) {
                    this.filter = true;
                    if (this.afficheRemovals) {
                        System.out.println("1-Removals: suppression effective de l'arc (" + i + "," + j + ")");
                    }
                    var_i.removeVal(j, this.treeConst.cIndices[i + 3]);
                }
                if (var_i.isInstantiatedTo(j) && i != j) {
                    if (this.afficheRemovals) {
                        System.out.println("1-Removals: suppression de l'arc (" + i + "," + j + ") qui est instancie => FAIL");
                    }
                    var_i.removeVal(j, this.treeConst.cIndices[i + 3]);
                    this.compatible = false;
                }
                j = this.graphRem[i].nextSetBit(j + 1);
            }
            if (!var_i.isInstantiated() || trueGraph[i].get(var_i.getVal())) continue;
            j = var_i.getVal();
            IntDomainVar var_j = this.nodes[j].getSuccessors();
            if (var_j.canBeInstantiatedTo(i) && j != i) {
                if (this.afficheRemovals) {
                    System.out.println("2-Removals: suppression de l'arc (" + j + "," + i + ")");
                }
                var_j.removeVal(i, this.treeConst.cIndices[j + 3]);
                this.filter = true;
            }
            if (!var_j.isInstantiated() || !var_j.isInstantiatedTo(i) || i == j) continue;
            if (this.afficheRemovals) {
                System.out.println("2-Removals: suppression de l'arc (" + j + "," + i + ") qui est instancie => FAIL");
            }
            var_j.removeVal(i, this.treeConst.cIndices[j + 3]);
            this.compatible = false;
        }
    }

    public BitSet[] getGraphRem() {
        return this.graphRem;
    }

    public void addRemoval(int[] arc) {
        this.graphRem[arc[0]].set(arc[1], true);
    }

    public void setMinStart(int idx, int min) {
        if (this.minStart[idx] < min) {
            this.minStart[idx] = min;
            this.updateStart = true;
        }
    }

    public void setMaxStart(int idx, int max) {
        if (this.maxStart[idx] > max) {
            this.maxStart[idx] = max;
            this.updateStart = true;
        }
    }

    public void setMaxNtree(int val) throws ContradictionException {
        if (val < this.maxtree) {
            this.maxtree = val;
            this.updateNtree = true;
        }
    }

    public void setMinNtree(int val) throws ContradictionException {
        if (val > this.mintree) {
            this.mintree = val;
            this.updateNtree = true;
        }
    }

    public void setMaxNProper(int val) throws ContradictionException {
        if (val < this.maxprop) {
            this.maxprop = val;
            this.updateNprop = true;
        }
    }

    public void setMinNProper(int val) throws ContradictionException {
        if (val > this.minprop) {
            this.minprop = val;
            this.updateNprop = true;
        }
    }

    public void setMaxObjective(int val) throws ContradictionException {
        if (val < this.maxObjective) {
            this.maxObjective = val;
            this.updateObjective = true;
        }
    }

    public void setMinObjective(int val) throws ContradictionException {
        if (val > this.minObjective) {
            this.minObjective = val;
            this.updateObjective = true;
        }
    }

    public boolean isFilter() {
        return this.filter;
    }
}

