/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering;

import choco.cp.solver.constraints.global.tree.TreeSConstraint;
import choco.cp.solver.constraints.global.tree.filtering.AbstractPropagator;
import choco.cp.solver.constraints.global.tree.filtering.RemovalsAdvisor;
import choco.cp.solver.constraints.global.tree.filtering.costFiltering.Cost;
import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.Incomparability;
import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.Nproper;
import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.globalCardConstraint.GlobalCardinalityNoLoop;
import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.precedences.Precedences;
import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.timeWindows.TimeWindow;
import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.tree.Tree;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.StructuresAdvisor;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.costStrutures.CostStructure;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import java.util.LinkedList;
import java.util.Queue;

public class FilteringAdvisor {
    protected boolean affiche;
    protected Solver solver;
    protected TreeSConstraint treeConst;
    protected TreeParameters tree;
    protected StructuresAdvisor struct;
    protected CostStructure costStruct;
    protected RemovalsAdvisor propagateStruct;
    protected Queue<AbstractPropagator> toPropagate;
    protected Tree propagateTree;
    protected GlobalCardinalityNoLoop propagateGlobalCard;
    protected Nproper propagateNProper;
    protected Precedences propagatePrec;
    protected Incomparability propagateIncomp;
    protected TimeWindow propagateTW;
    protected Cost propagateCost;

    public FilteringAdvisor(Solver solver, TreeSConstraint treeConst, TreeParameters tree, StructuresAdvisor struct, boolean affiche) {
        this.solver = solver;
        this.treeConst = treeConst;
        this.tree = tree;
        this.struct = struct;
        this.costStruct = struct.getCostStruct();
        this.affiche = affiche;
        this.propagateStruct = new RemovalsAdvisor(this.solver, this.treeConst, this.tree, this.struct);
        Object[] params = new Object[]{this.solver, this.tree, this.treeConst.cIndices, this.struct, this.costStruct, this.propagateStruct, this.affiche};
        this.toPropagate = new LinkedList<AbstractPropagator>();
        this.propagateTree = new Tree(params);
        this.toPropagate.offer(this.propagateTree);
        this.propagatePrec = new Precedences(params);
        this.toPropagate.offer(this.propagatePrec);
        this.propagateIncomp = new Incomparability(params);
        this.toPropagate.offer(this.propagateIncomp);
        this.propagateTW = new TimeWindow(params);
        this.toPropagate.offer(this.propagateTW);
        this.propagateNProper = new Nproper(params);
        this.toPropagate.offer(this.propagateNProper);
        this.propagateCost = new Cost(params);
        this.toPropagate.offer(this.propagateCost);
        Object[] gccParams = new Object[]{this.tree, this.struct, this.affiche};
        this.propagateGlobalCard = new GlobalCardinalityNoLoop(this.solver, gccParams);
    }

    public boolean applyFiltering() throws ContradictionException {
        this.propagateStruct.initialise();
        if (this.struct.isUpdateDegree() && !this.propagateGlobalCard.applyGCC(this.propagateStruct)) {
            if (this.affiche) {
                System.out.println("ECHEC => Degree propagation");
            }
            this.treeConst.fail();
        }
        LinkedList<AbstractPropagator> currentQueue = new LinkedList<AbstractPropagator>(this.toPropagate);
        while (!currentQueue.isEmpty()) {
            AbstractPropagator current = (AbstractPropagator)currentQueue.poll();
            if (current.feasibility()) {
                current.filter();
                continue;
            }
            if (this.affiche) {
                System.out.println("ECHEC => " + current.getTypePropag());
            }
            this.treeConst.fail();
        }
        this.propagateStruct.startRemovals();
        return this.propagateStruct.isFilter();
    }
}

