/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.deduction;

import choco.cp.solver.constraints.global.tree.deduction.AbstractDeduction;
import choco.kernel.memory.trailing.StoredBitSet;
import java.util.BitSet;

public class OrderedGraphDeduction
extends AbstractDeduction {
    public OrderedGraphDeduction(Object[] params) {
        super(params);
    }

    public void updateOrderedGraphWithDeductions() {
        this.update = false;
        this.compatible = true;
        this.addFromSureGraph();
        this.updatePrecs();
        this.addPrecsFromDoms();
        this.addPrecsFromGraph();
        this.updatePrecsWithCondPrecs();
        this.updatePrecsWithIncs();
    }

    private void addFromSureGraph() {
        for (int i = 0; i < this.nbVertices; ++i) {
            int[] arc;
            int j;
            if (this.inputGraph.getSure().getSuccessors(i).cardinality() != 1 || i == (j = this.inputGraph.getSure().getSuccessors(i).nextSetBit(0)) || this.precs.getSuccessors(i).get(j) || !this.isCompatible(arc = new int[]{i, j})) continue;
            if (this.affiche) {
                System.out.println("0- ajout de l'arc: (" + i + "," + j + ") dans Gprec");
            }
            this.addInStruct(arc);
        }
    }

    private void addPrecsFromGraph() {
        for (int i = 0; i < this.nbVertices; ++i) {
            int dest;
            int[] arc;
            StoredBitSet prec = this.precs.getSuccessors(i);
            if (this.inputGraph.isFixedSucc(i) || this.inputGraph.getPotentialRoots().get(i)) continue;
            BitSet common = new BitSet(this.nbVertices);
            common.set(0, this.nbVertices, true);
            StoredBitSet maybeSucc = this.inputGraph.getMaybe().getSuccessors(i);
            int j = maybeSucc.nextSetBit(0);
            while (j >= 0) {
                if (j != i) {
                    common.and(this.precs.getDescendants(j));
                }
                j = maybeSucc.nextSetBit(j + 1);
            }
            if (common.cardinality() == 1 && !prec.get(common.nextSetBit(0)) && this.isCompatible(arc = new int[]{i, dest = common.nextSetBit(0)}) && i != dest) {
                if (this.affiche) {
                    System.out.println("1- ajout de l'arc: (" + i + "," + dest + ") dans Gp");
                }
                this.addInStruct(arc);
            }
            if (common.cardinality() <= 1) continue;
            dest = common.nextSetBit(0);
            while (dest >= 0) {
                common.xor(this.precs.getDescendants(dest));
                if (dest != i && common.cardinality() == 0 && !prec.get(dest) && this.isCompatible(arc = new int[]{i, dest})) {
                    if (this.affiche) {
                        System.out.println("2- ajout de l'arc: (" + i + "," + dest + ") dans Gp");
                    }
                    this.addInStruct(arc);
                }
                dest = common.nextSetBit(dest + 1);
            }
        }
    }

    private void updatePrecs() {
        for (int i = 0; i < this.nbVertices; ++i) {
            StoredBitSet mandSucc = this.precs.getSuccessors(i);
            if (mandSucc.cardinality() <= 1) continue;
            BitSet iToLfi = new BitSet(this.nbVertices);
            iToLfi.set(i, true);
            int lfi = i;
            Boolean testLoop = true;
            while (this.inputGraph.isFixedSucc(lfi) && testLoop.booleanValue()) {
                int slfi = this.inputGraph.getSure().getSuccessors(lfi).nextSetBit(0);
                if (!iToLfi.get(slfi) && slfi != lfi) {
                    lfi = slfi;
                    iToLfi.set(lfi, true);
                    continue;
                }
                testLoop = false;
            }
            if (lfi == i) continue;
            int j = mandSucc.nextSetBit(0);
            while (j >= 0) {
                int[] arc = new int[]{lfi, j};
                if (lfi != j && !iToLfi.get(j) && this.isCompatible(arc)) {
                    if (this.affiche) {
                        System.out.println("Struct[updatePred()]: (" + i + "," + j + ") ==> (" + lfi + "," + j + ")");
                    }
                    this.addInStruct(arc);
                }
                j = mandSucc.nextSetBit(j + 1);
            }
        }
    }

    private void addPrecsFromDoms() {
        BitSet[][] dominators = this.doms.getDominators();
        for (int i = 0; i < this.nbVertices; ++i) {
            BitSet idesc = this.precs.getDescendants(i);
            int j = idesc.nextSetBit(0);
            while (j >= 0) {
                if (j != i) {
                    int k = dominators[i][j].nextSetBit(0);
                    while (k >= 0) {
                        if (i != k && !this.precs.getDescendants(i).get(k)) {
                            if (this.affiche) {
                                System.out.println("(" + i + " -> " + k + ") -> " + j);
                            }
                            int[] arc1 = new int[]{i, k};
                            if (this.affiche) {
                                System.out.println("\ttry (" + i + "," + k + ") in Gp");
                            }
                            if (this.isCompatible(arc1)) {
                                this.addInStruct(arc1);
                                if (this.affiche) {
                                    System.out.println("\t\t1- ajoute: (" + i + "," + k + ") dans Gp");
                                }
                            }
                        }
                        if (k != j && !this.precs.getDescendants(k).get(j)) {
                            if (this.affiche) {
                                System.out.println("" + i + " -> (" + k + " -> " + j + ")");
                            }
                            int[] arc2 = new int[]{k, j};
                            if (this.affiche) {
                                System.out.println("\ttry (" + k + "," + j + ") in Gp");
                            }
                            if (this.isCompatible(arc2)) {
                                this.addInStruct(arc2);
                                if (this.affiche) {
                                    System.out.println("\t\t2- ajoute: (" + k + "," + j + ") dans Gp");
                                }
                            }
                        }
                        k = dominators[i][j].nextSetBit(k + 1);
                    }
                }
                j = idesc.nextSetBit(j + 1);
            }
        }
    }

    private void updatePrecsWithIncs() {
        for (int u = 0; u < this.nbVertices; ++u) {
            BitSet A_u = this.precs.getAncestors(u);
            A_u.set(u, true);
            int v = this.precs.getSuccessors(u).nextSetBit(0);
            while (v >= 0) {
                if (u != v) {
                    BitSet A_v = this.precs.getAncestors(v);
                    A_v.set(v, false);
                    int u_a = A_u.nextSetBit(0);
                    while (u_a >= 0) {
                        StoredBitSet inc_ua = this.incomp.getSuccessors(u_a);
                        int w = inc_ua.nextSetBit(0);
                        while (w >= 0) {
                            if (!this.precs.getSuccessors(w).get(v)) {
                                BitSet A_w = this.precs.getAncestors(w);
                                A_w.set(w, false);
                                A_w.and(A_v);
                                int[] arc = new int[]{w, v};
                                if (this.isCompatible(arc) && w != v && A_w.cardinality() > 0) {
                                    if (this.affiche) {
                                        System.out.println("Structure[updatePrecsWithIncs()]: (" + w + "," + v + ") dans Gp");
                                    }
                                    this.addInStruct(arc);
                                }
                            }
                            w = inc_ua.nextSetBit(w + 1);
                        }
                        u_a = A_u.nextSetBit(u_a + 1);
                    }
                }
                v = this.precs.getSuccessors(u).nextSetBit(v + 1);
            }
        }
    }

    private boolean isCompatible(int[] arc) {
        boolean cycle = false;
        boolean transitive = false;
        int src = arc[0];
        int dest = arc[1];
        if (src == dest) {
            this.compatible = false;
            if (this.affiche) {
                System.out.println("\t\t1- (" + src + "," + dest + ") incompatible dans Gp");
            }
            return false;
        }
        BitSet desc_1 = this.precs.getDescendants(dest);
        if (desc_1.get(src)) {
            cycle = true;
        }
        if (!cycle) {
            BitSet desc_2 = this.precs.getDescendants(src);
            if (desc_2.get(dest) && !this.precs.getSuccessors(src).get(dest)) {
                if (this.affiche) {
                    System.out.println("\t\t(" + src + "," + dest + ") incompatible dans Gp => transitif");
                }
                transitive = true;
            }
            return !transitive;
        }
        if (this.affiche) {
            System.out.println("\t\t----------------------------");
            System.out.println("\t\tprec(" + src + "," + dest + ") => cycle");
            this.precs.showAllDesc();
            System.out.println("\t\tD_" + dest + "(Gp) = " + desc_1.toString());
            System.out.println("\t\t(" + src + "," + dest + ") incompatible dans Gp => cycle");
            System.out.println("\t\t----------------------------");
        }
        this.compatible = false;
        return false;
    }

    private void addInStruct(int[] arc) {
        int src = arc[0];
        int dest = arc[1];
        this.update = this.precs.addPrec(src, dest);
    }

    private void updatePrecsWithCondPrecs() {
        for (int src = 0; src < this.nbVertices; ++src) {
            int dest;
            StoredBitSet prec = this.precs.getSuccessors(src);
            StoredBitSet pickup = this.condPrecs.getSuccessors(src);
            if (prec.cardinality() > 0) {
                dest = pickup.nextSetBit(0);
                while (dest >= 0) {
                    int[] arc = new int[]{src, dest};
                    if (this.isCompatible(arc)) {
                        this.addInStruct(arc);
                        if (this.affiche) {
                            System.out.println("2- Pickup: ajout de l'arc (" + src + "," + dest + ") dans Gp");
                        }
                        pickup.set(dest, false);
                    }
                    dest = pickup.nextSetBit(dest + 1);
                }
            }
            if (this.inputGraph.isFixedSucc(src) && src != (dest = this.inputGraph.getFixedSucc(src)) && pickup.cardinality() > 0) {
                int succ = pickup.nextSetBit(0);
                while (succ >= 0) {
                    int[] arc;
                    if (!prec.get(succ) && this.isCompatible(arc = new int[]{src, succ})) {
                        this.addInStruct(arc);
                        if (this.affiche) {
                            System.out.println("4- Pickup: ajout de l'arc (" + src + "," + succ + ") dans Gp");
                        }
                        pickup.set(succ, false);
                    }
                    succ = pickup.nextSetBit(succ + 1);
                }
            }
            if (this.inputGraph.isFixedSucc(src) || this.inputGraph.getPotentialRoots().get(src)) continue;
            dest = pickup.nextSetBit(0);
            while (dest >= 0) {
                int[] arc = new int[]{src, dest};
                if (this.isCompatible(arc)) {
                    this.addInStruct(arc);
                    if (this.affiche) {
                        System.out.println("6- Pickup: ajout de l'arc (" + src + "," + dest + ") dans Gp");
                    }
                    pickup.set(dest, false);
                }
                dest = pickup.nextSetBit(dest + 1);
            }
        }
    }
}

