/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.tree.deduction.DeductionsAdvisor;
import choco.cp.solver.constraints.global.tree.filtering.FilteringAdvisor;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.StructuresAdvisor;
import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class TreeSConstraint
extends AbstractLargeIntSConstraint {
    protected boolean affiche = false;
    protected Solver solver;
    protected TreeParameters tree;
    protected int nbNodes;
    protected StructuresAdvisor structure;
    protected DeductionsAdvisor deduction;
    protected FilteringAdvisor filtering;

    public TreeSConstraint(IntDomainVar[] allVars, TreeParameters tree) {
        super(allVars);
        this.tree = tree;
    }

    @Override
    public boolean isSatisfied() {
        return false;
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.affiche) {
            CPSolver.flushLogs();
            System.out.println("*********************************");
            this.structure.getInputGraph().showGlobal();
            System.out.println("-------------------------");
            this.structure.getPrecs().showPrecGraph();
            System.out.println("-------------------------");
            this.structure.getDoms().showDoms(0);
        }
        this.solver = this.tree.getSolver();
        this.nbNodes = this.tree.getNbNodes();
        this.structure = new StructuresAdvisor(this.solver, this.tree);
        this.deduction = new DeductionsAdvisor(this.solver, this.tree, this.structure, this.affiche);
        this.filtering = new FilteringAdvisor(this.solver, this, this.tree, this.structure, this.affiche);
    }

    @Override
    public void propagate() throws ContradictionException {
        boolean update;
        if (this.affiche) {
            CPSolver.flushLogs();
            System.out.println("=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=");
            System.out.println("propagate " + this.solver.getEnvironment().getWorldIndex());
        }
        do {
            this.structure.applyStructure();
            update = this.deduction.applyDeduction();
            if (!this.deduction.isCompatible()) {
                if (this.affiche) {
                    System.out.println("\t update fail()");
                }
                update = false;
                this.fail();
                continue;
            }
            boolean bl = update = this.filtering.applyFiltering() || update;
        } while (update);
        if (this.affiche) {
            CPSolver.flushLogs();
            System.out.println("=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=");
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            if (this.affiche) {
                System.out.println("awakeOnInst");
            }
            this.structure.getInputGraph().updateOnInst(idx - 3);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            if (this.affiche) {
                System.out.println("awakeOnInf");
            }
            this.structure.getInputGraph().updateOnInf(idx - 3);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            if (this.affiche) {
                System.out.println("awakeOnSup");
            }
            this.structure.getInputGraph().updateOnSup(idx - 3);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            if (this.affiche) {
                System.out.println("awakeOnBounds");
            }
            this.structure.getInputGraph().updateOnBounds(idx - 3);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int idx, int i) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            if (this.affiche) {
                System.out.println("awakeOnRem");
            }
            this.structure.getInputGraph().updateOnRem(idx - 3, i);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (2 < idx && idx < this.nbNodes + 3) {
            if (this.affiche) {
                System.out.println("awakeOnRemovals");
            }
            this.structure.getInputGraph().updateOnRemovals(idx - 3, deltaDomain);
        }
        this.constAwake(false);
    }
}

