/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.trees;

import choco.cp.solver.constraints.global.scheduling.trees.AbstractVilimStatus;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.common.opres.graph.IBinaryNode;
import choco.kernel.common.opres.graph.ProperBinaryTree;
import choco.kernel.common.util.TaskComparators;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.scheduling.ITask;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class AbstractVilimTree
extends ProperBinaryTree
implements IVilimTree {
    private IVilimTree.TreeMode mode;
    private final Map<ITask, IBinaryNode> map;

    public AbstractVilimTree(List<? extends ITask> tasks) {
        this.map = new HashMap<ITask, IBinaryNode>(tasks.size());
        for (ITask iTask : tasks) {
            this.insert(iTask);
        }
    }

    protected Comparator<ITask> getTaskComparator() {
        switch (this.mode) {
            case ECT: {
                return TaskComparators.makeEarliestStartingTimeCmp();
            }
            case LST: {
                return TaskComparators.makeLatestCompletionTimeCmp();
            }
        }
        return null;
    }

    protected IBinaryNode getLeaf(ITask task) {
        return this.map.get(task);
    }

    protected void insertTask(ITask task, AbstractVilimStatus<?> leafStatus, AbstractVilimStatus<?> internalStatus) {
        leafStatus.setTask(task);
        IBinaryNode leaf = this.insert(leafStatus, internalStatus, false);
        this.map.put(task, leaf);
    }

    @Override
    public void reset() {
        for (IBinaryNode leaf : this.map.values()) {
            ((AbstractVilimStatus)leaf.getNodeStatus()).reset();
        }
        this.fireTreeChanged();
    }

    protected void applySort(IBinaryNode current, ListIterator<ITask> iter) {
        if (current.isLeaf()) {
            ITask t = iter.next();
            AbstractVilimStatus s = (AbstractVilimStatus)current.getNodeStatus();
            s.setTask(t);
            s.reset();
            this.map.put(t, current);
        } else {
            this.applySort(current.getLeftChild(), iter);
            this.applySort(current.getRightChild(), iter);
            current.getNodeStatus().updateInternalNode(current);
        }
    }

    @Override
    public void sort() {
        if (this.getNbLeaves() > 1) {
            ITask[] tmp = this.map.keySet().toArray(new ITask[this.map.keySet().size()]);
            Arrays.sort(tmp, this.getTaskComparator());
            this.map.clear();
            ListIterator<ITask> iter = Arrays.asList(tmp).listIterator();
            this.applySort(this.getRoot(), iter);
            if (iter.hasNext()) {
                throw new SolverException("inconsitent vilim tree");
            }
        }
    }

    @Override
    public final IVilimTree.TreeMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(IVilimTree.TreeMode mode) {
        this.mode = mode;
        this.sort();
    }

    @Override
    public boolean contains(ITask task) {
        return this.map.containsKey(task);
    }

    @Override
    public void remove(ITask task) {
        if (this.map.containsKey(task)) {
            this.remove(this.map.remove(task), false);
        }
    }

    @Override
    public String toDotty() {
        return this.getRoot().toDotty();
    }

    static enum NodeType {
        THETA,
        LAMBDA,
        NIL,
        INTERNAL;

    }
}

