/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.search.integer.valselector.RandomIntValSelector;
import choco.cp.solver.search.integer.varselector.RandomIntVarSelector;
import choco.kernel.common.util.IntIterator;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class VariablePrecedenceDisjoint
extends AbstractLargeIntSConstraint {
    public static IntDomainVar[] makeVars(IntDomainVar b, IntDomainVar s0, IntDomainVar d0, IntDomainVar s1, IntDomainVar d1) {
        IntDomainVar[] vars = new IntDomainVar[]{b, s0, d0, s1, d1};
        return vars;
    }

    public VariablePrecedenceDisjoint(IntDomainVar b, IntDomainVar s0, IntDomainVar d0, IntDomainVar s1, IntDomainVar d1) {
        super(VariablePrecedenceDisjoint.makeVars(b, s0, d0, s1, d1));
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            return 8;
        }
        return 3;
    }

    public void propagateP1() throws ContradictionException {
        for (boolean b = true; b; b |= this.vars[2].updateSup(this.vars[3].getSup() - this.vars[1].getInf(), this.cIndices[2])) {
            b = false;
            b |= this.vars[3].updateInf(this.vars[1].getInf() + this.vars[2].getInf(), this.cIndices[3]);
            b |= this.vars[1].updateSup(this.vars[3].getSup() - this.vars[2].getInf(), this.cIndices[1]);
        }
    }

    public void propagateP2() throws ContradictionException {
        boolean b = true;
        while (b) {
            b = false;
            this.vars[1].updateInf(this.vars[3].getInf() + this.vars[4].getInf(), this.cIndices[1]);
            this.vars[3].updateSup(this.vars[1].getSup() - this.vars[4].getInf(), this.cIndices[3]);
            this.vars[4].updateSup(this.vars[1].getSup() - this.vars[3].getInf(), this.cIndices[4]);
        }
    }

    public Boolean isP1Entailed() {
        if (this.vars[1].getSup() + this.vars[2].getSup() <= this.vars[3].getInf()) {
            return Boolean.TRUE;
        }
        if (this.vars[1].getInf() + this.vars[2].getInf() > this.vars[3].getSup()) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean isP2Entailed() {
        if (this.vars[3].getSup() + this.vars[4].getSup() <= this.vars[1].getInf()) {
            return Boolean.TRUE;
        }
        if (this.vars[3].getInf() + this.vars[4].getInf() > this.vars[1].getSup()) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            int val = this.vars[0].getVal();
            if (val == 1) {
                this.propagateP1();
            } else {
                this.propagateP2();
            }
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    public void filterOnP1P2TowardsB() throws ContradictionException {
        Boolean b = this.isP1Entailed();
        if (b != null) {
            if (b.booleanValue()) {
                this.vars[0].instantiate(1, this.cIndices[0]);
            } else {
                this.vars[0].instantiate(0, this.cIndices[0]);
                this.propagateP2();
            }
        }
        if ((b = this.isP2Entailed()) != null) {
            if (b.booleanValue()) {
                this.vars[0].instantiate(0, this.cIndices[0]);
            } else {
                this.vars[0].instantiate(1, this.cIndices[0]);
                this.propagateP1();
            }
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (this.vars[0].isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.vars[0].isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.vars[0].isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.vars[0].isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.vars[0].isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.vars[0].isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        if (this.vars[0].isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.vars[0].isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.vars[0].isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.vars[0].isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public boolean isSatisfied() {
        if (this.vars[0].isInstantiatedTo(1)) {
            return this.vars[1].getVal() + this.vars[2].getVal() <= this.vars[3].getVal();
        }
        return this.vars[3].getVal() + this.vars[4].getVal() <= this.vars[1].getVal();
    }

    public String toString() {
        return "VDisjunction " + this.vars[1] + "," + this.vars[2] + " - " + this.vars[3] + "," + this.vars[4];
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            CPModel m = new CPModel();
            IntegerVariable k1 = Choco.makeIntVar("dx", 2, 7, new String[0]);
            IntegerVariable k2 = Choco.makeIntVar("dy", 2, 7, new String[0]);
            IntegerVariable x = Choco.makeIntVar("x", 1, 10, new String[0]);
            IntegerVariable y = Choco.makeIntVar("y", 1, 10, new String[0]);
            IntegerVariable z = Choco.makeIntVar("z", 0, 1, new String[0]);
            m.addVariables("cp:bound", x, y, k1, k2, z);
            CPSolver s = new CPSolver();
            s.read(m);
            s.post((SConstraint)new VariablePrecedenceDisjoint(s.getVar(z), s.getVar(x), s.getVar(k1), s.getVar(y), s.getVar(k2)));
            s.setVarIntSelector(new RandomIntVarSelector(s, i));
            s.setValIntSelector(new RandomIntValSelector(i + 1));
            s.solve();
            while (s.nextSolution() == Boolean.TRUE) {
            }
            if (s.getNbSolutions() != 1392) {
                throw new Error("wrong number of solutions " + s.getNbSolutions());
            }
            System.out.println("Nb solution : " + s.getNbSolutions() + " " + s.getNodeCount());
        }
    }
}

