/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.IncrementalPertSConstraint;
import choco.cp.solver.constraints.global.scheduling.PertSConstraint;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.scheduling.IPrecedenceNetwork;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;

public class SchedulerConfig {
    public final Solver solver;
    protected IntDomainVar makespan;
    protected IPrecedenceNetwork precedenceNetwork;
    protected boolean usePrecedenceNetwork = false;
    protected boolean incrementalPert = true;
    protected boolean redundantReasonningsOnTasks = false;

    public SchedulerConfig(Solver solver) {
        this.solver = solver;
    }

    public final int getMakespanValue() {
        return this.makespan == null ? Integer.MAX_VALUE : this.makespan.getVal();
    }

    public final IntDomainVar getMakespan() {
        return this.makespan;
    }

    public final IntDomainVar createMakespan() {
        if (this.makespan == null) {
            this.makespan = this.solver.createBoundIntVar("makespan", -2147483647, 0x7FFFFFFE);
        }
        return this.makespan;
    }

    public final void setMakespan(IntDomainVar makespan) {
        if (this.makespan != null) {
            throw new SolverException("duplicate makespan variable");
        }
        this.makespan = makespan;
    }

    public final void setMakespan(int horizon) {
        if (this.makespan == null) {
            this.makespan = this.solver.createBoundIntVar("makespan", Integer.MIN_VALUE, horizon);
        } else {
            this.solver.post(this.solver.leq((IntExp)this.makespan, horizon));
        }
    }

    public final IPrecedenceNetwork getPrecedenceNetwork() {
        return this.precedenceNetwork;
    }

    public final boolean isUsingPrecedenceNetwork() {
        return this.usePrecedenceNetwork;
    }

    public final void setPrecedenceNetwork(boolean usage) {
        this.usePrecedenceNetwork = usage;
    }

    public final boolean isIncrementalPert() {
        return this.incrementalPert;
    }

    public final void setIncrementalPert(boolean incrementalPert) {
        this.incrementalPert = incrementalPert;
    }

    public final IPrecedenceNetwork createPrecedenceNetwork() {
        if (this.usePrecedenceNetwork) {
            if (this.precedenceNetwork == null) {
                TaskVar[] tasks = new TaskVar[this.solver.getNbTaskVars()];
                for (int i = 0; i < this.solver.getNbTaskVars(); ++i) {
                    tasks[i] = this.solver.getTaskVar(i);
                }
                this.createMakespan();
                PertSConstraint cstr = this.isIncrementalPert() ? new IncrementalPertSConstraint(this.solver, this.makespan) : new PertSConstraint(this.solver, this.makespan);
                this.solver.post(cstr);
                this.precedenceNetwork = cstr;
            }
            return this.precedenceNetwork;
        }
        return null;
    }

    public final boolean isRedundantReasonningsOnTasks() {
        return this.redundantReasonningsOnTasks;
    }

    public final void setRedundantReasonningsOnTasks(boolean redundantReasonningsOnTasks) {
        this.redundantReasonningsOnTasks = redundantReasonningsOnTasks;
    }
}

