/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class PrecedenceWithDelta
extends AbstractLargeIntSConstraint {
    public PrecedenceWithDelta(IntDomainVar x1, IntDomainVar x2, IntDomainVar y1, IntDomainVar y2) {
        super(new IntDomainVar[]{x1, x2, y1, y2});
    }

    public boolean filterFromXToY() throws ContradictionException {
        boolean b = false;
        int lbX = this.vars[0].getInf() + this.vars[1].getInf();
        b |= this.vars[2].updateInf(lbX - this.vars[3].getSup(), this.cIndices[2]);
        return b |= this.vars[3].updateInf(lbX - this.vars[2].getSup(), this.cIndices[3]);
    }

    public boolean filterFromYToX() throws ContradictionException {
        boolean b = false;
        int ubY = this.vars[2].getSup() + this.vars[3].getSup();
        b |= this.vars[0].updateSup(ubY - this.vars[1].getInf(), this.cIndices[0]);
        return b |= this.vars[1].updateSup(ubY - this.vars[0].getInf(), this.cIndices[1]);
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        if (varIdx == 0 || varIdx == 1) {
            this.propagate();
        }
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        if (varIdx == 2 || varIdx == 3) {
            this.propagate();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public void propagate() throws ContradictionException {
        for (boolean fixpoint = true; fixpoint; fixpoint |= this.filterFromYToX()) {
            fixpoint = false;
            fixpoint |= this.filterFromXToY();
        }
    }

    @Override
    public Boolean isEntailed() {
        int lb1 = this.vars[0].getInf() + this.vars[1].getInf();
        int ub1 = this.vars[0].getSup() + this.vars[1].getSup();
        int lb2 = this.vars[2].getInf() + this.vars[3].getInf();
        int ub2 = this.vars[2].getSup() + this.vars[3].getSup();
        if (ub1 <= lb2) {
            return Boolean.TRUE;
        }
        if (lb1 > ub2) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] + tuple[1] <= tuple[2] + tuple[3];
    }
}

