/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.search.integer.valselector.RandomIntValSelector;
import choco.cp.solver.search.integer.varselector.RandomIntVarSelector;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class PrecedenceReified
extends AbstractTernIntSConstraint {
    protected int k1;

    public PrecedenceReified(IntDomainVar x0, int k1, IntDomainVar x1, IntDomainVar b) {
        super(b, x0, x1);
        this.k1 = k1;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (idx == 1) {
            if (this.v1.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v2.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    public void propagateP1() throws ContradictionException {
        this.v2.updateInf(this.v1.getInf() + this.k1, this.cIdx2);
        this.v1.updateSup(this.v2.getSup() - this.k1, this.cIdx1);
    }

    public void propagateP2() throws ContradictionException {
        this.v2.updateSup(this.v1.getSup() + this.k1 - 1, this.cIdx2);
        this.v1.updateInf(this.v2.getInf() - this.k1 + 1, this.cIdx1);
    }

    public Boolean isP1Entailed() {
        if (this.v1.getSup() + this.k1 <= this.v2.getInf()) {
            return Boolean.TRUE;
        }
        if (this.v1.getInf() + this.k1 > this.v2.getSup()) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            int val = this.v0.getVal();
            if (val == 1) {
                this.propagateP1();
            } else {
                this.propagateP2();
            }
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    public void filterOnP1P2TowardsB() throws ContradictionException {
        Boolean b = this.isP1Entailed();
        if (b != null) {
            if (b.booleanValue()) {
                this.v0.instantiate(1, this.cIdx0);
            } else {
                this.v0.instantiate(0, this.cIdx0);
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public boolean isSatisfied() {
        if (this.v0.isInstantiatedTo(0)) {
            return this.v1.getVal() + this.k1 <= this.v2.getVal();
        }
        return this.v1.getVal() + this.k1 > this.v2.getVal();
    }

    public String toString() {
        return "Precedence Reified" + this.v1 + "," + this.k1 + " - " + this.v2;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            CPModel m = new CPModel();
            logger.finer("test2");
            int k1 = 5;
            IntegerVariable x = Choco.makeIntVar("x", 1, 10, new String[0]);
            IntegerVariable y = Choco.makeIntVar("y", 1, 10, new String[0]);
            m.addVariables("cp:bound", x, y);
            IntegerVariable z = Choco.makeIntVar("z", 0, 1, new String[0]);
            m.addConstraint(Choco.geq((IntegerExpressionVariable)x, 0));
            m.addConstraint(Choco.geq((IntegerExpressionVariable)y, 0));
            m.addConstraint(Choco.geq((IntegerExpressionVariable)z, 0));
            CPSolver s = new CPSolver();
            s.read(m);
            s.post((SConstraint)new PrecedenceReified(s.getVar(x), k1, s.getVar(y), s.getVar(z)));
            s.setVarIntSelector(new RandomIntVarSelector(s, i));
            s.setValIntSelector(new RandomIntValSelector(i + 1));
            s.solve();
            while (s.nextSolution() == Boolean.TRUE) {
            }
            if (s.getNbSolutions() != 100) {
                throw new Error("wrong number of solutions " + s.getNbSolutions());
            }
            System.out.println("Nb solution : " + s.getNbSolutions());
        }
    }
}

