/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.Choco;
import choco.cp.model.CPModel;
import choco.cp.solver.CPSolver;
import choco.cp.solver.search.integer.valselector.RandomIntValSelector;
import choco.cp.solver.search.integer.varselector.RandomIntVarSelector;
import choco.kernel.common.util.IntIterator;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class PrecedenceDisjoint
extends AbstractTernIntSConstraint {
    protected int k1;
    protected int k2;

    public PrecedenceDisjoint(IntDomainVar x0, int k1, IntDomainVar x1, int k2, IntDomainVar b) {
        super(b, x0, x1);
        this.k1 = k1;
        this.k2 = k2;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            return 8;
        }
        return 3;
    }

    public void propagateP1() throws ContradictionException {
        this.v2.updateInf(this.v1.getInf() + this.k1, this.cIdx2);
        this.v1.updateSup(this.v2.getSup() - this.k1, this.cIdx1);
    }

    public void propagateP2() throws ContradictionException {
        this.v1.updateInf(this.v2.getInf() + this.k2, this.cIdx1);
        this.v2.updateSup(this.v1.getSup() - this.k2, this.cIdx2);
    }

    public Boolean isP1Entailed() {
        if (this.v1.getSup() + this.k1 <= this.v2.getInf()) {
            return Boolean.TRUE;
        }
        if (this.v1.getInf() + this.k1 > this.v2.getSup()) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean isP2Entailed() {
        if (this.v2.getSup() + this.k2 <= this.v1.getInf()) {
            return Boolean.TRUE;
        }
        if (this.v2.getInf() + this.k2 > this.v1.getSup()) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            int val = this.v0.getVal();
            if (val == 1) {
                this.propagateP1();
            } else {
                this.propagateP2();
            }
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    public void filterOnP1P2TowardsB() throws ContradictionException {
        Boolean b = this.isP1Entailed();
        if (b != null) {
            if (b.booleanValue()) {
                this.v0.instantiate(1, this.cIdx0);
            } else {
                this.v0.instantiate(0, this.cIdx0);
                this.propagateP2();
            }
        }
        if ((b = this.isP2Entailed()) != null) {
            if (b.booleanValue()) {
                this.v0.instantiate(0, this.cIdx0);
            } else {
                this.v0.instantiate(1, this.cIdx0);
                this.propagateP1();
            }
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (this.v0.isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    @Override
    public boolean isSatisfied() {
        if (this.v0.isInstantiatedTo(1)) {
            return this.v1.getVal() + this.k1 <= this.v2.getVal();
        }
        return this.v2.getVal() + this.k2 <= this.v1.getVal();
    }

    public String toString() {
        return "Precedence " + this.v1 + "," + this.k1 + " - " + this.v2 + "," + this.k2;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1; ++i) {
            CPModel m = new CPModel();
            logger.finer("test2");
            int k1 = 5;
            int k2 = 5;
            IntegerVariable x = Choco.makeIntVar("x", 1, 10, new String[0]);
            IntegerVariable y = Choco.makeIntVar("y", 1, 10, new String[0]);
            m.addVariables("cp:bound", x, y);
            IntegerVariable z = Choco.makeIntVar("z", 0, 1, new String[0]);
            m.addConstraint(Choco.geq((IntegerExpressionVariable)x, 0));
            m.addConstraint(Choco.geq((IntegerExpressionVariable)y, 0));
            m.addConstraint(Choco.geq((IntegerExpressionVariable)z, 0));
            m.addConstraint(Choco.preceding(x, k1, y, k2, z));
            CPSolver s = new CPSolver();
            s.read(m);
            s.setVarIntSelector(new RandomIntVarSelector(s, i));
            s.setValIntSelector(new RandomIntValSelector(i + 1));
            s.solve();
            while (s.nextSolution() == Boolean.TRUE) {
            }
            if (s.getNbSolutions() != 30) {
                throw new Error("wrong number of solutions " + s.getNbSolutions());
            }
            System.out.println("Nb solution : " + s.getNbSolutions() + " " + s.getNodeCount());
        }
    }
}

