/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractTaskSConstraint;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.global.scheduling.IPrecedenceNetwork;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;

public class Precedence
extends AbstractTaskSConstraint {
    protected static final int DIR_IDX = 6;
    protected static final int ORIG = 0;
    protected static final int DEST = 1;
    protected final IPrecedenceNetwork network;

    public Precedence(IPrecedenceNetwork network, TaskVar task1, TaskVar task2, IntDomainVar direction) {
        super(task1, task2, direction);
        this.network = network;
    }

    protected Precedence(IPrecedenceNetwork network, TaskVar task1, TaskVar task2, IntDomainVar ... otherVars) {
        super(task1, task2, otherVars);
        this.network = network;
    }

    protected final int opposite(int val) {
        return val == 0 ? 1 : 0;
    }

    protected boolean needCheck() {
        return !this.vars[6].isInstantiated();
    }

    protected final boolean isSatisfied(int i, int j) {
        return this.taskvars[i].getLCT() < this.taskvars[j].getEST();
    }

    protected final boolean isNotSatisfied(int i, int j) {
        return this.taskvars[i].getECT() > this.taskvars[j].getLST();
    }

    protected final boolean checkTimeBounds(int i, int j) throws ContradictionException {
        boolean res = true;
        if (this.isSatisfied(i, j)) {
            this.setPrecedence(j);
        } else if (this.isNotSatisfied(i, j)) {
            this.setPrecedence(i);
            this.notifyNetwork(j, i);
            this.notifySolver(j, i);
        } else {
            res = false;
        }
        return res;
    }

    protected final boolean checkTimeBounds() throws ContradictionException {
        return this.checkTimeBounds(0, 1) || this.checkTimeBounds(1, 0);
    }

    protected final boolean checkNetwork() throws ContradictionException {
        boolean res = true;
        if (this.network.isConnected(this.taskvars[0], this.taskvars[1])) {
            this.setPrecedence(1);
            this.notifySolver(0, 1);
        } else if (this.network.isConnected(this.taskvars[1], this.taskvars[0])) {
            this.setPrecedence(0);
            this.notifySolver(1, 0);
        } else {
            res = false;
        }
        return res;
    }

    protected final void setPrecedence(int dir) throws ContradictionException {
        this.vars[6].instantiate(dir, this.cIndices[6]);
    }

    protected final void notifyNetwork(int i, int j) throws ContradictionException {
        this.network.firePrecedenceAdded(this.taskvars[i], this.taskvars[j]);
    }

    protected final void notifySolver(int i, int j) throws ContradictionException {
        this.solver.getPropagationEngine().postUpdateInf(this.taskvars[i].start(), this.getCIndiceStart(i));
        this.solver.getPropagationEngine().postUpdateSup(this.taskvars[j].start(), this.getCIndiceStart(j));
    }

    protected final void notifyDecision() throws ContradictionException {
        int dest = this.vars[6].getVal();
        int orig = this.opposite(dest);
        this.notifyNetwork(orig, dest);
        this.notifySolver(orig, dest);
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.vars[6].isInstantiated()) {
            this.notifyDecision();
        }
        super.awake();
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        if (this.needCheck() && !this.checkNetwork()) {
            int dest;
            int orig;
            int n = this.getNbTasks();
            if (varIdx < n) {
                int dest2;
                int orig2 = this.opposite(varIdx);
                if (this.isSatisfied(orig2, dest2 = varIdx)) {
                    this.setPrecedence(dest2);
                }
            } else if (varIdx < 2 * n && this.isNotSatisfied(orig = varIdx - n, dest = this.opposite(orig))) {
                this.setPrecedence(orig);
                this.notifyNetwork(dest, orig);
                this.notifySolver(dest, orig);
            }
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 6) {
            this.notifyDecision();
        } else {
            this.constAwake(false);
        }
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        if (this.needCheck() && !this.checkNetwork()) {
            int dest;
            int orig;
            int n = this.getNbTasks();
            if (varIdx < n) {
                int dest2 = varIdx;
                int orig2 = this.opposite(dest2);
                if (this.isNotSatisfied(orig2, dest2)) {
                    this.setPrecedence(orig2);
                    this.notifyNetwork(dest2, orig2);
                    this.notifySolver(dest2, orig2);
                }
            } else if (varIdx < 2 * n && this.isSatisfied(orig = varIdx - n, dest = this.opposite(varIdx))) {
                this.setPrecedence(dest);
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.needCheck() && !this.checkNetwork()) {
            this.checkTimeBounds();
        }
    }

    @Override
    public boolean isSatisfied() {
        int dest = this.vars[6].getVal();
        int orig = this.opposite(dest);
        return this.isSatisfied(orig, dest);
    }

    @Override
    public Boolean isEntailed() {
        if (this.vars[6].isInstantiated()) {
            int dest = this.vars[6].getVal();
            int orig = this.opposite(dest);
            if (this.isSatisfied(orig, dest)) {
                return Boolean.TRUE;
            }
            if (this.isNotSatisfied(orig, dest)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public AbstractSConstraint opposite() {
        return null;
    }

    protected final String getSign() {
        return this.vars[6].isInstantiatedTo(1) ? " << " : (this.vars[6].isInstantiatedTo(0) ? " >> " : " ? ");
    }

    @Override
    public String pretty() {
        return this.taskvars[0].pretty() + this.getSign() + this.taskvars[1].pretty();
    }

    public String toString() {
        return this.taskvars[0].getName() + this.getSign() + this.taskvars[1].getName();
    }
}

