/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.kernel.common.opres.graph.DagDTC;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntProcedure;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.scheduling.IPrecedenceNetwork;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import gnu.trove.TIntArrayList;

public class PertSConstraint
extends AbstractResourceSConstraint
implements IPrecedenceNetwork {
    private boolean initialContradiction = false;
    protected final IStateBool propagationControlMakespan;
    protected final IStateBool propagationControlInf;
    protected final IStateBool propagationControlSup;
    protected final DagDTC network;
    private final PrecedenceStack precStack;
    private final int[] allpaths;

    public PertSConstraint(Solver solver, IntDomainVar uppBound) {
        super("PERT", PertSConstraint.createTaskVarArray(solver), uppBound, new IntDomainVar[0]);
        int n = this.getNbTasks();
        this.network = new DagDTC(n);
        this.network.setTransitiveArcAdded(false);
        IEnvironment env = solver.getEnvironment();
        this.precStack = new PrecedenceStack(env, 3 * n);
        this.propagationControlInf = env.makeBool(true);
        this.propagationControlSup = env.makeBool(true);
        this.propagationControlMakespan = env.makeBool(false);
        this.allpaths = new int[n];
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.initialContradiction) {
            this.fail();
        }
        super.awake();
    }

    public final void propagateLowerBounds() throws ContradictionException {
        int[] order = this.network.getTopologicalOrder();
        for (int i = 0; i < order.length; ++i) {
            int idx = order[i];
            this.allpaths[idx] = this.taskvars[idx].getEST();
            TIntArrayList tmp = this.network.getPredecessors(idx);
            for (int j = 0; j < tmp.size(); ++j) {
                int orig = tmp.get(j);
                this.updateDuration(orig, idx);
                this.allpaths[idx] = Math.max(this.allpaths[idx], this.allpaths[orig] + this.taskvars[orig].getMinDuration());
            }
            if (!this.taskvars[idx].start().updateInf(this.allpaths[idx], this.getCIndiceStart(idx))) continue;
            this.updateCompulsoryPart(idx);
        }
        this.propagationControlInf.set(false);
    }

    protected void updateDuration(int i, int j) throws ContradictionException {
        IntDomainVar d = this.taskvars[i].duration();
        if (!this.taskvars[i].duration().isInstantiated()) {
            d.updateSup(this.taskvars[j].getLST() - this.taskvars[i].getEST(), this.getCIndiceDuration(i));
        }
    }

    public final void propagateUpperBounds() throws ContradictionException {
        int[] order = this.network.getTopologicalOrder();
        for (int i = order.length - 1; i >= 0; --i) {
            int idx = order[i];
            this.allpaths[idx] = this.taskvars[idx].getLST();
            TIntArrayList tmp = this.network.getSuccessors(idx);
            for (int j = 0; j < tmp.size(); ++j) {
                int dest = tmp.get(j);
                this.updateDuration(idx, dest);
                this.allpaths[idx] = Math.min(this.allpaths[idx], this.allpaths[dest] - this.taskvars[idx].getMinDuration());
            }
            if (!this.taskvars[idx].start().updateSup(this.allpaths[idx], this.getCIndiceStart(idx))) continue;
            this.updateCompulsoryPart(idx);
        }
        this.propagationControlMakespan.set(false);
        this.propagationControlSup.set(false);
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        if (varIdx < this.taskIntVarOffset) {
            this.updateCompulsoryPart(varIdx % this.getNbTasks());
            this.propagationControlInf.set(true);
            this.constAwake(false);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx < this.taskIntVarOffset) {
            this.updateCompulsoryPart(idx % this.getNbTasks());
            this.propagationControlInf.set(true);
            this.propagationControlSup.set(true);
        } else {
            this.propagationControlMakespan.set(true);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        if (varIdx < this.taskIntVarOffset) {
            this.updateCompulsoryPart(varIdx % this.getNbTasks());
            this.propagationControlSup.set(true);
        } else {
            this.propagationControlMakespan.set(true);
        }
        this.constAwake(false);
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.propagationControlInf.get()) {
            this.propagateLowerBounds();
        }
        if (this.propagationControlSup.get() || this.propagationControlMakespan.get()) {
            this.propagateUpperBounds();
        }
    }

    @Override
    public void addStaticPrecedence(TaskVar t1, TaskVar t2) {
        int i = t1.getID();
        int j = t2.getID();
        boolean initialWorld = this.getSolver().getEnvironment().getWorldIndex() == 0;
        switch (this.network.add(i, j)) {
            case 0: {
                break;
            }
            case 1: {
                if (initialWorld) {
                    this.initialContradiction = true;
                    break;
                }
                throw new SolverException("cant add static precedence which create a contradiction during search");
            }
            case 4: {
                if (initialWorld) {
                    System.err.println("duplicate precedence posting");
                    break;
                }
                throw new SolverException("cant add duplicate static precedence during search");
            }
            case 2: {
                if (initialWorld) {
                    System.err.println("transitive static precedence not added");
                    break;
                }
                throw new SolverException("cant add static transitive precedence during search");
            }
            default: {
                throw new SolverException("invalid precedence posting");
            }
        }
    }

    @Override
    public void firePrecedenceAdded(TaskVar t1, TaskVar t2) throws ContradictionException {
        int i = t1.getID();
        int j = t2.getID();
        switch (this.network.add(i, j)) {
            case 0: {
                this.precStack.store(i, j);
                break;
            }
            case 1: {
                this.fail();
                break;
            }
            case 4: {
                throw new SolverException("duplicate precedence posting");
            }
            case 2: {
                throw new SolverException("transitive precedence posting");
            }
            default: {
                throw new SolverException("invalid precedence posting");
            }
        }
    }

    @Override
    public boolean isConnected(TaskVar t1, TaskVar t2) {
        return this.network.isTransitive(t1.getID(), t2.getID());
    }

    @Override
    public boolean isOrdered(TaskVar t1, TaskVar t2) {
        int j;
        int i = t1.getID();
        return this.network.isTransitive(i, j = t2.getID()) || this.network.isTransitive(j, i);
    }

    @Override
    public String toDotty() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.taskvars.length; ++i) {
            if (this.network.isDisconnected(i)) continue;
            buffer.append(this.taskvars[i].toDotty()).append('\n');
        }
        buffer.append(this.network.toDotty());
        return new String(buffer);
    }

    final class PrecedenceStack
    implements IStateIntProcedure {
        protected int[] origin;
        protected int[] destination;
        protected IStateInt nbStoredPrec;

        public PrecedenceStack(IEnvironment env, int initialSize) {
            this.origin = new int[initialSize];
            this.destination = new int[initialSize];
            this.nbStoredPrec = env.makeIntProcedure(this, 0);
        }

        public void store(int i, int j) {
            int idx = this.nbStoredPrec.get();
            if (idx + 1 == this.origin.length) {
                this.resizeCapacity();
            }
            this.origin[idx] = i;
            this.destination[idx] = j;
            this.nbStoredPrec.add(1);
        }

        protected void resizeCapacity() {
            int c = this.origin.length * 3 / 2 + 1;
            int[] tmp = new int[c];
            System.arraycopy(this.origin, 0, tmp, 0, this.origin.length);
            this.origin = tmp;
            tmp = new int[c];
            System.arraycopy(this.destination, 0, tmp, 0, this.destination.length);
            this.destination = tmp;
        }

        @Override
        public void apply(int oldVal, int newVal) {
            for (int i = newVal; i < oldVal; ++i) {
                PertSConstraint.this.network.remove(this.origin[i], this.destination[i]);
            }
        }
    }
}

