/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.PertSConstraint;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.trailing.StoredBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntArrayList;
import java.util.BitSet;

public class IncrementalPertSConstraint
extends PertSConstraint {
    protected final StoredBitSet tasksToPropagateOnInf;
    protected final StoredBitSet tasksToPropagateOnSup;

    public IncrementalPertSConstraint(Solver solver, IntDomainVar uppBound) {
        super(solver, uppBound);
        IEnvironment env = solver.getEnvironment();
        this.tasksToPropagateOnInf = (StoredBitSet)env.makeBitSet(this.getNbTasks());
        this.tasksToPropagateOnSup = (StoredBitSet)env.makeBitSet(this.getNbTasks());
        this.propagationControlInf.set(false);
        this.propagationControlSup.set(false);
    }

    @Override
    public void awake() throws ContradictionException {
        super.awake();
        this.propagateLowerBounds();
        this.propagateUpperBounds();
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        if (varIdx < this.taskIntVarOffset) {
            int tidx = varIdx % this.getNbTasks();
            this.updateCompulsoryPart(tidx);
            this.tasksToPropagateOnInf.set(tidx);
            this.propagationControlInf.set(true);
            this.constAwake(false);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx < this.taskIntVarOffset) {
            int tidx = idx % this.getNbTasks();
            this.updateCompulsoryPart(tidx);
            this.propagationControlInf.set(true);
            this.tasksToPropagateOnInf.set(tidx);
            this.propagationControlSup.set(true);
            this.tasksToPropagateOnSup.set(tidx);
        } else {
            this.propagationControlMakespan.set(true);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        if (varIdx < this.taskIntVarOffset) {
            int tidx = varIdx % this.getNbTasks();
            this.updateCompulsoryPart(tidx);
            this.propagationControlSup.set(true);
            this.tasksToPropagateOnSup.set(tidx);
        } else {
            this.propagationControlMakespan.set(true);
        }
        this.constAwake(false);
    }

    public final void incrPropagateLowerBounds() throws ContradictionException {
        int[] order = this.network.getTopologicalOrder();
        int[] index = this.network.getTopologicalOrderIndex();
        BitSet subgraph = new BitSet(index.length);
        int i = this.tasksToPropagateOnInf.nextSetBit(0);
        while (i >= 0) {
            subgraph.set(index[i]);
            i = this.tasksToPropagateOnInf.nextSetBit(i + 1);
        }
        i = subgraph.nextSetBit(0);
        while (i >= 0) {
            int task = order[i];
            TIntArrayList succ = this.network.getSuccessors(task);
            for (int j = 0; j < succ.size(); ++j) {
                int dest = succ.get(j);
                boolean modified = this.taskvars[dest].start().updateInf(this.taskvars[task].getECT(), this.getCIndiceStart(dest));
                this.updateDuration(task, dest);
                if (!modified) continue;
                this.updateCompulsoryPart(dest);
                subgraph.set(index[dest]);
            }
            i = subgraph.nextSetBit(i + 1);
        }
        this.tasksToPropagateOnInf.clear();
        this.propagationControlInf.set(false);
    }

    public final void incrPropagateUpperBounds() throws ContradictionException {
        int[] order = this.network.getTopologicalOrder();
        int[] index = this.network.getTopologicalOrderIndex();
        BitSet subgraph = new BitSet(index.length);
        int n = this.getNbTasks();
        int i = this.tasksToPropagateOnSup.nextSetBit(0);
        while (i >= 0) {
            subgraph.set(n - 1 - index[i]);
            i = this.tasksToPropagateOnSup.nextSetBit(i + 1);
        }
        i = subgraph.nextSetBit(0);
        while (i >= 0) {
            int task = order[n - 1 - i];
            TIntArrayList pred = this.network.getPredecessors(task);
            for (int j = 0; j < pred.size(); ++j) {
                int orig = pred.get(j);
                boolean modified = this.taskvars[orig].start().updateSup(this.taskvars[task].getLST() - this.taskvars[orig].getMinDuration(), this.getCIndiceStart(orig));
                this.updateDuration(task, orig);
                if (!modified) continue;
                this.updateCompulsoryPart(orig);
                subgraph.set(n - 1 - index[orig]);
            }
            i = subgraph.nextSetBit(i + 1);
        }
        this.tasksToPropagateOnSup.clear();
        this.propagationControlSup.set(false);
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.propagationControlInf.get()) {
            this.incrPropagateLowerBounds();
        }
        if (this.propagationControlMakespan.get()) {
            this.propagateUpperBounds();
            this.tasksToPropagateOnSup.clear();
        }
        if (this.propagationControlSup.get()) {
            this.incrPropagateUpperBounds();
        }
    }
}

