/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.cp.solver.constraints.global.scheduling.ExtendedBitSet;
import choco.kernel.common.opres.ssp.BellmanWithLists;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;

public class ForbiddenIntervals
extends AbstractResourceSConstraint {
    private final ExtendedBitSet forbidden;
    private final int load;

    public ForbiddenIntervals(String name, TaskVar[] taskvars, IntDomainVar upperBound) {
        super(name, taskvars, upperBound, new IntDomainVar[0]);
        int[] p = new int[this.getNbTasks()];
        int l = 0;
        for (int i = 0; i < p.length; ++i) {
            IntDomainVar d = ((TaskVar)this.getTask(i)).duration();
            if (!d.isInstantiated()) {
                throw new SolverException("forbidden intervals are only available for resources with constant duration");
            }
            p[i] = d.getVal();
            l += p[i];
        }
        this.load = l;
        BellmanWithLists bell = new BellmanWithLists(p, this.load);
        bell.run();
        this.forbidden = new ExtendedBitSet(bell.getCoveredSet(), this.load);
    }

    private int getUB() {
        return this.vars[this.indexUB].getSup();
    }

    private final boolean checkHead(int head) {
        int before;
        int after;
        return !this.forbidden.get(head) && (after = this.load - (before = this.forbidden.prevSetBit(head))) + head > this.getUB();
    }

    private final void updateHead(int operation) throws ContradictionException {
        ITask t = this.getTask(operation);
        int head = ((TaskVar)t).getEST();
        if (this.checkHead(head)) {
            this.rtasks[operation].updateEST(this.forbidden.nextSetBit(head));
        }
        if (this.checkHead(head = ((TaskVar)t).getECT())) {
            this.rtasks[operation].updateECT(this.forbidden.nextSetBit(head));
        }
    }

    private int checkTail(int tail) {
        if (!this.forbidden.get(tail)) {
            int before = this.forbidden.prevSetBit(tail);
            int after = this.getUB() - (this.load - before);
            if (tail > after) {
                return after;
            }
        }
        return -1;
    }

    private final void updateTail(int operation) throws ContradictionException {
        ITask t = this.getTask(operation);
        int tail = ((TaskVar)t).getLST();
        int val = this.checkTail(tail);
        if (val >= 0) {
            this.rtasks[operation].updateLST(val);
        }
        if ((val = this.checkTail(tail = ((TaskVar)t).getLCT())) >= 0) {
            this.rtasks[operation].updateLCT(val);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx < this.getNbTasks()) {
            this.updateHead(idx);
        }
    }

    private void globalUpdate() throws ContradictionException {
        for (int o = 0; o < this.getNbTasks(); ++o) {
            this.updateHead(o);
            this.updateTail(o);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx < this.getNbTasks()) {
            this.updateHead(idx);
            this.updateTail(idx);
        } else if (idx == this.indexUB) {
            this.globalUpdate();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == this.indexUB) {
            this.globalUpdate();
        } else if (idx >= this.getNbTasks()) {
            this.updateTail(idx / 2);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
    }
}

