/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import java.util.BitSet;

class ExtendedBitSet {
    private final int capacity;
    private final BitSet original;
    private final BitSet symmetric;

    public ExtendedBitSet(BitSet original, int capacity) {
        this.capacity = capacity;
        this.original = original;
        this.symmetric = new BitSet(this.capacity + 1);
        int i = this.original.nextSetBit(0);
        while (i >= 0) {
            this.set(capacity - i);
            i = this.original.nextSetBit(i + 1);
        }
    }

    public final boolean get(int idx) {
        return this.original.get(idx);
    }

    public final void set(int idx) {
        if (this.capacity - idx >= 0) {
            this.original.set(idx);
            this.symmetric.set(this.capacity - idx);
        }
    }

    public int nextSetBit(int idx) {
        return this.original.nextSetBit(idx);
    }

    public int prevSetBit(int idx) {
        int sidx = this.capacity - idx;
        if (sidx < 0) {
            return this.original.length() - 1;
        }
        int n = this.symmetric.nextSetBit(sidx);
        return n < 0 ? n : this.capacity - n;
    }

    public String toString() {
        return this.original.toString();
    }
}

