/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.SettingType;
import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.cp.solver.constraints.global.scheduling.DisjRules;
import choco.cp.solver.constraints.global.scheduling.IDisjRules;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;

public class Disjunctive
extends AbstractResourceSConstraint {
    protected Rule single = Rule.NONE;
    protected IDisjRules rules;
    private boolean noFixPoint;

    protected Disjunctive(String name, TaskVar[] taskvars, IntDomainVar uppBound, IntDomainVar ... otherVars) {
        super(name, taskvars, uppBound, otherVars);
    }

    public Disjunctive(String name, TaskVar[] taskvars, IntDomainVar makespan) {
        super(name, taskvars, makespan, new IntDomainVar[0]);
        this.rules = new DisjRules(this.rtasks);
    }

    public final void setSingleRule(Rule rule) {
        this.flags.unset(SettingType.DEFAULT_FILTERING, SettingType.VILIM_FILTERING);
        this.flags.set(SettingType.SINGLE_RULE_FILTERING);
        this.single = rule;
    }

    public final void noSingleRule() {
        this.single = Rule.NONE;
    }

    protected final boolean applySingleRule() throws ContradictionException {
        switch (this.single) {
            case NOT_FIRST: {
                return this.rules.notFirst();
            }
            case NOT_LAST: {
                return this.rules.notLast();
            }
            case DP_EST: {
                return this.rules.detectablePrecedenceEST();
            }
            case DP_LCT: {
                return this.rules.detectablePrecedenceLCT();
            }
            case EF_EST: {
                return this.rules.edgeFindingEST();
            }
            case EF_LCT: {
                return this.rules.edgeFindingLCT();
            }
        }
        throw new IllegalArgumentException("no rule activated in Disjunctive constraint");
    }

    protected void singleRuleFiltering() throws ContradictionException {
        do {
            this.rules.fireDomainChanged();
            this.noFixPoint = this.applySingleRule();
            this.updateMakespan(this.rules.getMakespanLB());
        } while (this.noFixPoint);
    }

    protected boolean hasOverloadChecking() {
        return !this.flags.contains(SettingType.EDGE_FINDING_D) && this.flags.contains(SettingType.OVERLOAD_CHECKING);
    }

    protected final void defaultFiltering() throws ContradictionException {
        do {
            this.noFixPoint = false;
            this.rules.fireDomainChanged();
            if (this.flags.contains(SettingType.EDGE_FINDING_D)) {
                this.noFixPoint |= this.rules.edgeFinding();
            }
            if (this.flags.contains(SettingType.NF_NL)) {
                this.noFixPoint |= this.rules.notLast();
                if (this.flags.contains(SettingType.DETECTABLE_PRECEDENCE)) {
                    this.noFixPoint |= this.rules.detectablePrecedenceEST();
                    this.noFixPoint |= this.rules.notFirst();
                    this.noFixPoint |= this.rules.detectablePrecedenceLCT();
                } else {
                    this.noFixPoint |= this.rules.notFirst();
                }
            } else if (this.flags.contains(SettingType.DETECTABLE_PRECEDENCE)) {
                this.noFixPoint |= this.rules.detectablePrecedenceEST();
                this.noFixPoint |= this.rules.detectablePrecedenceLCT();
            }
            if (this.hasOverloadChecking() && this.rules.overloadChecking()) {
                this.fail();
            }
            this.updateMakespan(this.rules.getMakespanLB());
        } while (this.noFixPoint);
    }

    protected final void vilimFiltering() throws ContradictionException {
        boolean noGlobalFixPoint;
        do {
            noGlobalFixPoint = false;
            if (this.flags.contains(SettingType.EDGE_FINDING_D)) {
                do {
                    this.rules.fireDomainChanged();
                    this.noFixPoint = this.rules.edgeFinding();
                    this.updateMakespan(this.rules.getMakespanLB());
                } while (this.noFixPoint);
            }
            if (this.hasOverloadChecking() && this.rules.overloadChecking()) {
                this.fail();
            }
            if (this.flags.contains(SettingType.NF_NL)) {
                do {
                    this.rules.fireDomainChanged();
                    this.noFixPoint = this.rules.notFirstNotLast();
                    this.updateMakespan(this.rules.getMakespanLB());
                    noGlobalFixPoint |= this.noFixPoint;
                } while (this.noFixPoint);
            }
            if (!this.flags.contains(SettingType.DETECTABLE_PRECEDENCE)) continue;
            do {
                this.rules.fireDomainChanged();
                this.noFixPoint = this.rules.detectablePrecedence();
                this.updateMakespan(this.rules.getMakespanLB());
                noGlobalFixPoint |= this.noFixPoint;
            } while (this.noFixPoint);
        } while (noGlobalFixPoint);
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.rules.isActive()) {
            if (this.flags.contains(SettingType.DEFAULT_FILTERING)) {
                this.defaultFiltering();
            } else if (this.flags.contains(SettingType.VILIM_FILTERING)) {
                this.vilimFiltering();
            } else if (this.flags.contains(SettingType.SINGLE_RULE_FILTERING)) {
                this.singleRuleFiltering();
            } else {
                throw new SolverException("No filtering algorithm ?");
            }
        }
    }

    public static enum Rule {
        NONE,
        NOT_FIRST,
        NOT_LAST,
        DP_EST,
        DP_LCT,
        EF_EST,
        EF_LCT;

    }
}

