/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractDisjRules;
import choco.cp.solver.constraints.global.scheduling.BipartiteQueue;
import choco.cp.solver.constraints.global.scheduling.IBipartiteQueue;
import choco.cp.solver.constraints.global.scheduling.trees.DisjTreeT;
import choco.cp.solver.constraints.global.scheduling.trees.DisjTreeTL;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaLambdaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.common.util.TaskComparators;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.Comparator;

public final class DisjRules
extends AbstractDisjRules {
    protected final IBipartiteQueue<IRTask> rqueue;
    protected final IBipartiteQueue<ITask> queue;
    protected final IThetaTree disjTreeT;
    protected final IThetaLambdaTree disjTreeTL;

    public DisjRules(IRTask[] rtasks) {
        super(rtasks);
        ITask[] tasks = this.getTaskArray();
        this.rqueue = new BipartiteQueue<IRTask>(rtasks);
        this.queue = new BipartiteQueue<ITask>(tasks);
        this.disjTreeT = new DisjTreeT(Arrays.asList(tasks));
        this.disjTreeTL = new DisjTreeTL(Arrays.asList(tasks));
    }

    @Override
    public final boolean isActive() {
        return true;
    }

    @Override
    public void remove(IRTask rtask) {
        throw new UnsupportedOperationException("The resource is not alternative");
    }

    private void setupListsAndTreeT(Comparator<IRTask> taskComp, Comparator<ITask> queueComp, IVilimTree.TreeMode mode) {
        this.clear();
        this.queue.reset();
        Arrays.sort(this.rtasks, taskComp);
        this.queue.sort(queueComp);
        this.setup(this.disjTreeT, mode);
    }

    @Override
    public boolean overloadChecking() {
        Arrays.sort(this.rtasks, TaskComparators.makeRLatestCompletionTimeCmp());
        this.setup(this.disjTreeT, IVilimTree.TreeMode.ECT);
        for (IRTask t : this.rtasks) {
            TaskVar i = t.getTaskVar();
            this.disjTreeT.insertInTheta(i);
            if (this.disjTreeT.getTime() <= i.getLCT()) continue;
            return true;
        }
        this.setMakespanLB(this.disjTreeT);
        return false;
    }

    @Override
    public boolean notFirst() throws ContradictionException {
        this.setupListsAndTreeT(TaskComparators.makeReverseREarliestCompletionTimeCmp(), TaskComparators.makeReverseEarliestCompletionTimeCmp(), IVilimTree.TreeMode.LST);
        ITask j = null;
        for (IRTask rti : this.rtasks) {
            TaskVar i = rti.getTaskVar();
            while (!this.queue.isEmpty() && i.getEST() < this.queue.peek().getECT()) {
                j = this.queue.poll();
                this.disjTreeT.insertInTheta(j);
            }
            boolean rm = this.disjTreeT.removeFromTheta(i);
            if (this.disjTreeT.getTime() < i.getECT()) {
                this.addUpdate(rti, j.getECT());
            }
            if (!rm) continue;
            this.disjTreeT.insertInTheta(i);
        }
        return this.updateEST();
    }

    @Override
    public boolean notLast() throws ContradictionException {
        this.setupListsAndTreeT(TaskComparators.makeRLatestCompletionTimeCmp(), TaskComparators.makeLatestStartingTimeCmp(), IVilimTree.TreeMode.ECT);
        ITask j = null;
        for (IRTask rti : this.rtasks) {
            TaskVar i = rti.getTaskVar();
            while (!this.queue.isEmpty() && i.getLCT() > this.queue.peek().getLST()) {
                j = this.queue.poll();
                this.disjTreeT.insertInTheta(j);
            }
            this.disjTreeT.removeFromTheta(i);
            if (this.disjTreeT.getTime() > i.getLST()) {
                this.addUpdate(rti, j.getLST());
            }
            this.disjTreeT.insertInTheta(i);
        }
        this.setMakespanLB(this.disjTreeT);
        return this.updateLCT();
    }

    @Override
    public boolean detectablePrecedenceEST() throws ContradictionException {
        this.setupListsAndTreeT(TaskComparators.makeREarliestCompletionTimeCmp(), TaskComparators.makeLatestStartingTimeCmp(), IVilimTree.TreeMode.ECT);
        for (IRTask rti : this.rtasks) {
            TaskVar i = rti.getTaskVar();
            while (!this.queue.isEmpty() && i.getECT() > this.queue.peek().getLST()) {
                this.disjTreeT.insertInTheta(this.queue.poll());
            }
            boolean rm = this.disjTreeT.removeFromTheta(i);
            this.addUpdate(rti, this.disjTreeT.getTime());
            if (!rm) continue;
            this.disjTreeT.insertInTheta(i);
        }
        this.setMakespanLB(this.disjTreeT);
        return this.updateEST();
    }

    @Override
    public boolean detectablePrecedenceLCT() throws ContradictionException {
        this.setupListsAndTreeT(TaskComparators.makeReverseRLatestCompletionTimeCmp(), TaskComparators.makeReverseEarliestCompletionTimeCmp(), IVilimTree.TreeMode.LST);
        for (IRTask rti : this.rtasks) {
            TaskVar i = rti.getTaskVar();
            while (!this.queue.isEmpty() && i.getLCT() <= this.queue.peek().getECT()) {
                this.disjTreeT.insertInTheta(this.queue.poll());
            }
            boolean rm = this.disjTreeT.removeFromTheta(i);
            this.addUpdate(rti, this.disjTreeT.getTime());
            if (!rm) continue;
            this.disjTreeT.insertInTheta(i);
        }
        return this.updateLCT();
    }

    @Override
    public boolean edgeFindingEST() throws ContradictionException {
        this.clear();
        this.rqueue.reset();
        this.disjTreeTL.setMode(IVilimTree.TreeMode.ECT);
        return this.edgeFindingEST(this.disjTreeTL, this.rqueue);
    }

    @Override
    public boolean edgeFindingLCT() throws ContradictionException {
        this.clear();
        this.rqueue.reset();
        this.disjTreeTL.setMode(IVilimTree.TreeMode.LST);
        return this.edgeFindingLCT(this.disjTreeTL, this.rqueue);
    }
}

