/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.SettingType;
import choco.cp.solver.constraints.global.scheduling.AbstractCumulativeSConstraint;
import choco.cp.solver.constraints.global.scheduling.CumulRules;
import choco.cp.solver.constraints.global.scheduling.CumulSweep;
import choco.cp.solver.constraints.global.scheduling.ICumulRules;
import choco.cp.solver.constraints.global.scheduling.ICumulSweep;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.logging.Level;

public class Cumulative
extends AbstractCumulativeSConstraint {
    protected ICumulSweep cumulSweep;
    protected ICumulRules cumulRules;
    protected boolean noFixPoint;

    protected Cumulative(String name, TaskVar[] taskvars, IntDomainVar[] heights, IntDomainVar consumption, IntDomainVar capacity, IntDomainVar uppBound, IntDomainVar ... otherVars) {
        super(name, taskvars, heights, consumption, capacity, uppBound, otherVars);
    }

    public Cumulative(String name, TaskVar[] taskvars, IntDomainVar[] heights, IntDomainVar consumption, IntDomainVar capacity, IntDomainVar uppBound) {
        super(name, taskvars, heights, consumption, capacity, uppBound, new IntDomainVar[0]);
        this.cumulSweep = new CumulSweep(this, Arrays.asList(this.rtasks));
        this.cumulRules = new CumulRules(this);
    }

    public final ICumulSweep getSweep() {
        return this.cumulSweep;
    }

    public final ICumulRules getRules() {
        return this.cumulRules;
    }

    @Override
    protected final int getHeightIndex(int taskIdx) {
        return this.getTaskIntVarOffset() + taskIdx;
    }

    protected void checkRulesRequirement() {
        if (!this.hasOnlyPosisiveHeights()) {
            throw new SolverException("Task interval and Edge Finding for producer/consumer cumulative resource is not supported.");
        }
    }

    public final void filter() throws ContradictionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("========= Filtering on resource" + this + "========");
            logger.fine("Initial state for resource ");
            logger.fine(this.toString());
        }
        this.noFixPoint = true;
        boolean hasTaskInterval = this.flags.or(SettingType.TASK_INTERVAL, SettingType.VHM_CEF_ALGO_N2K, SettingType.VILIM_CEF_ALGO, SettingType.TASK_INTERVAL_SLOW);
        boolean hasEdgeFinding = this.flags.or(SettingType.VHM_CEF_ALGO_N2K, SettingType.VILIM_CEF_ALGO);
        if (hasTaskInterval) {
            this.checkRulesRequirement();
        }
        while (this.noFixPoint) {
            this.noFixPoint = false;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("------ Start sweep for resource" + this + "========");
            }
            this.noFixPoint |= this.cumulSweep.sweep();
            if (!hasTaskInterval) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("------ Energetic for resource" + this + "========");
            }
            this.cumulRules.initializeEdgeFindingStart();
            if (this.flags.contains(SettingType.TASK_INTERVAL_SLOW)) {
                this.cumulRules.slowTaskIntervals();
            } else {
                this.cumulRules.taskIntervals();
            }
            if (!hasEdgeFinding) continue;
            if (this.isInstantiatedHeights()) {
                this.cumulRules.reinitConsumption();
            } else {
                this.cumulRules.initializeEdgeFindingData();
            }
            if (this.flags.contains(SettingType.VILIM_CEF_ALGO)) {
                this.noFixPoint |= this.cumulRules.vilimStartEF();
            } else if (this.flags.contains(SettingType.VHM_CEF_ALGO_N2K)) {
                this.noFixPoint |= this.cumulRules.calcEF_start();
            }
            this.cumulRules.reinitConsumption();
            this.cumulRules.initializeEdgeFindingEnd();
            if (this.flags.contains(SettingType.VILIM_CEF_ALGO)) {
                this.noFixPoint |= this.cumulRules.vilimEndEF();
            } else if (this.flags.contains(SettingType.VHM_CEF_ALGO_N2K)) {
                this.noFixPoint |= this.cumulRules.calcEF_end();
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("------ Energetic  filtering done" + this + " =========");
        }
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.flags.or(SettingType.VHM_CEF_ALGO_N2K, SettingType.VILIM_CEF_ALGO) && this.isInstantiatedHeights() && this.hasOnlyPosisiveHeights()) {
            this.checkRulesRequirement();
            this.cumulRules.initializeEdgeFindingData();
        }
        super.awake();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public boolean isSatisfied() {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        for (IRTask crt : this.rtasks) {
            if (!crt.isRegular()) continue;
            TaskVar taskVar = crt.getTaskVar();
            start = Math.min(start, taskVar.start().getVal());
            end = Math.max(end, taskVar.end().getVal());
        }
        int[] load = new int[end - start];
        for (IRTask iRTask : this.rtasks) {
            if (!iRTask.isRegular()) continue;
            for (int i = iRTask.getTaskVar().start().getVal(); i < iRTask.getTaskVar().end().getVal(); ++i) {
                int n = i - start;
                load[n] = load[n] + iRTask.getHeight().getVal();
            }
        }
        for (int i = 0; i < load.length; ++i) {
            if (load[i] <= this.getMaxCapacity()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on choco.global.scheduling.Cumulative");
    }
}

