/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractCumulativeSConstraint;
import choco.cp.solver.constraints.global.scheduling.ICumulSweep;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CumulSweep
implements ICumulSweep {
    public final AbstractCumulativeSConstraint rsc;
    protected final List<IRTask> tasks;
    private final List<IRTask> taskToPrune = new LinkedList<IRTask>();
    private final LinkedList<Event> events = new LinkedList();
    private final Comparator<Event> evtComp = new EventComparator();
    private final int[] capaContributions;
    private int capaSumHeight;
    private final int[] consContributions;
    private int consSumHeight;
    int nbTasks = 0;
    private final EventTaskStructure[] task_evts;
    private boolean noFixPoint;

    public CumulSweep(AbstractCumulativeSConstraint rsc, List<IRTask> tasks) {
        this.rsc = rsc;
        this.tasks = tasks;
        this.capaContributions = new int[rsc.getNbTasks()];
        this.consContributions = new int[rsc.getNbTasks()];
        this.task_evts = new EventTaskStructure[rsc.getNbTasks()];
        for (int i = 0; i < rsc.getNbTasks(); ++i) {
            this.task_evts[i] = new EventTaskStructure(rsc.getRTask(i));
        }
    }

    private final boolean overlapForSure(TaskVar t, int low, int up) {
        return t.getECT() > low && t.getLST() <= up && t.getMinDuration() > 0;
    }

    public boolean generateEvents() {
        this.events.clear();
        boolean someprof = false;
        for (IRTask rtask : this.tasks) {
            int consInc;
            int capaInc;
            int i = rtask.getTaskIndex();
            TaskVar task = rtask.getTaskVar();
            if (rtask.isRegular() && task.hasCompulsoryPart()) {
                if (rtask.getMaxHeight() < Math.max(0, this.rsc.getMaxConsumption())) {
                    this.task_evts[i].setCheckEvts(this.events, task);
                }
                capaInc = Math.max(0, rtask.getMinHeight());
                consInc = Math.min(0, rtask.getMaxHeight());
                if (capaInc != 0 || consInc != 0) {
                    this.task_evts[i].setCompProfEvts(this.events, task, capaInc, consInc);
                    someprof = true;
                }
            }
            if (!rtask.isEliminated()) {
                capaInc = Math.min(0, rtask.getMinHeight());
                consInc = Math.max(0, rtask.getMaxHeight());
                if (capaInc != 0 || consInc != 0) {
                    this.task_evts[i].setDomProfEvts(this.events, task, capaInc, consInc);
                    someprof = true;
                }
            }
            if (task.isScheduled() && !rtask.isOptional() && rtask.getHeight().isInstantiated()) continue;
            this.task_evts[i].setPruningEvt(this.events, task);
        }
        return someprof;
    }

    protected final void checkConsAndCapa() throws ContradictionException {
        if (this.capaSumHeight > this.rsc.getMaxCapacity() || this.nbTasks > 0 && this.consSumHeight < this.rsc.getMinConsumption()) {
            this.rsc.fail();
        }
        this.rsc.updateMinCapacity(this.capaSumHeight);
        if (this.nbTasks > 0) {
            this.rsc.updateMaxConsumption(this.consSumHeight);
        }
    }

    protected final void initializeSweep() {
        this.taskToPrune.clear();
        Collections.sort(this.events, this.evtComp);
        Arrays.fill(this.capaContributions, 0);
        Arrays.fill(this.consContributions, 0);
        this.nbTasks = 0;
        this.capaSumHeight = 0;
        this.consSumHeight = 0;
    }

    @Override
    public boolean sweep() throws ContradictionException {
        this.noFixPoint = false;
        if (this.generateEvents()) {
            this.initializeSweep();
            int d = this.events.getFirst().getDate();
            ListIterator it = this.events.listIterator();
            while (it.hasNext()) {
                Event evt = (Event)it.next();
                if (evt.type == 2) {
                    this.taskToPrune.add(evt.task);
                    continue;
                }
                if (d != evt.date) {
                    this.checkConsAndCapa();
                    this.prune(d, evt.date - 1);
                    d = evt.date;
                }
                if (evt.type == 0) {
                    this.nbTasks += evt.capaProfIncrement;
                    continue;
                }
                if (evt.type == 1) {
                    this.capaSumHeight += evt.capaProfIncrement;
                    int n = evt.task.getTaskIndex();
                    this.capaContributions[n] = this.capaContributions[n] + evt.capaProfIncrement;
                    this.consSumHeight += evt.consProfIncrement;
                    int n2 = evt.task.getTaskIndex();
                    this.consContributions[n2] = this.consContributions[n2] + evt.consProfIncrement;
                    continue;
                }
                throw new IllegalArgumentException(evt.type + " should not be used");
            }
            this.checkConsAndCapa();
            this.prune(d, d);
        }
        return this.noFixPoint;
    }

    protected boolean pruneRequired(IRTask rtask, int low, int up) throws ContradictionException {
        int idx = rtask.getTaskIndex();
        boolean modified = false;
        if (this.nbTasks > 0 && this.consSumHeight - this.consContributions[idx] < this.rsc.getMinConsumption() || this.capaSumHeight - this.capaContributions[idx] > this.rsc.getMaxCapacity()) {
            rtask.assign();
            TaskVar t = rtask.getTaskVar();
            modified |= t.start().updateInf(up - t.getMaxDuration() + 1, this.rsc.getCIndiceStart(idx));
            modified |= t.start().updateSup(low, this.rsc.getCIndiceStart(idx));
            modified |= t.end().updateSup(low + t.getMaxDuration(), this.rsc.getCIndiceEnd(idx));
            modified |= t.end().updateInf(up + 1, this.rsc.getCIndiceEnd(idx));
            modified |= t.duration().updateInf(Math.min(up - t.start().getSup() + 1, t.end().getInf() - low), this.rsc.getCIndiceEnd(idx));
        }
        return modified;
    }

    protected final boolean pruneForbidden(IRTask rtask, int low, int up) throws ContradictionException {
        int idx = rtask.getTaskIndex();
        boolean modified = false;
        if (this.capaSumHeight - this.capaContributions[idx] + rtask.getMinHeight() > this.rsc.getMaxCapacity() || this.consSumHeight - this.consContributions[idx] + rtask.getMaxHeight() < this.rsc.getMinConsumption()) {
            TaskVar t = rtask.getTaskVar();
            if (this.overlapForSure(t, low, up)) {
                rtask.remove();
            } else if (rtask.isRegular() && t.getMinDuration() > 0) {
                modified |= t.start().removeInterval(low - t.getMinDuration() + 1, up, this.rsc.getCIndiceStart(idx));
                modified |= t.end().removeInterval(low + 1, up + t.getMinDuration(), this.rsc.getCIndiceEnd(idx));
                int maxd = Math.max(Math.max(low - t.getEST(), 0), t.getLCT() - up - 1);
                if (modified |= rtask.updateMaxDuration(maxd)) {
                    this.rsc.updateCompulsoryPart(idx);
                }
            }
        }
        return modified;
    }

    protected boolean pruneHeight(IRTask rtask, int low, int up) throws ContradictionException {
        boolean modified = false;
        TaskVar t = rtask.getTaskVar();
        if (rtask.isRegular() && this.overlapForSure(t, low, up)) {
            int idx = rtask.getTaskIndex();
            modified |= rtask.updateMaxHeight(this.rsc.getMaxCapacity() - (this.capaSumHeight - this.capaContributions[idx]));
            modified |= rtask.updateMinHeight(this.rsc.getMinConsumption() - (this.consSumHeight - this.consContributions[idx]));
        }
        return modified;
    }

    protected void prune(int low, int up) throws ContradictionException {
        ListIterator<IRTask> it = this.taskToPrune.listIterator();
        while (it.hasNext()) {
            IRTask crt = it.next();
            this.noFixPoint |= this.pruneForbidden(crt, low, up);
            this.noFixPoint |= this.pruneRequired(crt, low, up);
            this.noFixPoint |= this.pruneHeight(crt, low, up);
            if (crt.getTaskVar().getLCT() > up + 1) continue;
            it.remove();
        }
    }

    protected static class EventComparator
    implements Comparator<Event> {
        protected EventComparator() {
        }

        @Override
        public int compare(Event o1, Event o2) {
            int date2;
            int date1 = o1.getDate();
            if (date1 < (date2 = o2.getDate())) {
                return -1;
            }
            if (date1 == date2) {
                return 0;
            }
            return 1;
        }
    }

    protected static final class Event {
        public static final int CHECK = 0;
        public static final int PROFILE = 1;
        public static final int PRUNING = 2;
        public int type;
        public IRTask task;
        public int date;
        public int capaProfIncrement;
        public int consProfIncrement;

        public Event(int type, IRTask task, int capaProfIncrement, int consProfIncrement) {
            this.type = type;
            this.task = task;
            this.date = -1;
            this.capaProfIncrement = capaProfIncrement;
            this.consProfIncrement = consProfIncrement;
        }

        public Event(int type, IRTask task) {
            this(type, task, -1, -1);
        }

        public void set(int date, int capaInc, int consInc) {
            this.date = date;
            this.capaProfIncrement = capaInc;
            this.consProfIncrement = consInc;
        }

        public String toString() {
            String typ;
            switch (this.type) {
                case 0: {
                    typ = "CHECK  ";
                    break;
                }
                case 1: {
                    typ = "PROFILE";
                    break;
                }
                case 2: {
                    typ = "PRUNING";
                    break;
                }
                case 3: {
                    typ = "CHECK-PROFILE";
                    break;
                }
                default: {
                    typ = "";
                }
            }
            return "[" + typ + ", " + this.task + ", d=" + this.date + ", capaInc=" + this.capaProfIncrement + ", consInc=" + this.consProfIncrement + "]";
        }

        public int getType() {
            return this.type;
        }

        public IRTask getTask() {
            return this.task;
        }

        public int getDate() {
            return this.date;
        }

        public final int getCapaProfIncrement() {
            return this.capaProfIncrement;
        }
    }

    protected class EventTaskStructure {
        protected final Event checkEvtS;
        protected final Event checkEvtE;
        protected final Event compProfEvtS;
        protected final Event compProfEvtE;
        protected final Event domProfEvtS;
        protected final Event domProfEvtE;
        protected final Event pruneEvt;

        public EventTaskStructure(IRTask t) {
            this.checkEvtS = new Event(0, t, 1, 1);
            this.checkEvtE = new Event(0, t, -1, -1);
            this.compProfEvtS = new Event(1, t);
            this.compProfEvtE = new Event(1, t);
            this.domProfEvtS = new Event(1, t);
            this.domProfEvtE = new Event(1, t);
            this.pruneEvt = new Event(2, t, 0, 0);
        }

        public void setPruningEvt(List<Event> events, TaskVar t) {
            this.pruneEvt.date = t.getEST();
            events.add(this.pruneEvt);
        }

        public void setCheckEvts(List<Event> events, TaskVar t) {
            this.checkEvtS.date = t.getLST();
            this.checkEvtE.date = t.getECT();
            events.add(this.checkEvtS);
            events.add(this.checkEvtE);
        }

        public void setCompProfEvts(List<Event> events, TaskVar t, int capaInc, int consInc) {
            this.compProfEvtS.set(t.getLST(), capaInc, consInc);
            this.compProfEvtE.set(t.getECT(), -capaInc, -consInc);
            events.add(this.compProfEvtS);
            events.add(this.compProfEvtE);
        }

        public void setDomProfEvts(List<Event> events, TaskVar t, int capaInc, int consInc) {
            this.domProfEvtS.set(t.getEST(), capaInc, consInc);
            this.domProfEvtE.set(t.getLCT(), -capaInc, -consInc);
            events.add(this.domProfEvtS);
            events.add(this.domProfEvtE);
        }
    }
}

