/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.IBipartiteQueue;
import java.util.Arrays;
import java.util.Comparator;

final class BipartiteQueue<E>
implements IBipartiteQueue<E> {
    private final E[] elementData;
    private int level;

    public BipartiteQueue(E[] elementData) {
        this.elementData = Arrays.copyOf(elementData, elementData.length);
        this.reset();
    }

    @Override
    public void reset() {
        this.level = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.level == this.elementData.length;
    }

    @Override
    public E poll() {
        return this.elementData[this.level++];
    }

    @Override
    public E peek() {
        return this.elementData[this.level];
    }

    @Override
    public void sort(Comparator<? super E> cmp) {
        Arrays.sort(this.elementData, this.level, this.elementData.length, cmp);
    }
}

