/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.scheduling.AbstractDisjRules;
import choco.cp.solver.constraints.global.scheduling.IBipartiteQueue;
import choco.cp.solver.constraints.global.scheduling.trees.AltDisjTreeTL;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.common.util.TaskComparators;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntProcedure;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public final class AltDisjRules
extends AbstractDisjRules
implements Iterable<IRTask>,
IStateIntProcedure {
    private final IStateInt size;
    private final List<IRTask> removals = new LinkedList<IRTask>();
    private AltBipartiteQueue<IRTask> rqueue;
    protected AltDisjTreeTL altDisjTreeTL;

    public AltDisjRules(IEnvironment env, IRTask[] rtasks) {
        super(rtasks);
        this.size = env.makeIntProcedure(this, rtasks.length);
        this.rqueue = new AltBipartiteQueue<IRTask>(rtasks);
        this.altDisjTreeTL = new AltDisjTreeTL(Arrays.asList(this.getTaskArray()));
    }

    @Override
    public void apply(int oldVal, int newVal) {
        for (int i = oldVal; i < newVal; ++i) {
            this.altDisjTreeTL.insert(this.rtasks[i].getTaskVar());
        }
    }

    protected void applyRemovals() throws ContradictionException {
        for (IRTask t : this.removals) {
            t.remove();
            this.remove(t);
        }
    }

    private void setupListsAndTreeTL(Comparator<IRTask> taskComp, Comparator<IRTask> queueComp, IVilimTree.TreeMode mode) {
        this.clear();
        Arrays.sort(this.rtasks, 0, this.size.get(), taskComp);
        this.rqueue.sort(queueComp);
        this.setup(this.altDisjTreeTL, mode);
    }

    @Override
    protected void clear() {
        super.clear();
        this.removals.clear();
        this.rqueue.reset();
    }

    @Override
    public boolean isActive() {
        return this.size.get() > 0;
    }

    private void makeRemovalSwap(IRTask[] rtasks, IRTask rtask) {
        int index = -1;
        for (int i = 0; i < this.size.get(); ++i) {
            if (rtasks[i] != rtask) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new NoSuchElementException("cant remove element.");
        }
        int newIndex = this.size.get() - 1;
        IRTask tmp = rtasks[index];
        rtasks[index] = rtasks[newIndex];
        rtasks[newIndex] = tmp;
    }

    private void insertInTree(IRTask rtask) {
        if (rtask.isOptional()) {
            this.altDisjTreeTL.insertInLambda(rtask);
        } else if (rtask.isRegular()) {
            this.altDisjTreeTL.insertInTheta(rtask);
        }
    }

    private void setAsRemoval() {
        IRTask j = (IRTask)this.altDisjTreeTL.getResponsibleTask();
        this.removals.add(j);
        this.altDisjTreeTL.removeFromLambda(j.getTaskVar());
    }

    @Override
    public void remove(IRTask rtask) {
        this.makeRemovalSwap(this.rtasks, rtask);
        this.makeRemovalSwap((IRTask[])this.rqueue.elementData, rtask);
        this.altDisjTreeTL.remove(rtask.getTaskVar());
        this.size.add(-1);
    }

    @Override
    public boolean detectablePrecedenceEST() throws ContradictionException {
        this.setupListsAndTreeTL(TaskComparators.makeREarliestCompletionTimeCmp(), TaskComparators.makeRLatestStartingTimeCmp(), IVilimTree.TreeMode.ECT);
        for (IRTask rti : this) {
            TaskVar i = rti.getTaskVar();
            while (!this.rqueue.isEmpty() && i.getECT() > this.rqueue.peek().getTaskVar().getLST()) {
                this.insertInTree(this.rqueue.poll());
            }
            if (!rti.isRegular()) continue;
            boolean rm = this.altDisjTreeTL.removeFromTheta(i);
            this.addUpdate(rti, this.altDisjTreeTL.getTime());
            if (this.altDisjTreeTL.getTime() > i.getLST()) {
                rti.fail();
            }
            while (this.altDisjTreeTL.getGrayTime() > i.getLST()) {
                this.setAsRemoval();
            }
            if (!rm) continue;
            this.altDisjTreeTL.insertInTheta(i);
        }
        this.setMakespanLB(this.altDisjTreeTL);
        this.applyRemovals();
        return this.updateEST();
    }

    @Override
    public boolean detectablePrecedenceLCT() throws ContradictionException {
        CPSolver.flushLogs();
        this.setupListsAndTreeTL(TaskComparators.makeReverseRLatestCompletionTimeCmp(), TaskComparators.makeReverseREarliestCompletionTimeCmp(), IVilimTree.TreeMode.LST);
        for (IRTask rti : this) {
            TaskVar i = rti.getTaskVar();
            while (!this.rqueue.isEmpty() && i.getLCT() <= this.rqueue.peek().getTaskVar().getECT()) {
                this.insertInTree(this.rqueue.poll());
            }
            if (!rti.isRegular()) continue;
            boolean rm = this.altDisjTreeTL.removeFromTheta(i);
            this.addUpdate(rti, this.altDisjTreeTL.getTime());
            if (this.altDisjTreeTL.getTime() < i.getECT()) {
                rti.fail();
            }
            while (this.altDisjTreeTL.getGrayTime() < i.getECT()) {
                this.setAsRemoval();
            }
            if (!rm) continue;
            this.altDisjTreeTL.insertInTheta(i);
        }
        this.applyRemovals();
        return this.updateLCT();
    }

    @Override
    public boolean edgeFindingEST() throws ContradictionException {
        this.clear();
        this.altDisjTreeTL.initializeEdgeFinding(IVilimTree.TreeMode.ECT, this);
        return this.edgeFindingEST(this.altDisjTreeTL, this.rqueue);
    }

    @Override
    public boolean edgeFindingLCT() throws ContradictionException {
        this.clear();
        this.altDisjTreeTL.initializeEdgeFinding(IVilimTree.TreeMode.LST, this);
        return this.edgeFindingLCT(this.altDisjTreeTL, this.rqueue);
    }

    @Override
    public boolean notFirst() throws ContradictionException {
        this.setupListsAndTreeTL(TaskComparators.makeReverseREarliestCompletionTimeCmp(), TaskComparators.makeReverseREarliestCompletionTimeCmp(), IVilimTree.TreeMode.LST);
        ITask j = null;
        TaskVar ja = null;
        for (IRTask rti : this) {
            TaskVar i = rti.getTaskVar();
            while (!this.rqueue.isEmpty() && i.getEST() < this.rqueue.peek().getTaskVar().getECT()) {
                IRTask tmp = this.rqueue.poll();
                ja = tmp.getTaskVar();
                if (tmp.isRegular()) {
                    j = ja;
                }
                this.insertInTree(tmp);
            }
            if (!rti.isRegular()) continue;
            boolean rm = this.altDisjTreeTL.removeFromTheta(i);
            if (this.altDisjTreeTL.getTime() < i.getECT()) {
                this.addUpdate(rti, j.getECT());
                if (i.getLST() < j.getECT()) {
                    rti.fail();
                }
                if (i.getLST() < ja.getECT()) {
                    while (this.altDisjTreeTL.getGrayTime() > i.getECT()) {
                        this.setAsRemoval();
                    }
                }
            }
            if (!rm) continue;
            this.altDisjTreeTL.insertInTheta(i);
        }
        this.applyRemovals();
        return this.updateEST();
    }

    @Override
    public boolean notLast() throws ContradictionException {
        this.setupListsAndTreeTL(TaskComparators.makeRLatestCompletionTimeCmp(), TaskComparators.makeRLatestStartingTimeCmp(), IVilimTree.TreeMode.ECT);
        ITask j = null;
        TaskVar ja = null;
        for (IRTask rti : this) {
            TaskVar i = rti.getTaskVar();
            while (!this.rqueue.isEmpty() && i.getLCT() > this.rqueue.peek().getTaskVar().getLST()) {
                IRTask tmp = this.rqueue.poll();
                ja = tmp.getTaskVar();
                if (tmp.isRegular()) {
                    j = ja;
                }
                this.insertInTree(tmp);
            }
            if (!rti.isRegular()) continue;
            this.altDisjTreeTL.removeFromTheta(i);
            if (this.altDisjTreeTL.getTime() > i.getLST()) {
                this.addUpdate(rti, j.getLST());
                if (j.getLST() < i.getECT()) {
                    rti.fail();
                }
                if (ja.getLST() < i.getECT()) {
                    while (this.altDisjTreeTL.getGrayTime() > i.getLST()) {
                        this.setAsRemoval();
                    }
                }
            }
            this.altDisjTreeTL.insertInTheta(i);
        }
        this.setMakespanLB(this.altDisjTreeTL);
        this.applyRemovals();
        return this.updateLCT();
    }

    @Override
    public boolean overloadChecking() {
        this.clear();
        Arrays.sort(this.rtasks, 0, this.size.get(), TaskComparators.makeRLatestCompletionTimeCmp());
        this.setup(this.altDisjTreeTL, IVilimTree.TreeMode.ECT);
        for (IRTask t : this) {
            TaskVar i = t.getTaskVar();
            this.insertInTree(t);
            if (this.altDisjTreeTL.getTime() > i.getLCT()) {
                return true;
            }
            while (this.altDisjTreeTL.getGrayTime() > i.getLCT()) {
                this.setAsRemoval();
            }
        }
        this.setMakespanLB(this.altDisjTreeTL);
        return false;
    }

    @Override
    public Iterator<IRTask> iterator() {
        return new Itr();
    }

    final class AltBipartiteQueue<E>
    implements IBipartiteQueue<E> {
        public final E[] elementData;
        private int level;

        public AltBipartiteQueue(E[] elementData) {
            this.elementData = Arrays.copyOf(elementData, elementData.length);
            this.reset();
        }

        @Override
        public void reset() {
            this.level = 0;
        }

        @Override
        public boolean isEmpty() {
            return this.level == AltDisjRules.this.size.get();
        }

        @Override
        public E poll() {
            return this.elementData[this.level++];
        }

        @Override
        public E peek() {
            return this.elementData[this.level];
        }

        @Override
        public void sort(Comparator<? super E> cmp) {
            Arrays.sort(this.elementData, this.level, AltDisjRules.this.size.get(), cmp);
        }
    }

    final class Itr
    implements Iterator<IRTask> {
        private int level = 0;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.level < AltDisjRules.this.size.get();
        }

        @Override
        public IRTask next() {
            return AltDisjRules.this.rtasks[this.level++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not available");
        }
    }
}

