/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.IPretty;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;

public abstract class AbstractTaskSConstraint
extends AbstractLargeIntSConstraint {
    protected final TaskVar[] taskvars;
    protected final int taskIntVarOffset;

    public AbstractTaskSConstraint(TaskVar task1, TaskVar task2, IntDomainVar ... otherVars) {
        this(new TaskVar[]{task1, task2}, otherVars);
    }

    public AbstractTaskSConstraint(TaskVar[] taskvars, IntDomainVar ... otherVars) {
        super(UtilAlgo.append(AbstractTaskSConstraint.taskVarToIntVar(taskvars), otherVars));
        this.taskvars = taskvars;
        this.taskIntVarOffset = 3 * this.getNbTasks();
    }

    public static final TaskVar[] createTaskVarArray(Solver solver) {
        TaskVar[] tasks = new TaskVar[solver.getNbTaskVars()];
        for (int i = 0; i < solver.getNbTaskVars(); ++i) {
            tasks[i] = solver.getTaskVar(i);
            if (tasks[i].getID() == i) continue;
            throw new SolverException("invalid task ID");
        }
        return tasks;
    }

    public static final IntDomainVar[] taskVarToIntVar(TaskVar[] taskvars) {
        int n = taskvars.length;
        IntDomainVar[] ivars = new IntDomainVar[3 * n];
        for (int i = 0; i < n; ++i) {
            ivars[i] = taskvars[i].start();
            ivars[i + n] = taskvars[i].end();
            ivars[i + 2 * n] = taskvars[i].duration();
        }
        return ivars;
    }

    protected boolean isStartEvent(int idx) {
        return idx < this.getNbTasks();
    }

    protected boolean isEndEvent(int idx) {
        return this.getNbTasks() <= idx && idx < 2 * this.getNbTasks();
    }

    protected boolean isDurationEvent(int idx) {
        return 2 * this.getNbTasks() <= idx && idx < this.taskIntVarOffset;
    }

    protected final int getTaskIntVarOffset() {
        return this.taskIntVarOffset;
    }

    protected TaskVar intVarIndexToTask(int vidx) {
        return vidx < 3 * this.getNbTasks() ? this.getTask(vidx % this.getNbTasks()) : null;
    }

    protected final int getCIndiceStart(int taskIdx) {
        return this.cIndices[taskIdx];
    }

    protected final int getCIndiceEnd(int taskIdx) {
        return this.cIndices[this.getNbTasks() + taskIdx];
    }

    protected final int getCIndiceDuration(int taskIdx) {
        return this.cIndices[2 * this.getNbTasks() + taskIdx];
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    @Override
    public void addListener(boolean dynamicAddition) {
        super.addListener(dynamicAddition);
        for (int i = 0; i < this.getNbTasks(); ++i) {
            this.getTask(i).addConstraint(this, -1, dynamicAddition);
        }
    }

    public final void ensureTaskConsistency() throws ContradictionException {
        for (int i = 0; i < this.getNbTasks(); ++i) {
            this.updateCompulsoryPart(i);
        }
    }

    public final void updateCompulsoryPart(int taskIdx) throws ContradictionException {
        TaskVar t = this.taskvars[taskIdx];
        IntDomainVar s = t.start();
        IntDomainVar e = t.end();
        IntDomainVar d = t.duration();
        int sidx = this.getCIndiceStart(taskIdx);
        int eidx = this.getCIndiceEnd(taskIdx);
        int didx = this.getCIndiceDuration(taskIdx);
        for (boolean fixPoint = true; fixPoint; fixPoint |= d.updateSup(e.getSup() - s.getInf(), didx)) {
            fixPoint = false;
            fixPoint |= s.updateInf(e.getInf() - d.getSup(), sidx);
            fixPoint |= s.updateSup(e.getSup() - d.getInf(), sidx);
            fixPoint |= e.updateInf(s.getInf() + d.getInf(), eidx);
            fixPoint |= e.updateSup(s.getSup() + d.getSup(), eidx);
            fixPoint |= d.updateInf(e.getInf() - s.getSup(), didx);
        }
    }

    @Override
    public void awakeOnRemovals(int idx, IntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
    }

    public int getNbTasks() {
        return this.taskvars.length;
    }

    public TaskVar getTask(int idx) {
        return this.taskvars[idx];
    }

    @Override
    public String pretty() {
        StringBuilder b = new StringBuilder();
        b.append(this.toString());
        b.append(" taskvars ");
        b.append(ChocoUtil.pretty((IPretty[])this.taskvars));
        if (this.vars.length > 3 * this.getNbTasks()) {
            b.append(" intvars");
            b.append(ChocoUtil.pretty((IPretty[])this.vars, 3 * this.getNbTasks(), this.vars.length));
        }
        return new String(b);
    }
}

