/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.BitFlags;
import choco.cp.solver.constraints.global.scheduling.AbstractTaskSConstraint;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.scheduling.IResource;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.AbstractRTask;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractResourceSConstraint
extends AbstractTaskSConstraint
implements IResource<TaskVar> {
    protected final IRTask[] rtasks = new IRTask[this.getNbTasks()];
    protected final String name;
    protected final BitFlags flags;
    protected final int indexUnit;
    protected final int indexUB;

    public AbstractResourceSConstraint(String name, TaskVar[] taskvars, IntDomainVar uppBound, IntDomainVar ... otherVars) {
        super(taskvars, AbstractResourceSConstraint.createIntVarArray(otherVars, uppBound));
        this.name = name;
        this.indexUB = this.getNbVars() - 2;
        this.indexUnit = this.getNbVars() - 1;
        this.flags = new BitFlags();
        for (int i = 0; i < taskvars.length; ++i) {
            this.rtasks[i] = new RTask(i);
        }
    }

    @Override
    public final IRTask getRTask(int idx) {
        return this.rtasks[idx];
    }

    protected int getUsageIndex(int taskIdx) {
        return this.indexUnit;
    }

    protected int getHeightIndex(int taskIdx) {
        return this.indexUnit;
    }

    @Override
    public void setSolver(Solver solver) {
        super.setSolver(solver);
    }

    private static final IntDomainVar[] createIntVarArray(IntDomainVar[] otherVars, IntDomainVar uppBound) {
        if (uppBound == null) {
            throw new SolverException("no makepsan specified for a resource constraint");
        }
        IntDomainVar unit = uppBound.getSolver().createIntegerConstant("unit", 1);
        return UtilAlgo.append(otherVars, {uppBound, unit});
    }

    protected void updateMakespan(int value) throws ContradictionException {
        if (this.indexUB >= 0) {
            this.getIntVar(this.indexUB).updateInf(value, this.cIndices[this.indexUB]);
        }
    }

    public final BitFlags getFlags() {
        return this.flags;
    }

    @Override
    public void awake() throws ContradictionException {
        this.ensureTaskConsistency();
        super.awake();
    }

    private final void checkTask(int varIdx) throws ContradictionException {
        if (varIdx < this.taskIntVarOffset) {
            this.updateCompulsoryPart(varIdx % this.getNbTasks());
        }
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        this.checkTask(varIdx);
        super.awakeOnInf(varIdx);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.checkTask(idx);
        super.awakeOnInst(idx);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        this.checkTask(varIdx);
        super.awakeOnSup(varIdx);
    }

    @Override
    public String pretty() {
        return super.pretty();
    }

    @Override
    public String getRscName() {
        return this.name;
    }

    @Override
    public List<TaskVar> asList() {
        return Collections.unmodifiableList(Arrays.asList(this.taskvars));
    }

    @Override
    public Iterator<TaskVar> getTaskIterator() {
        return ChocoUtil.iterator(this.taskvars);
    }

    public class RTask
    extends AbstractRTask {
        public RTask(int taskidx) {
            super(taskidx);
        }

        @Override
        public TaskVar getTaskVar() {
            return AbstractResourceSConstraint.this.taskvars[this.taskIdx];
        }

        @Override
        public boolean schedule(int startingTime, int duration) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].start().instantiate(startingTime, AbstractResourceSConstraint.this.getCIndiceStart(this.taskIdx)) || AbstractResourceSConstraint.this.taskvars[this.taskIdx].duration().instantiate(duration, AbstractResourceSConstraint.this.getCIndiceDuration(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public boolean setDuration(int duration) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].duration().instantiate(duration, AbstractResourceSConstraint.this.getCIndiceDuration(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public boolean setStartingTime(int startingTime) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].start().instantiate(startingTime, AbstractResourceSConstraint.this.getCIndiceStart(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public boolean updateECT(int val) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].end().updateInf(val, AbstractResourceSConstraint.this.getCIndiceEnd(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public boolean updateEST(int val) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].start().updateInf(val, AbstractResourceSConstraint.this.getCIndiceStart(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public boolean updateLCT(int val) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].end().updateSup(val, AbstractResourceSConstraint.this.getCIndiceEnd(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public boolean updateLST(int val) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].start().updateSup(val, AbstractResourceSConstraint.this.getCIndiceStart(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public boolean updateMaxDuration(int val) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].duration().updateSup(val, AbstractResourceSConstraint.this.getCIndiceDuration(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public boolean updateMinDuration(int val) throws ContradictionException {
            if (AbstractResourceSConstraint.this.taskvars[this.taskIdx].duration().updateInf(val, AbstractResourceSConstraint.this.getCIndiceDuration(this.taskIdx))) {
                AbstractResourceSConstraint.this.updateCompulsoryPart(this.taskIdx);
                return true;
            }
            return false;
        }

        @Override
        public void fail() throws ContradictionException {
            AbstractResourceSConstraint.this.fail();
        }

        @Override
        public boolean assign() throws ContradictionException {
            int idx = AbstractResourceSConstraint.this.getUsageIndex(this.taskIdx);
            return AbstractResourceSConstraint.this.vars[idx].instantiate(1, AbstractResourceSConstraint.this.cIndices[idx]);
        }

        @Override
        public boolean isOptional() {
            return !AbstractResourceSConstraint.this.vars[AbstractResourceSConstraint.this.getUsageIndex(this.taskIdx)].isInstantiated();
        }

        @Override
        public boolean isRegular() {
            return AbstractResourceSConstraint.this.vars[AbstractResourceSConstraint.this.getUsageIndex(this.taskIdx)].isInstantiatedTo(1);
        }

        @Override
        public boolean isEliminated() {
            return AbstractResourceSConstraint.this.vars[AbstractResourceSConstraint.this.getUsageIndex(this.taskIdx)].isInstantiatedTo(0);
        }

        @Override
        public boolean remove() throws ContradictionException {
            int idx = AbstractResourceSConstraint.this.getUsageIndex(this.taskIdx);
            return AbstractResourceSConstraint.this.vars[idx].instantiate(0, AbstractResourceSConstraint.this.cIndices[idx]);
        }

        @Override
        public IntDomainVar getHeight() {
            return AbstractResourceSConstraint.this.vars[AbstractResourceSConstraint.this.getHeightIndex(this.taskIdx)];
        }

        @Override
        public boolean updateMaxHeight(int val) throws ContradictionException {
            int idx = AbstractResourceSConstraint.this.getHeightIndex(this.taskIdx);
            return AbstractResourceSConstraint.this.vars[idx].updateSup(val, AbstractResourceSConstraint.this.cIndices[idx]);
        }

        @Override
        public boolean updateMinHeight(int val) throws ContradictionException {
            int idx = AbstractResourceSConstraint.this.getHeightIndex(this.taskIdx);
            return AbstractResourceSConstraint.this.vars[idx].updateInf(val, AbstractResourceSConstraint.this.cIndices[idx]);
        }

        public String toString() {
            return this.getTaskVar().getName();
        }

        @Override
        public String pretty() {
            return this.getTaskVar().pretty();
        }
    }
}

