/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.IBipartiteQueue;
import choco.cp.solver.constraints.global.scheduling.IDisjRules;
import choco.cp.solver.constraints.global.scheduling.Update;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaLambdaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.common.util.TaskComparators;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDisjRules
implements IDisjRules {
    protected final IRTask[] rtasks;
    protected final List<Update> updateL;
    protected int makespanLB;
    protected IVilimTree.TreeMode state;

    public AbstractDisjRules(IRTask[] rtasks) {
        this.rtasks = Arrays.copyOf(rtasks, rtasks.length);
        this.updateL = new LinkedList<Update>();
        this.fireDomainChanged();
    }

    protected final ITask[] getTaskArray() {
        ITask[] tasks = new ITask[this.rtasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = this.rtasks[i].getTaskVar();
        }
        return tasks;
    }

    protected void clear() {
        this.updateL.clear();
    }

    @Override
    public void fireDomainChanged() {
        this.state = null;
        this.makespanLB = Integer.MIN_VALUE;
    }

    protected final void setup(IVilimTree tree, IVilimTree.TreeMode mode) {
        if (this.state == mode) {
            tree.reset();
        } else {
            this.state = mode;
            tree.setMode(this.state);
        }
    }

    @Override
    public final int getMakespanLB() {
        return this.makespanLB;
    }

    protected final void setMakespanLB(IThetaTree tree) {
        this.makespanLB = Math.max(this.makespanLB, tree.getTime());
    }

    protected final void addUpdate(IRTask task, int value) {
        this.updateL.add(new Update(task, value));
    }

    protected final boolean updateLCT() throws ContradictionException {
        boolean noFixPoint = false;
        for (Update p : this.updateL) {
            noFixPoint |= p.rtask.updateLCT(p.value);
        }
        return noFixPoint;
    }

    protected final boolean updateEST() throws ContradictionException {
        boolean noFixPoint = false;
        for (Update p : this.updateL) {
            noFixPoint |= p.rtask.updateEST(p.value);
        }
        return noFixPoint;
    }

    @Override
    public final boolean detectablePrecedence() throws ContradictionException {
        return this.detectablePrecedenceEST() | this.detectablePrecedenceLCT();
    }

    @Override
    public final boolean edgeFinding() throws ContradictionException {
        return this.edgeFindingEST() | this.edgeFindingLCT();
    }

    @Override
    public final boolean notFirstNotLast() throws ContradictionException {
        return this.notFirst() | this.notFirstNotLast();
    }

    protected final boolean edgeFindingEST(IThetaLambdaTree disjTreeTL, IBipartiteQueue<IRTask> rqueue) throws ContradictionException {
        rqueue.sort(TaskComparators.makeReverseRLatestCompletionTimeCmp());
        this.setMakespanLB(disjTreeTL);
        IRTask rtj = rqueue.peek();
        TaskVar j = rtj.getTaskVar();
        if (disjTreeTL.getTime() > j.getLCT()) {
            rtj.fail();
        }
        do {
            rqueue.poll();
            if (!rtj.isRegular()) continue;
            disjTreeTL.removeFromThetaAndInsertInLambda(rtj);
            if (rqueue.isEmpty()) break;
            rtj = rqueue.peek();
            j = rtj.getTaskVar();
            if (disjTreeTL.getTime() > j.getLCT()) {
                rtj.fail();
            }
            while (disjTreeTL.getGrayTime() > j.getLCT()) {
                IRTask rti = (IRTask)disjTreeTL.getResponsibleTask();
                TaskVar i = rti.getTaskVar();
                if (disjTreeTL.getTime() > i.getEST()) {
                    this.addUpdate(rti, disjTreeTL.getTime());
                }
                disjTreeTL.removeFromLambda(i);
            }
        } while (!rqueue.isEmpty());
        return this.updateEST();
    }

    protected final boolean edgeFindingLCT(IThetaLambdaTree disjTreeTL, IBipartiteQueue<IRTask> rqueue) throws ContradictionException {
        rqueue.sort(TaskComparators.makeREarliestStartingTimeCmp());
        IRTask rtj = rqueue.peek();
        TaskVar j = rtj.getTaskVar();
        if (disjTreeTL.getTime() < j.getEST()) {
            rtj.fail();
        }
        do {
            rqueue.poll();
            if (!rtj.isRegular()) continue;
            disjTreeTL.removeFromThetaAndInsertInLambda(rtj);
            if (rqueue.isEmpty()) break;
            rtj = rqueue.peek();
            j = rtj.getTaskVar();
            if (disjTreeTL.getTime() < j.getEST()) {
                rtj.fail();
            }
            while (disjTreeTL.getGrayTime() < j.getEST()) {
                IRTask rti = (IRTask)disjTreeTL.getResponsibleTask();
                TaskVar i = rti.getTaskVar();
                this.addUpdate(rti, disjTreeTL.getTime());
                disjTreeTL.removeFromLambda(i);
            }
        } while (!rqueue.isEmpty());
        return this.updateLCT();
    }
}

