/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.global.scheduling.ICumulativeResource;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;

public abstract class AbstractCumulativeSConstraint
extends AbstractResourceSConstraint
implements ICumulativeResource<TaskVar> {
    private final IStateBool fixedHeights;
    private final IStateBool positiveHeights;
    private final IStateBool regularWithNegativeHeight;
    protected final int indexConsumption;
    protected final int indexCapacity;

    public AbstractCumulativeSConstraint(String name, TaskVar[] taskvars, IntDomainVar[] heights, IntDomainVar consumption, IntDomainVar capacity, IntDomainVar uppBound, IntDomainVar ... otherVars) {
        super(name, taskvars, uppBound, UtilAlgo.append(heights, {consumption, capacity}, otherVars));
        if (taskvars.length != heights.length) {
            throw new SolverException("tasks and heights array have different length.");
        }
        this.indexConsumption = this.getTaskIntVarOffset() + heights.length;
        this.indexCapacity = this.indexConsumption + 1;
        IEnvironment env = this.getVar(0).getSolver().getEnvironment();
        this.fixedHeights = env.makeBool(false);
        this.positiveHeights = env.makeBool(false);
        this.regularWithNegativeHeight = env.makeBool(false);
    }

    public final int getCIndiceHeight(int taskIdx) {
        return this.cIndices[this.getTaskIntVarOffset() + taskIdx];
    }

    public boolean updateMinCapacity(int val) throws ContradictionException {
        return this.vars[this.indexCapacity].updateInf(val, this.cIndices[this.indexCapacity]);
    }

    public boolean updateMaxCapacity(int val) throws ContradictionException {
        return this.vars[this.indexCapacity].updateSup(val, this.cIndices[this.indexCapacity]);
    }

    public boolean updateMinConsumption(int val) throws ContradictionException {
        return this.vars[this.indexConsumption].updateInf(val, this.cIndices[this.indexConsumption]);
    }

    public boolean updateMaxConsumption(int val) throws ContradictionException {
        return this.vars[this.indexConsumption].updateSup(val, this.cIndices[this.indexConsumption]);
    }

    @Override
    public final IntDomainVar getCapacity() {
        return this.getIntVar(this.indexCapacity);
    }

    @Override
    public final int getMaxCapacity() {
        return this.getCapacity().getSup();
    }

    @Override
    public final int getMinCapacity() {
        return this.getCapacity().getInf();
    }

    @Override
    public final IntDomainVar getConsumption() {
        return this.vars[this.indexConsumption];
    }

    @Override
    public final int getMaxConsumption() {
        return this.getConsumption().getSup();
    }

    @Override
    public final int getMinConsumption() {
        return this.getConsumption().getInf();
    }

    @Override
    public final IntDomainVar getHeight(int idx) {
        return this.getIntVar(this.getTaskIntVarOffset() + idx);
    }

    @Override
    public final boolean isInstantiatedHeights() {
        if (!this.fixedHeights.get()) {
            for (int i = 0; i < this.getNbTasks(); ++i) {
                IRTask rtask = this.getRTask(i);
                if (rtask.isEliminated() || rtask.getHeight().isInstantiated()) continue;
                return false;
            }
            this.fixedHeights.set(true);
        }
        return true;
    }

    @Override
    public final boolean hasOnlyPosisiveHeights() {
        if (!this.positiveHeights.get()) {
            if (this.regularWithNegativeHeight.get()) {
                return false;
            }
            for (int i = 0; i < this.getNbTasks(); ++i) {
                IRTask rtask = this.getRTask(i);
                if (rtask.isEliminated() || rtask.getMinHeight() >= 0) continue;
                if (rtask.isRegular()) {
                    this.regularWithNegativeHeight.set(true);
                }
                return false;
            }
            this.positiveHeights.set(true);
        }
        return true;
    }
}

