/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.pack;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.BitFlags;
import choco.cp.solver.constraints.global.pack.AbstractNbNonEmptyBound;
import choco.cp.solver.constraints.global.pack.BinStatus;
import choco.cp.solver.constraints.global.pack.IPackSConstraint;
import choco.cp.solver.constraints.global.pack.PackFiltering;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.common.util.IntIterator;
import choco.kernel.common.util.UtilAlgo;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.set.AbstractLargeSetIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;
import java.awt.Point;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class PrimalDualPack
extends AbstractLargeSetIntSConstraint
implements IPackSConstraint {
    public final PackFiltering filtering;
    protected final BinStatus status;
    protected final IntDomainVar[] sizes;
    protected final IntDomainVar[] loads;
    protected final IntDomainVar[] bins;

    public PrimalDualPack(SetVar[] itemSets, IntDomainVar[] loads, IntDomainVar[] sizes, IntDomainVar[] bins, IntDomainVar nbNonEmpty, BitFlags flags) {
        super(UtilAlgo.append(loads, sizes, bins, {nbNonEmpty}), itemSets);
        this.loads = loads;
        this.sizes = sizes;
        this.bins = bins;
        this.filtering = new PackFiltering(this, new PackBound(), flags);
        this.status = new BinStatus(this.sizes);
    }

    public final boolean isEmpty(int bin) {
        return this.svars[bin].getKernelDomainSize() == 0;
    }

    public final int getRequiredSpace(int bin) {
        IntIterator iter = this.svars[bin].getDomain().getKernelIterator();
        int load = 0;
        while (iter.hasNext()) {
            load += this.sizes[iter.next()].getVal();
        }
        return load;
    }

    public final int getRemainingSpace(int bin) {
        return this.loads[bin].getSup() - this.getRequiredSpace(bin);
    }

    protected boolean isSetEvent(int varIdx) {
        return varIdx < this.svars.length;
    }

    protected int getItemIndex(int varIdx) {
        int idx = varIdx - (2 * this.loads.length + this.sizes.length);
        return idx < 0 || idx == this.sizes.length ? -1 : idx;
    }

    protected int getItemCindice(int item) {
        return this.int_cIndices[this.loads.length + this.sizes.length + item];
    }

    @Override
    public void setSolver(Solver solver) {
        super.setSolver(solver);
        this.filtering.setSolver(solver);
    }

    public final IntDomainVar[] getBins() {
        return this.bins;
    }

    @Override
    public int getNbBins() {
        return this.sizes.length;
    }

    @Override
    public int getNbItems() {
        return this.loads.length;
    }

    @Override
    public IntDomainVar[] getLoads() {
        return this.loads;
    }

    @Override
    public IntDomainVar[] getSizes() {
        return this.sizes;
    }

    @Override
    public BinStatus getStatus(int bin) {
        this.status.set(bin, this.svars[bin]);
        return this.status;
    }

    @Override
    public boolean isFilled(int bin) {
        return this.svars[bin].isInstantiated();
    }

    @Override
    public boolean pack(int item, int bin) throws ContradictionException {
        boolean res = this.svars[bin].addToKernel(item, this.set_cIndices[bin]);
        if (this.bins[item].isInstantiated()) {
            CPSolver.flushLogs();
            throw new SolverException("Internal error : " + this.bins[item].pretty() + " should not be instantiated");
        }
        DisposableIntIterator iter = this.bins[item].getDomain().getIterator();
        while (iter.hasNext()) {
            int b = iter.next();
            if (bin == b) continue;
            res |= this.svars[b].remFromEnveloppe(item, this.set_cIndices[b]);
        }
        return this.bins[item].instantiate(bin, this.getItemCindice(item)) || res;
    }

    @Override
    public boolean remove(int item, int bin) throws ContradictionException {
        boolean res = this.svars[bin].remFromEnveloppe(item, this.set_cIndices[bin]);
        res |= this.bins[item].removeVal(bin, this.getItemCindice(item));
        if (this.bins[item].isInstantiated()) {
            int b = this.bins[item].getVal();
            this.svars[b].addToKernel(item, this.set_cIndices[b]);
        }
        return res;
    }

    @Override
    public boolean updateInfLoad(int bin, int load) throws ContradictionException {
        return this.loads[bin].updateInf(load, this.int_cIndices[bin]);
    }

    @Override
    public void updateNbNonEmpty(Point bounds) throws ContradictionException {
        int idx = this.ivars.length - 1;
        this.ivars[idx].updateInf(bounds.x, this.int_cIndices[idx]);
        this.ivars[idx].updateSup(bounds.y, this.int_cIndices[idx]);
    }

    @Override
    public boolean updateSupLoad(int bin, int load) throws ContradictionException {
        return this.loads[bin].updateSup(load, this.int_cIndices[bin]);
    }

    @Override
    public boolean isConsistent() {
        return false;
    }

    protected void checkBounds(int item) throws ContradictionException {
        this.bins[item].updateInf(0, this.getItemCindice(item));
        this.bins[item].updateSup(this.svars.length - 1, this.getItemCindice(item));
    }

    protected void checkEnveloppes() throws ContradictionException {
        for (int bin = 0; bin < this.svars.length; ++bin) {
            int sup;
            int inf;
            while ((inf = this.svars[bin].getEnveloppeInf()) < 0) {
                this.svars[bin].remFromEnveloppe(inf, this.set_cIndices[bin]);
            }
            while ((sup = this.svars[bin].getEnveloppeSup()) > this.bins.length - 1) {
                this.svars[bin].remFromEnveloppe(sup, this.set_cIndices[bin]);
            }
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.checkEnveloppes();
        for (int item = 0; item < this.bins.length; ++item) {
            this.checkBounds(item);
            if (this.bins[item].isInstantiated()) {
                int b;
                int b0 = this.bins[item].getVal();
                this.svars[b0].addToKernel(item, this.set_cIndices[b0]);
                for (b = 0; b < b0; ++b) {
                    this.svars[b].remFromEnveloppe(item, this.set_cIndices[b]);
                }
                for (b = b0 + 1; b < this.svars.length; ++b) {
                    this.svars[b].remFromEnveloppe(item, this.set_cIndices[b]);
                }
                continue;
            }
            for (int bin = 0; bin < this.svars.length; ++bin) {
                if (this.svars[bin].isInDomainEnveloppe(item)) {
                    if (this.svars[bin].isInDomainKernel(item)) {
                        this.bins[item].instantiate(bin, this.getItemCindice(item));
                        continue;
                    }
                    if (this.bins[item].getDomain().contains(bin)) continue;
                    this.svars[bin].remFromEnveloppe(item, this.set_cIndices[bin]);
                    continue;
                }
                this.bins[item].removeVal(bin, this.getItemCindice(item));
            }
        }
        super.awake();
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        this.bins[x].removeVal(varIdx, this.getItemCindice(x));
        if (this.bins[x].isInstantiated()) {
            int b = this.bins[x].getVal();
            this.svars[b].addToKernel(x, this.set_cIndices[b]);
        }
        this.constAwake(false);
    }

    protected void checkDeltaDomain(int item) throws ContradictionException {
        DisposableIntIterator iter = this.bins[item].getDomain().getDeltaIterator();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                int b = iter.next();
                this.svars[b].remFromEnveloppe(item, this.set_cIndices[b]);
            }
        } else {
            throw new SolverException("empty delta domain: " + this.bins[item].pretty());
        }
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        int item = this.getItemIndex(varIndex);
        if (item >= 0) {
            this.checkDeltaDomain(item);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        this.awakeOnBounds(varIdx);
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        if (this.isSetEvent(varIdx)) {
            int item;
            IntIterator iter = this.svars[varIdx].getDomain().getKernelIterator();
            while (iter.hasNext()) {
                item = iter.next();
                if (this.bins[item].isInstantiated()) continue;
                this.pack(item, varIdx);
            }
            iter = this.svars[varIdx].getDomain().getEnveloppeDomain().getDeltaIterator();
            while (iter.hasNext()) {
                item = iter.next();
                if (!this.bins[item].getDomain().contains(varIdx)) continue;
                this.remove(item, varIdx);
            }
        } else {
            int item = this.getItemIndex(varIdx);
            if (item >= 0) {
                int b = this.bins[item].getVal();
                this.svars[b].addToKernel(item, this.set_cIndices[b]);
                this.checkDeltaDomain(item);
            }
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        this.pack(x, varIdx);
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
        int item = this.getItemIndex(varIdx);
        if (item >= 0) {
            this.svars[val].remFromEnveloppe(item, this.set_cIndices[val]);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        this.awakeOnBounds(varIdx);
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filtering.propagate();
    }

    @Override
    public boolean isSatisfied() {
        return this.filtering.availableBins.isEmpty();
    }

    class PackBound
    extends AbstractNbNonEmptyBound {
        List<Integer> binsLB;
        int[] remainingSpace;

        public PackBound() {
            super(PrimalDualPack.this.loads.length, PrimalDualPack.this.sizes.length);
            this.binsLB = new LinkedList<Integer>();
            this.remainingSpace = new int[PrimalDualPack.this.loads.length];
        }

        @Override
        protected void reset() {
            Arrays.fill(this.remainingSpace, 0);
            this.binsLB.clear();
            super.reset();
        }

        @Override
        protected void initialize() {
            for (int b = 0; b < this.nbBins; ++b) {
                if (PrimalDualPack.this.svars[b].isInstantiated()) {
                    if (PrimalDualPack.this.loads[b].isInstantiatedTo(0)) {
                        ++this.nbEmpty;
                        continue;
                    }
                    ++this.nbFull;
                    continue;
                }
                this.binsLB.add(b);
                int n = b;
                this.remainingSpace[n] = this.remainingSpace[n] + PrimalDualPack.this.loads[b].getSup();
                this.capacityLB = Math.max(this.capacityLB, this.remainingSpace[b]);
                if (PrimalDualPack.this.svars[b].getKernelDomainSize() <= 0) continue;
                ++this.nbSome;
            }
            this.nbBinsLB = this.binsLB.size();
        }

        @Override
        protected int setBinItems(int[] dest, int begin) {
            int idx = begin;
            for (int b : this.binsLB) {
                int s = this.capacityLB - this.remainingSpace[b];
                if (s <= 0) continue;
                dest[idx++] = s;
            }
            return idx;
        }

        @Override
        protected int setUnpackedItems(int[] dest, int begin) {
            int idx = begin;
            for (int i = 0; i < PrimalDualPack.this.bins.length; ++i) {
                if (PrimalDualPack.this.bins[i].isInstantiated()) {
                    if (PrimalDualPack.this.svars[PrimalDualPack.this.bins[i].getVal()].isInstantiated()) continue;
                    int n = PrimalDualPack.this.bins[i].getVal();
                    this.remainingSpace[n] = this.remainingSpace[n] - PrimalDualPack.this.sizes[i].getVal();
                    continue;
                }
                dest[idx++] = PrimalDualPack.this.sizes[i].getVal();
            }
            return idx;
        }
    }
}

