/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.pack;

import choco.cp.solver.SettingType;
import choco.cp.solver.constraints.BitFlags;
import choco.cp.solver.constraints.global.pack.AbstractNbNonEmptyBound;
import choco.cp.solver.constraints.global.pack.BinStatus;
import choco.cp.solver.constraints.global.pack.IPackSConstraint;
import choco.cp.solver.constraints.global.pack.SumDataStruct;
import choco.kernel.common.opres.AbstractNoSum;
import choco.kernel.common.util.ChocoUtil;
import choco.kernel.common.util.DisposableIntIterator;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.awt.Point;
import java.util.BitSet;

public class PackFiltering {
    public final IPackSConstraint cstr;
    public final BitFlags flags;
    public final int nbBins;
    public final int nbItems;
    protected final IntDomainVar[] sizes;
    protected final IntDomainVar[] loads;
    protected final AbstractNbNonEmptyBound bounds;
    protected BinStatus status;
    protected IStateIntVector availableBins;
    private boolean noFixPoint;
    protected final SumDataStruct loadSum;

    public PackFiltering(IPackSConstraint cstr, AbstractNbNonEmptyBound bounds, BitFlags flags) {
        this.cstr = cstr;
        this.sizes = cstr.getSizes();
        this.loads = cstr.getLoads();
        this.bounds = bounds;
        this.nbBins = this.loads.length;
        this.nbItems = this.sizes.length;
        this.loadSum = new SumDataStruct(this.loads, this.computeTotalSize());
        this.flags = flags;
    }

    protected void setSolver(Solver solver) {
        this.availableBins = solver.getEnvironment().makeBipartiteIntList(ChocoUtil.zeroToN(this.nbBins));
    }

    private long computeTotalSize() {
        long l = 0L;
        int last = Integer.MAX_VALUE;
        for (int i = 0; i < this.sizes.length; ++i) {
            int s;
            if (this.sizes[i].isInstantiated()) {
                s = this.sizes[i].getVal();
                if (s > last) {
                    throw new SolverException("size must be sorted according to non increasing order");
                }
                l += (long)s;
            } else {
                throw new SolverException("sizes must be constant");
            }
            last = s;
        }
        return l;
    }

    private void updateAvailableBins() {
        DisposableIntIterator iter = this.availableBins.getIterator();
        while (iter.hasNext()) {
            int b = iter.next();
            if (!this.cstr.isFilled(b)) continue;
            iter.remove();
        }
    }

    protected void updateInfLoad(int bin, int load) throws ContradictionException {
        this.noFixPoint |= this.cstr.updateInfLoad(bin, load);
    }

    protected void updateSupLoad(int bin, int load) throws ContradictionException {
        this.noFixPoint |= this.cstr.updateSupLoad(bin, load);
    }

    protected void pack(int item, int bin) throws ContradictionException {
        if (this.cstr.pack(item, bin)) {
            this.status.pack(item);
            this.noFixPoint |= true;
        }
    }

    protected void remove(int item, int bin) throws ContradictionException {
        if (this.cstr.remove(item, bin)) {
            this.status.remove(item);
            this.noFixPoint |= true;
        }
    }

    protected void loadMaintenance(int bin) throws ContradictionException {
        this.updateInfLoad(bin, this.status.getRequiredLoad());
        this.updateSupLoad(bin, this.status.getMaxLoad());
    }

    protected void loadSizeAndCoherence(int bin) throws ContradictionException {
        Point p = this.loadSum.getBounds(bin);
        this.updateInfLoad(bin, p.x);
        this.updateSupLoad(bin, p.y);
    }

    protected void singleItemEliminationAndCommitment(int bin) throws ContradictionException {
        BitSet candidates = this.status.getCandidates();
        int item = candidates.nextSetBit(0);
        while (item >= 0) {
            if (this.sizes[item].getInf() + this.status.getRequiredLoad() > this.loads[bin].getSup()) {
                this.remove(item, bin);
            } else if (this.status.getMaxLoad() - this.sizes[item].getSup() < this.loads[bin].getInf()) {
                this.pack(item, bin);
            }
            item = candidates.nextSetBit(item + 1);
        }
    }

    protected void singleItemEliminationAndCommitmentAndFill(int bin) throws ContradictionException {
        BitSet candidates = this.status.getCandidates();
        int item = candidates.nextSetBit(0);
        while (item >= 0) {
            if (this.sizes[item].getInf() + this.status.getRequiredLoad() > this.loads[bin].getSup()) {
                this.remove(item, bin);
            } else if (this.status.getMaxLoad() - this.sizes[item].getSup() < this.loads[bin].getInf()) {
                this.pack(item, bin);
            } else if (this.status.getRequiredLoad() + this.sizes[item].getInf() == this.loads[bin].getSup()) {
                this.pack(item, bin);
            }
            item = candidates.nextSetBit(item + 1);
        }
    }

    protected final void noSumPruningRule(AbstractNoSum nosum, int bin) throws ContradictionException {
        if (nosum.noSum(this.loads[bin].getInf() - this.status.getRequiredLoad(), this.loads[bin].getSup() - this.status.getRequiredLoad())) {
            this.cstr.fail();
        }
    }

    protected void noSumBinLoads(AbstractNoSum nosum, int bin) throws ContradictionException {
        if (nosum.noSum(this.loads[bin].getInf() - this.status.getRequiredLoad(), this.loads[bin].getInf() - this.status.getRequiredLoad())) {
            this.updateInfLoad(bin, this.status.getRequiredLoad() + nosum.getAlphaBeta().y);
        }
        if (nosum.noSum(this.loads[bin].getSup() - this.status.getRequiredLoad(), this.loads[bin].getSup() - this.status.getRequiredLoad())) {
            this.updateSupLoad(bin, this.status.getRequiredLoad() + nosum.getAlphaBeta().x);
        }
    }

    protected final void noSumItemEliminationAndCommitment(AbstractNoSum nosum, int bin) throws ContradictionException {
        BitSet candidates = this.status.getCandidates();
        int item = candidates.nextSetBit(0);
        while (item >= 0) {
            this.status.remove(item);
            if (candidates.isEmpty()) break;
            if (nosum.noSum(this.loads[bin].getInf() - this.status.getRequiredLoad() - this.sizes[item].getVal(), this.loads[bin].getSup() - this.status.getRequiredLoad() - this.sizes[item].getInf())) {
                this.status.insertCandidate(item);
                this.remove(item, bin);
            } else if (nosum.noSum(this.loads[bin].getInf() - this.status.getRequiredLoad(), this.loads[bin].getSup() - this.status.getRequiredLoad())) {
                this.status.insertCandidate(item);
                this.pack(item, bin);
            } else {
                this.status.insertCandidate(item);
            }
            item = candidates.nextSetBit(item + 1);
        }
    }

    public void propagate() throws ContradictionException {
        this.noFixPoint = true;
        while (this.noFixPoint) {
            this.noFixPoint = false;
            this.loadSum.update();
            for (int i = 0; i < this.availableBins.size(); ++i) {
                this.propagate(this.availableBins.get(i));
            }
        }
        this.updateAvailableBins();
        this.bounds.reset();
        this.cstr.updateNbNonEmpty(this.flags.contains(SettingType.DYNAMIC_LB) ? this.bounds.computeBoundsDDFF() : this.bounds.computeBounds());
    }

    private void propagate(int bin) throws ContradictionException {
        this.loadSizeAndCoherence(bin);
        this.status = this.cstr.getStatus(bin);
        this.loadMaintenance(bin);
        if (this.flags.contains(SettingType.FILL_BIN)) {
            this.singleItemEliminationAndCommitmentAndFill(bin);
        } else {
            this.singleItemEliminationAndCommitment(bin);
        }
        if (this.flags.contains(SettingType.ADDITIONAL_RULES) && this.status.getCandidates().cardinality() > 1) {
            NoSum nosum = new NoSum();
            this.noSumPruningRule(nosum, bin);
            this.noSumBinLoads(nosum, bin);
            this.noSumItemEliminationAndCommitment(nosum, bin);
        }
    }

    class NoSum
    extends AbstractNoSum {
        public NoSum() {
            super(PackFiltering.this.sizes);
        }

        @Override
        protected int getCandidatesLoad() {
            return PackFiltering.this.status.getCandidatesLoad();
        }

        @Override
        protected int getLargestItemIndex() {
            return PackFiltering.this.status.getCandidates().nextSetBit(0);
        }

        @Override
        protected int getSmallestItemIndex() {
            return PackFiltering.this.status.getCandidates().length() - 1;
        }

        @Override
        protected int next(int k) {
            return PackFiltering.this.status.getCandidates().nextSetBit(k + 1);
        }

        @Override
        protected int previous(int k) {
            for (int i = k - 1; i >= 0; --i) {
                if (!PackFiltering.this.status.getCandidates().get(i)) continue;
                return i;
            }
            return -1;
        }
    }
}

