/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.pack;

import choco.kernel.common.util.IntIterator;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.BitSet;

class BinStatus {
    private final IntDomainVar[] sizes;
    private int bin;
    private int mLoad;
    private int rLoad;
    private final BitSet candidates;

    public BinStatus(IntDomainVar[] sizes) {
        this.candidates = new BitSet(sizes.length);
        this.sizes = sizes;
    }

    public void set(int bin, SetVar set) {
        this.bin = bin;
        this.mLoad = 0;
        this.rLoad = 0;
        this.candidates.clear();
        IntIterator iter = set.getDomain().getEnveloppeIterator();
        while (iter.hasNext()) {
            int item = iter.next();
            if (set.isInDomainKernel(item)) {
                this.rLoad += this.sizes[item].getVal();
                continue;
            }
            this.candidates.set(item);
            this.mLoad += this.sizes[item].getVal();
        }
        this.mLoad += this.rLoad;
    }

    public void pack(int item) {
        this.candidates.clear(item);
        this.rLoad += this.sizes[item].getVal();
    }

    public void remove(int item) {
        this.candidates.clear(item);
        this.mLoad -= this.sizes[item].getVal();
    }

    public void insertCandidate(int item) {
        this.candidates.set(item);
        this.mLoad += this.sizes[item].getVal();
    }

    public final int getBin() {
        return this.bin;
    }

    public final int getMaxLoad() {
        return this.mLoad;
    }

    public final int getRequiredLoad() {
        return this.rLoad;
    }

    public final int getCandidatesLoad() {
        return this.mLoad - this.rLoad;
    }

    public final BitSet getCandidates() {
        return this.candidates;
    }
}

