/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.pack;

import choco.kernel.common.opres.pack.BestFit1BP;
import choco.kernel.common.opres.pack.LowerBoundFactory;
import java.awt.Point;
import java.util.Arrays;

abstract class AbstractNbNonEmptyBound {
    protected int nextIndex;
    protected final int nbBins;
    protected int nbEmpty;
    protected int nbSome;
    protected int nbFull;
    private int lb;
    protected int nbBinsLB;
    private final int[] itemsLB;
    protected int capacityLB;

    public AbstractNbNonEmptyBound(int nbBins, int nbItems) {
        this.nbBins = nbBins;
        this.itemsLB = new int[nbBins + nbItems];
    }

    protected void reset() {
        this.nbEmpty = 0;
        this.nbSome = 0;
        this.nbFull = 0;
        this.nbBinsLB = 0;
        this.capacityLB = 0;
        this.initialize();
    }

    protected abstract void initialize();

    protected abstract int setUnpackedItems(int[] var1, int var2);

    protected abstract int setBinItems(int[] var1, int var2);

    public int[] getItems() {
        return Arrays.copyOf(this.itemsLB, this.nextIndex);
    }

    protected void computeItems() {
        this.nextIndex = 0;
        this.nextIndex = this.setUnpackedItems(this.itemsLB, this.nextIndex);
        this.nextIndex = this.setBinItems(this.itemsLB, this.nextIndex);
    }

    public Point computeBounds() {
        return new Point(this.nbFull + this.nbSome, this.nbBins - this.nbEmpty);
    }

    public Point computeBoundsDDFF() {
        int[] items;
        int ub;
        this.computeItems();
        if (this.nextIndex > 0 && (ub = new BestFit1BP(items = this.getItems(), this.capacityLB, 1).computeUB()) > this.nbBinsLB) {
            this.lb = this.nbFull + LowerBoundFactory.computeL_DFF_1BP(items, this.capacityLB, ub);
            return new Point(this.lb, this.nbBins - this.nbEmpty);
        }
        return this.computeBounds();
    }
}

